/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.ActionOnBlockBreakPower;
import io.github.apace100.origins.power.ActionOnCallbackPower;
import io.github.apace100.origins.power.ActionOnItemUsePower;
import io.github.apace100.origins.power.ActionOnLandPower;
import io.github.apace100.origins.power.ActionOnWakeUp;
import io.github.apace100.origins.power.ActionOverTimePower;
import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.ActiveCooldownPower;
import io.github.apace100.origins.power.AttackerActionWhenHitPower;
import io.github.apace100.origins.power.AttributePower;
import io.github.apace100.origins.power.BurnPower;
import io.github.apace100.origins.power.ClimbingPower;
import io.github.apace100.origins.power.ConditionedAttributePower;
import io.github.apace100.origins.power.ConditionedRestrictArmorPower;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.DamageOverTimePower;
import io.github.apace100.origins.power.DisableRegenPower;
import io.github.apace100.origins.power.EffectImmunityPower;
import io.github.apace100.origins.power.ElytraFlightPower;
import io.github.apace100.origins.power.EntityGlowPower;
import io.github.apace100.origins.power.ExhaustOverTimePower;
import io.github.apace100.origins.power.FireImmunityPower;
import io.github.apace100.origins.power.FireProjectilePower;
import io.github.apace100.origins.power.IgnoreWaterPower;
import io.github.apace100.origins.power.InventoryPower;
import io.github.apace100.origins.power.InvisibilityPower;
import io.github.apace100.origins.power.InvulnerablePower;
import io.github.apace100.origins.power.LavaVisionPower;
import io.github.apace100.origins.power.ModelColorPower;
import io.github.apace100.origins.power.ModifyBreakSpeedPower;
import io.github.apace100.origins.power.ModifyDamageDealtPower;
import io.github.apace100.origins.power.ModifyDamageTakenPower;
import io.github.apace100.origins.power.ModifyExhaustionPower;
import io.github.apace100.origins.power.ModifyExperiencePower;
import io.github.apace100.origins.power.ModifyFoodPower;
import io.github.apace100.origins.power.ModifyHarvestPower;
import io.github.apace100.origins.power.ModifyJumpPower;
import io.github.apace100.origins.power.ModifyLavaSpeedPower;
import io.github.apace100.origins.power.ModifyPlayerSpawnPower;
import io.github.apace100.origins.power.ModifyProjectileDamagePower;
import io.github.apace100.origins.power.ModifySwimSpeedPower;
import io.github.apace100.origins.power.NightVisionPower;
import io.github.apace100.origins.power.ParticlePower;
import io.github.apace100.origins.power.PhasingPower;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PreventBlockSelectionPower;
import io.github.apace100.origins.power.PreventBlockUsePower;
import io.github.apace100.origins.power.PreventDeathPower;
import io.github.apace100.origins.power.PreventEntityRenderPower;
import io.github.apace100.origins.power.PreventItemUsePower;
import io.github.apace100.origins.power.PreventSleepPower;
import io.github.apace100.origins.power.RecipePower;
import io.github.apace100.origins.power.ResourcePower;
import io.github.apace100.origins.power.RestrictArmorPower;
import io.github.apace100.origins.power.SelfActionOnHitPower;
import io.github.apace100.origins.power.SelfActionOnKillPower;
import io.github.apace100.origins.power.SelfActionWhenHitPower;
import io.github.apace100.origins.power.SetEntityGroupPower;
import io.github.apace100.origins.power.ShaderPower;
import io.github.apace100.origins.power.ShakingPower;
import io.github.apace100.origins.power.StackingStatusEffectPower;
import io.github.apace100.origins.power.StartingEquipmentPower;
import io.github.apace100.origins.power.SwimmingPower;
import io.github.apace100.origins.power.TargetActionOnHitPower;
import io.github.apace100.origins.power.ToggleNightVisionPower;
import io.github.apace100.origins.power.TogglePower;
import io.github.apace100.origins.power.WalkOnFluidPower;
import io.github.apace100.origins.power.factory.PowerFactory;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModDamageSources;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.AttributedEntityAttributeModifier;
import io.github.apace100.origins.util.ClassUtil;
import io.github.apace100.origins.util.HudRender;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.server.ServerWorld;

public class PowerFactories {
    public static void register() {
        PowerFactories.register(new PowerFactory(Origins.identifier("simple"), new SerializableData(), data -> Power::new).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("toggle"), new SerializableData().add("active_by_default", SerializableDataType.BOOLEAN, true).add("key", SerializableDataType.BACKWARDS_COMPATIBLE_KEY, new Active.Key()), data -> (type, player) -> {
            TogglePower power = new TogglePower((PowerType<?>)type, (PlayerEntity)player, data.getBoolean("active_by_default"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("attribute"), new SerializableData().add("modifier", SerializableDataType.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null), data -> (type, player) -> {
            AttributePower ap = new AttributePower((PowerType<?>)type, (PlayerEntity)player);
            if (data.isPresent("modifier")) {
                ap.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                List modifierList = (List)data.get("modifiers");
                modifierList.forEach(ap::addModifier);
            }
            return ap;
        }));
        PowerFactories.register(new PowerFactory(Origins.identifier("burn"), new SerializableData().add("interval", SerializableDataType.INT).add("burn_duration", SerializableDataType.INT), data -> (type, player) -> new BurnPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("interval"), data.getInt("burn_duration"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("cooldown"), new SerializableData().add("cooldown", SerializableDataType.INT).add("hud_render", SerializableDataType.HUD_RENDER), data -> (type, player) -> new CooldownPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("effect_immunity"), new SerializableData().add("effect", SerializableDataType.STATUS_EFFECT, null).add("effects", SerializableDataType.STATUS_EFFECTS, null), data -> (type, player) -> {
            EffectImmunityPower power = new EffectImmunityPower((PowerType<?>)type, (PlayerEntity)player);
            if (data.isPresent("effect")) {
                power.addEffect((Effect)data.get("effect"));
            }
            if (data.isPresent("effects")) {
                ((List)data.get("effects")).forEach(power::addEffect);
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("elytra_flight"), new SerializableData().add("render_elytra", SerializableDataType.BOOLEAN), data -> (type, player) -> new ElytraFlightPower((PowerType<?>)type, (PlayerEntity)player, data.getBoolean("render_elytra"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("entity_group"), new SerializableData().add("group", SerializableDataType.ENTITY_GROUP), data -> (type, player) -> new SetEntityGroupPower((PowerType<?>)type, (PlayerEntity)player, (CreatureAttribute)data.get("group"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("exhaust"), new SerializableData().add("interval", SerializableDataType.INT).add("exhaustion", SerializableDataType.FLOAT), data -> (type, player) -> new ExhaustOverTimePower((PowerType<?>)type, (PlayerEntity)player, data.getInt("interval"), data.getFloat("exhaustion"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("fire_projectile"), new SerializableData().add("cooldown", SerializableDataType.INT).add("count", SerializableDataType.INT, 1).add("speed", SerializableDataType.FLOAT, Float.valueOf(1.5f)).add("divergence", SerializableDataType.FLOAT, Float.valueOf(1.0f)).add("sound", SerializableDataType.SOUND_EVENT, null).add("entity_type", SerializableDataType.ENTITY_TYPE).add("hud_render", SerializableDataType.HUD_RENDER).add("tag", SerializableDataType.NBT, null).add("key", SerializableDataType.BACKWARDS_COMPATIBLE_KEY, new Active.Key()), data -> (type, player) -> {
            FireProjectilePower power = new FireProjectilePower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (EntityType<?>)((EntityType)data.get("entity_type")), data.getInt("count"), data.getFloat("speed"), data.getFloat("divergence"), (SoundEvent)data.get("sound"), (CompoundNBT)data.get("tag"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("inventory"), new SerializableData().add("name", SerializableDataType.STRING, "container.inventory").add("drop_on_death", SerializableDataType.BOOLEAN, false).add("drop_on_death_filter", SerializableDataType.ITEM_CONDITION, null).add("key", SerializableDataType.BACKWARDS_COMPATIBLE_KEY, new Active.Key()), data -> (type, player) -> {
            InventoryPower power = new InventoryPower((PowerType<?>)type, (PlayerEntity)player, (String)data.get("name"), 9, data.getBoolean("drop_on_death"), data.isPresent("drop_on_death_filter") ? (Predicate)data.get("drop_on_death_filter") : itemStack -> true);
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("invisibility"), new SerializableData().add("render_armor", SerializableDataType.BOOLEAN), data -> (type, player) -> new InvisibilityPower((PowerType<?>)type, (PlayerEntity)player, data.getBoolean("render_armor"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("invulnerability"), new SerializableData().add("damage_condition", SerializableDataType.DAMAGE_CONDITION), data -> (type, player) -> {
            ConditionFactory.Instance damageCondition = (ConditionFactory.Instance)data.get("damage_condition");
            return new InvulnerablePower((PowerType<?>)type, (PlayerEntity)player, ds -> damageCondition.test(new Tuple(ds, null)));
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("launch"), new SerializableData().add("cooldown", SerializableDataType.INT).add("speed", SerializableDataType.FLOAT).add("sound", SerializableDataType.SOUND_EVENT, null).add("hud_render", SerializableDataType.HUD_RENDER).add("key", SerializableDataType.BACKWARDS_COMPATIBLE_KEY, new Active.Key()), data -> {
            SoundEvent soundEvent = (SoundEvent)data.get("sound");
            return (type, player) -> {
                ActiveCooldownPower power = new ActiveCooldownPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), e -> {
                    if (!e.field_70170_p.field_72995_K && e instanceof PlayerEntity) {
                        PlayerEntity p = (PlayerEntity)e;
                        p.func_70024_g(0.0, (double)data.getFloat("speed"), 0.0);
                        p.field_70133_I = true;
                        if (soundEvent != null) {
                            p.field_70170_p.func_184148_a(null, p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_(), soundEvent, SoundCategory.NEUTRAL, 0.5f, 0.4f / (p.func_70681_au().nextFloat() * 0.4f + 0.8f));
                        }
                        for (int i = 0; i < 4; ++i) {
                            ((ServerWorld)p.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197613_f, p.func_226277_ct_(), p.func_226279_cv_(), p.func_226281_cx_(), 8, p.func_70681_au().nextGaussian(), 0.0, p.func_70681_au().nextGaussian(), 0.5);
                        }
                    }
                });
                power.setKey((Active.Key)data.get("key"));
                return power;
            };
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("model_color"), new SerializableData().add("red", SerializableDataType.FLOAT, Float.valueOf(1.0f)).add("green", SerializableDataType.FLOAT, Float.valueOf(1.0f)).add("blue", SerializableDataType.FLOAT, Float.valueOf(1.0f)).add("alpha", SerializableDataType.FLOAT, Float.valueOf(1.0f)), data -> (type, player) -> new ModelColorPower((PowerType<?>)type, (PlayerEntity)player, data.getFloat("red"), data.getFloat("green"), data.getFloat("blue"), data.getFloat("alpha"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_break_speed"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION, null).add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null), data -> (type, player) -> {
            ModifyBreakSpeedPower power = new ModifyBreakSpeedPower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("block_condition") ? (Predicate)data.get("block_condition") : cbp -> true);
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_damage_dealt"), new SerializableData().add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null).add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null).add("target_condition", SerializableDataType.ENTITY_CONDITION, null).add("self_action", SerializableDataType.ENTITY_ACTION, null).add("target_action", SerializableDataType.ENTITY_ACTION, null), data -> (type, player) -> {
            ModifyDamageDealtPower power = new ModifyDamageDealtPower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true, (Predicate)data.get("target_condition"));
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("target_action")) {
                power.setTargetAction((Consumer)data.get("target_action"));
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_damage_taken"), new SerializableData().add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null).add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null).add("self_action", SerializableDataType.ENTITY_ACTION, null).add("attacker_action", SerializableDataType.ENTITY_ACTION, null), data -> (type, player) -> {
            ModifyDamageTakenPower power = new ModifyDamageTakenPower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true);
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("attacker_action")) {
                power.setAttackerAction((Consumer)data.get("attacker_action"));
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_exhaustion"), new SerializableData().add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null), data -> (type, player) -> {
            ModifyExhaustionPower power = new ModifyExhaustionPower((PowerType<?>)type, (PlayerEntity)player);
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_harvest"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION, null).add("allow", SerializableDataType.BOOLEAN), data -> (type, player) -> new ModifyHarvestPower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("block_condition") ? (Predicate)data.get("block_condition") : cbp -> true, data.getBoolean("allow"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_jump"), new SerializableData().add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null).add("entity_action", SerializableDataType.ENTITY_ACTION, null), data -> (type, player) -> {
            ModifyJumpPower power = new ModifyJumpPower((PowerType<?>)type, (PlayerEntity)player, (Consumer)data.get("entity_action"));
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_player_spawn"), new SerializableData().add("dimension", SerializableDataType.DIMENSION).add("dimension_distance_multiplier", SerializableDataType.FLOAT, Float.valueOf(0.0f)).add("biome", SerializableDataType.IDENTIFIER, null).add("spawn_strategy", SerializableDataType.STRING, "default").add("structure", SerializableDataType.registry(ClassUtil.castClass(Structure.class), Registry.field_218361_B), null).add("respawn_sound", SerializableDataType.SOUND_EVENT, null), data -> (type, player) -> new ModifyPlayerSpawnPower((PowerType<?>)type, (PlayerEntity)player, (RegistryKey<World>)((RegistryKey)data.get("dimension")), data.getFloat("dimension_distance_multiplier"), (ResourceLocation)data.get("biome"), (String)data.get("spawn_strategy"), (Structure<?>)(data.isPresent("structure") ? (Structure)data.get("structure") : null), (SoundEvent)data.get("respawn_sound"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("night_vision"), new SerializableData().add("strength", SerializableDataType.FLOAT, Float.valueOf(1.0f)), data -> (type, player) -> new NightVisionPower((PowerType<?>)type, (PlayerEntity)player, data.getFloat("strength"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("particle"), new SerializableData().add("particle", SerializableDataType.PARTICLE_TYPE).add("frequency", SerializableDataType.INT), data -> (type, player) -> new ParticlePower((PowerType<?>)type, (PlayerEntity)player, (IParticleData)data.get("particle"), data.getInt("frequency"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("phasing"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION, null).add("blacklist", SerializableDataType.BOOLEAN, false).add("render_type", SerializableDataType.enumValue(PhasingPower.RenderType.class), PhasingPower.RenderType.BLINDNESS).add("view_distance", SerializableDataType.FLOAT, Float.valueOf(10.0f)).add("phase_down_condition", SerializableDataType.ENTITY_CONDITION, null), data -> (type, player) -> new PhasingPower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("block_condition") ? (Predicate)data.get("block_condition") : cbp -> true, data.getBoolean("blacklist"), (PhasingPower.RenderType)((Object)((Object)((Object)data.get("render_type")))), data.getFloat("view_distance"), (Predicate)data.get("phase_down_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("prevent_item_use"), new SerializableData().add("item_condition", SerializableDataType.ITEM_CONDITION, null), data -> (type, player) -> new PreventItemUsePower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("item_condition") ? (Predicate)data.get("item_condition") : item -> true)).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("prevent_sleep"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION, null).add("message", SerializableDataType.STRING, "origins.cant_sleep").add("set_spawn_point", SerializableDataType.BOOLEAN, false), data -> (type, player) -> new PreventSleepPower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("block_condition") ? (Predicate)data.get("block_condition") : cbp -> true, (String)data.get("message"), data.getBoolean("set_spawn_point"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("restrict_armor"), new SerializableData().add("head", SerializableDataType.ITEM_CONDITION, null).add("chest", SerializableDataType.ITEM_CONDITION, null).add("legs", SerializableDataType.ITEM_CONDITION, null).add("feet", SerializableDataType.ITEM_CONDITION, null), data -> (type, player) -> {
            HashMap<EquipmentSlotType, Predicate<ItemStack>> restrictions = new HashMap<EquipmentSlotType, Predicate<ItemStack>>();
            if (data.isPresent("head")) {
                restrictions.put(EquipmentSlotType.HEAD, (Predicate)data.get("head"));
            }
            if (data.isPresent("chest")) {
                restrictions.put(EquipmentSlotType.CHEST, (Predicate)data.get("chest"));
            }
            if (data.isPresent("legs")) {
                restrictions.put(EquipmentSlotType.LEGS, (Predicate)data.get("legs"));
            }
            if (data.isPresent("feet")) {
                restrictions.put(EquipmentSlotType.FEET, (Predicate)data.get("feet"));
            }
            return new RestrictArmorPower((PowerType<?>)type, (PlayerEntity)player, restrictions);
        }));
        PowerFactories.register(new PowerFactory(Origins.identifier("conditioned_restrict_armor"), new SerializableData().add("head", SerializableDataType.ITEM_CONDITION, null).add("chest", SerializableDataType.ITEM_CONDITION, null).add("legs", SerializableDataType.ITEM_CONDITION, null).add("feet", SerializableDataType.ITEM_CONDITION, null).add("tick_rate", SerializableDataType.INT, 80), data -> (type, player) -> {
            HashMap<EquipmentSlotType, Predicate<ItemStack>> restrictions = new HashMap<EquipmentSlotType, Predicate<ItemStack>>();
            if (data.isPresent("head")) {
                restrictions.put(EquipmentSlotType.HEAD, (Predicate)data.get("head"));
            }
            if (data.isPresent("chest")) {
                restrictions.put(EquipmentSlotType.CHEST, (Predicate)data.get("chest"));
            }
            if (data.isPresent("legs")) {
                restrictions.put(EquipmentSlotType.LEGS, (Predicate)data.get("legs"));
            }
            if (data.isPresent("feet")) {
                restrictions.put(EquipmentSlotType.FEET, (Predicate)data.get("feet"));
            }
            return new ConditionedRestrictArmorPower((PowerType<?>)type, (PlayerEntity)player, restrictions, data.getInt("tick_rate"));
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("stacking_status_effect"), new SerializableData().add("min_stacks", SerializableDataType.INT).add("max_stacks", SerializableDataType.INT).add("duration_per_stack", SerializableDataType.INT).add("effect", SerializableDataType.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataType.STATUS_EFFECT_INSTANCES, null), data -> (type, player) -> {
            StackingStatusEffectPower power = new StackingStatusEffectPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("min_stacks"), data.getInt("max_stacks"), data.getInt("duration_per_stack"));
            if (data.isPresent("effect")) {
                power.addEffect((EffectInstance)data.get("effect"));
            }
            if (data.isPresent("effects")) {
                ((List)data.get("effects")).forEach(power::addEffect);
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_swim_speed"), new SerializableData().add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null), data -> (type, player) -> {
            ModifySwimSpeedPower power = new ModifySwimSpeedPower((PowerType<?>)type, (PlayerEntity)player);
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("toggle_night_vision"), new SerializableData().add("active_by_default", SerializableDataType.BOOLEAN, false).add("strength", SerializableDataType.FLOAT, Float.valueOf(1.0f)).add("key", SerializableDataType.BACKWARDS_COMPATIBLE_KEY, new Active.Key()), data -> (type, player) -> {
            ToggleNightVisionPower power = new ToggleNightVisionPower((PowerType<?>)type, (PlayerEntity)player, data.getFloat("strength"), data.getBoolean("active_by_default"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("damage_over_time"), new SerializableData().add("interval", SerializableDataType.INT).addFunctionedDefault("onset_delay", SerializableDataType.INT, data -> data.getInt("interval")).add("damage", SerializableDataType.FLOAT).addFunctionedDefault("damage_easy", SerializableDataType.FLOAT, data -> Float.valueOf(data.getFloat("damage"))).add("damage_source", SerializableDataType.DAMAGE_SOURCE, ModDamageSources.GENERIC_DOT).add("protection_enchantment", SerializableDataType.ENCHANTMENT, null).add("protection_effectiveness", SerializableDataType.FLOAT, Float.valueOf(1.0f)), data -> (type, player) -> new DamageOverTimePower((PowerType<?>)type, (PlayerEntity)player, data.getInt("onset_delay"), data.getInt("interval"), data.getFloat("damage_easy"), data.getFloat("damage"), (DamageSource)data.get("damage_source"), (Enchantment)data.get("protection_enchantment"), data.getFloat("protection_effectiveness"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("swimming"), new SerializableData(), data -> SwimmingPower::new).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("fire_immunity"), new SerializableData(), data -> FireImmunityPower::new).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_lava_speed"), new SerializableData().add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null), data -> (type, player) -> {
            ModifyLavaSpeedPower power = new ModifyLavaSpeedPower((PowerType<?>)type, (PlayerEntity)player);
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("lava_vision"), new SerializableData().add("s", SerializableDataType.FLOAT).add("v", SerializableDataType.FLOAT), data -> (type, player) -> new LavaVisionPower((PowerType<?>)type, (PlayerEntity)player, data.getFloat("s"), data.getFloat("v"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("conditioned_attribute"), new SerializableData().add("modifier", SerializableDataType.ATTRIBUTED_ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTED_ATTRIBUTE_MODIFIERS, null).add("tick_rate", SerializableDataType.INT, 20), data -> (type, player) -> {
            ConditionedAttributePower ap = new ConditionedAttributePower((PowerType<?>)type, (PlayerEntity)player, data.getInt("tick_rate"));
            if (data.isPresent("modifier")) {
                ap.addModifier((AttributedEntityAttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                List modifierList = (List)data.get("modifiers");
                modifierList.forEach(ap::addModifier);
            }
            return ap;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("active_self"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION).add("cooldown", SerializableDataType.INT).add("hud_render", SerializableDataType.HUD_RENDER).add("key", SerializableDataType.BACKWARDS_COMPATIBLE_KEY, new Active.Key()), data -> (type, player) -> {
            ActiveCooldownPower power = new ActiveCooldownPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (Consumer)data.get("entity_action"));
            power.setKey((Active.Key)data.get("key"));
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("action_over_time"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION, null).add("rising_action", SerializableDataType.ENTITY_ACTION, null).add("falling_action", SerializableDataType.ENTITY_ACTION, null).add("interval", SerializableDataType.INT), data -> (type, player) -> new ActionOverTimePower((PowerType<?>)type, (PlayerEntity)player, data.getInt("interval"), (Consumer)data.get("entity_action"), (Consumer)data.get("rising_action"), (Consumer)data.get("falling_action"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("self_action_when_hit"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION).add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null).add("cooldown", SerializableDataType.INT).add("hud_render", SerializableDataType.HUD_RENDER, HudRender.DONT_RENDER), data -> (type, player) -> new SelfActionWhenHitPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (Predicate)data.get("damage_condition"), (Consumer)data.get("entity_action"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("attacker_action_when_hit"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION).add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null).add("cooldown", SerializableDataType.INT).add("hud_render", SerializableDataType.HUD_RENDER, HudRender.DONT_RENDER), data -> (type, player) -> new AttackerActionWhenHitPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (Predicate)data.get("damage_condition"), (Consumer)data.get("entity_action"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("self_action_on_hit"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION).add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null).add("cooldown", SerializableDataType.INT).add("hud_render", SerializableDataType.HUD_RENDER, HudRender.DONT_RENDER).add("target_condition", SerializableDataType.ENTITY_CONDITION, null), data -> (type, player) -> new SelfActionOnHitPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (Predicate)data.get("damage_condition"), (Consumer)data.get("entity_action"), (Predicate)data.get("target_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("target_action_on_hit"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION).add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null).add("cooldown", SerializableDataType.INT).add("hud_render", SerializableDataType.HUD_RENDER, HudRender.DONT_RENDER).add("target_condition", SerializableDataType.ENTITY_CONDITION, null), data -> (type, player) -> new TargetActionOnHitPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (Predicate)data.get("damage_condition"), (Consumer)data.get("entity_action"), (Predicate)data.get("target_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("starting_equipment"), new SerializableData().add("stack", SerializableDataType.POSITIONED_ITEM_STACK, null).add("stacks", SerializableDataType.POSITIONED_ITEM_STACKS, null).add("recurrent", SerializableDataType.BOOLEAN, false), data -> (type, player) -> {
            StartingEquipmentPower power = new StartingEquipmentPower((PowerType<?>)type, (PlayerEntity)player);
            if (data.isPresent("stack")) {
                Tuple stack = (Tuple)data.get("stack");
                int slot = (Integer)stack.func_76341_a();
                if (slot > Integer.MIN_VALUE) {
                    power.addStack((Integer)stack.func_76341_a(), (ItemStack)stack.func_76340_b());
                } else {
                    power.addStack((ItemStack)stack.func_76340_b());
                }
            }
            if (data.isPresent("stacks")) {
                ((List)data.get("stacks")).forEach(integerItemStackPair -> {
                    int slot = (Integer)integerItemStackPair.func_76341_a();
                    if (slot > Integer.MIN_VALUE) {
                        power.addStack((Integer)integerItemStackPair.func_76341_a(), (ItemStack)integerItemStackPair.func_76340_b());
                    } else {
                        power.addStack((ItemStack)integerItemStackPair.func_76340_b());
                    }
                });
            }
            power.setRecurrent(data.getBoolean("recurrent"));
            return power;
        }));
        PowerFactories.register(new PowerFactory(Origins.identifier("action_on_callback"), new SerializableData().add("entity_action_respawned", SerializableDataType.ENTITY_ACTION, null).add("entity_action_removed", SerializableDataType.ENTITY_ACTION, null).add("entity_action_chosen", SerializableDataType.ENTITY_ACTION, null).add("entity_action_lost", SerializableDataType.ENTITY_ACTION, null).add("entity_action_added", SerializableDataType.ENTITY_ACTION, null).add("execute_chosen_when_orb", SerializableDataType.BOOLEAN, true), data -> (type, player) -> new ActionOnCallbackPower((PowerType<?>)type, (PlayerEntity)player, (Consumer)data.get("entity_action_respawned"), (Consumer)data.get("entity_action_removed"), (Consumer)data.get("entity_action_chosen"), (Consumer)data.get("entity_action_lost"), (Consumer)data.get("entity_action_added"), data.getBoolean("execute_chosen_when_orb"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("walk_on_fluid"), new SerializableData().add("fluid", SerializableDataType.FLUID_TAG), data -> (type, player) -> new WalkOnFluidPower((PowerType<?>)type, (PlayerEntity)player, (ITag<Fluid>)((ITag)data.get("fluid")))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("shader"), new SerializableData().add("shader", SerializableDataType.IDENTIFIER), data -> (type, player) -> new ShaderPower((PowerType<?>)type, (PlayerEntity)player, (ResourceLocation)data.get("shader"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("shaking"), new SerializableData(), data -> ShakingPower::new).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("disable_regen"), new SerializableData(), data -> DisableRegenPower::new).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("resource"), new SerializableData().add("min", SerializableDataType.INT).add("max", SerializableDataType.INT).addFunctionedDefault("start_value", SerializableDataType.INT, data -> data.getInt("min")).add("hud_render", SerializableDataType.HUD_RENDER).add("min_action", SerializableDataType.ENTITY_ACTION, null).add("max_action", SerializableDataType.ENTITY_ACTION, null), data -> (type, player) -> new ResourcePower((PowerType<?>)type, (PlayerEntity)player, (HudRender)data.get("hud_render"), data.getInt("start_value"), data.getInt("min"), data.getInt("max"), (Consumer)data.get("min_action"), (Consumer)data.get("max_action"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_food"), new SerializableData().add("item_condition", SerializableDataType.ITEM_CONDITION, null).add("food_modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("food_modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null).add("saturation_modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("saturation_modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null).add("entity_action", SerializableDataType.ENTITY_ACTION, null), data -> (type, player) -> {
            List modifierList;
            LinkedList<AttributeModifier> foodModifiers = new LinkedList<AttributeModifier>();
            LinkedList<AttributeModifier> saturationModifiers = new LinkedList<AttributeModifier>();
            if (data.isPresent("food_modifier")) {
                foodModifiers.add((AttributeModifier)data.get("food_modifier"));
            }
            if (data.isPresent("food_modifiers")) {
                modifierList = (List)data.get("food_modifiers");
                foodModifiers.addAll(modifierList);
            }
            if (data.isPresent("saturation_modifier")) {
                saturationModifiers.add((AttributeModifier)data.get("saturation_modifier"));
            }
            if (data.isPresent("saturation_modifiers")) {
                modifierList = (List)data.get("saturation_modifiers");
                saturationModifiers.addAll(modifierList);
            }
            return new ModifyFoodPower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("item_condition") ? (Predicate)data.get("item_condition") : stack -> true, (List<AttributeModifier>)foodModifiers, (List<AttributeModifier>)saturationModifiers, (Consumer)data.get("entity_action"));
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_xp_gain"), new SerializableData().add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null), data -> (type, player) -> {
            ModifyExperiencePower power = new ModifyExperiencePower((PowerType<?>)type, (PlayerEntity)player);
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("action_on_block_break"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION, null).add("block_action", SerializableDataType.BLOCK_ACTION, null).add("block_condition", SerializableDataType.BLOCK_CONDITION, null).add("only_when_harvested", SerializableDataType.BOOLEAN, true), data -> (type, player) -> new ActionOnBlockBreakPower((PowerType<?>)type, (PlayerEntity)player, (Predicate)data.get("block_condition"), (Consumer)data.get("entity_action"), (Consumer)data.get("block_action"), data.getBoolean("only_when_harvested"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("action_on_land"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION, null), data -> (type, player) -> new ActionOnLandPower((PowerType<?>)type, (PlayerEntity)player, (Consumer)data.get("entity_action"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("prevent_entity_render"), new SerializableData().add("entity_condition", SerializableDataType.ENTITY_CONDITION, null), data -> (type, player) -> new PreventEntityRenderPower((PowerType<?>)type, (PlayerEntity)player, (Predicate)data.get("entity_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("entity_glow"), new SerializableData().add("entity_condition", SerializableDataType.ENTITY_CONDITION, null), data -> (type, player) -> new EntityGlowPower((PowerType<?>)type, (PlayerEntity)player, (Predicate)data.get("entity_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("climbing"), new SerializableData().add("allow_holding", SerializableDataType.BOOLEAN, true).add("hold_condition", SerializableDataType.ENTITY_CONDITION, null), data -> (type, player) -> {
            Predicate holdCondition = (Predicate)data.get("hold_condition");
            return new ClimbingPower((PowerType<?>)type, (PlayerEntity)player, data.getBoolean("allow_holding"), holdCondition);
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("prevent_block_selection"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION, null), data -> (type, player) -> new PreventBlockSelectionPower((PowerType<?>)type, (PlayerEntity)player, (Predicate)data.get("block_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("self_action_on_kill"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION).add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null).add("cooldown", SerializableDataType.INT).add("hud_render", SerializableDataType.HUD_RENDER, HudRender.DONT_RENDER).add("target_condition", SerializableDataType.ENTITY_CONDITION, null), data -> (type, player) -> new SelfActionOnKillPower((PowerType<?>)type, (PlayerEntity)player, data.getInt("cooldown"), (HudRender)data.get("hud_render"), (Predicate)data.get("damage_condition"), (Consumer)data.get("entity_action"), (Predicate)data.get("target_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("recipe"), new SerializableData().add("recipe", SerializableDataType.RECIPE), data -> (type, player) -> {
            IRecipe recipe = (IRecipe)data.get("recipe");
            return new RecipePower((PowerType<?>)type, (PlayerEntity)player, (IRecipe<CraftingInventory>)recipe);
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("ignore_water"), new SerializableData(), data -> IgnoreWaterPower::new).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("modify_projectile_damage"), new SerializableData().add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null).add("modifier", SerializableDataType.ATTRIBUTE_MODIFIER, null).add("modifiers", SerializableDataType.ATTRIBUTE_MODIFIERS, null).add("target_condition", SerializableDataType.ENTITY_CONDITION, null).add("self_action", SerializableDataType.ENTITY_ACTION, null).add("target_action", SerializableDataType.ENTITY_ACTION, null), data -> (type, player) -> {
            ModifyProjectileDamagePower power = new ModifyProjectileDamagePower((PowerType<?>)type, (PlayerEntity)player, data.isPresent("damage_condition") ? (Predicate)data.get("damage_condition") : dmg -> true, (Predicate)data.get("target_condition"));
            if (data.isPresent("modifier")) {
                power.addModifier((AttributeModifier)data.get("modifier"));
            }
            if (data.isPresent("modifiers")) {
                ((List)data.get("modifiers")).forEach(power::addModifier);
            }
            if (data.isPresent("self_action")) {
                power.setSelfAction((Consumer)data.get("self_action"));
            }
            if (data.isPresent("target_action")) {
                power.setTargetAction((Consumer)data.get("target_action"));
            }
            return power;
        }).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("action_on_wake_up"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION, null).add("block_action", SerializableDataType.BLOCK_ACTION, null).add("block_condition", SerializableDataType.BLOCK_CONDITION, null), data -> (type, player) -> new ActionOnWakeUp((PowerType<?>)type, (PlayerEntity)player, (Predicate)data.get("block_condition"), (Consumer)data.get("entity_action"), (Consumer)data.get("block_action"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("prevent_block_use"), new SerializableData().add("block_condition", SerializableDataType.BLOCK_CONDITION, null), data -> (type, player) -> new PreventBlockUsePower((PowerType<?>)type, (PlayerEntity)player, (Predicate)data.get("block_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("prevent_death"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION, null).add("damage_condition", SerializableDataType.DAMAGE_CONDITION, null), data -> (type, player) -> new PreventDeathPower((PowerType<?>)type, (PlayerEntity)player, (Consumer)data.get("entity_action"), (Predicate)data.get("damage_condition"))).allowCondition());
        PowerFactories.register(new PowerFactory(Origins.identifier("action_on_item_use"), new SerializableData().add("entity_action", SerializableDataType.ENTITY_ACTION, null).add("item_action", SerializableDataType.ITEM_ACTION, null).add("item_condition", SerializableDataType.ITEM_CONDITION, null), data -> (type, player) -> new ActionOnItemUsePower((PowerType<?>)type, (PlayerEntity)player, (Predicate)data.get("item_condition"), (Consumer)data.get("entity_action"), (Consumer)data.get("item_action"))).allowCondition());
    }

    private static void register(PowerFactory<?> serializer) {
        ModRegistriesArchitectury.POWER_FACTORY.register(serializer.getSerializerId(), () -> serializer);
    }
}

