/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory;

import com.google.gson.JsonObject;
import io.github.apace100.origins.power.Power;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import me.shedaniel.architectury.core.RegistryEntry;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class PowerFactory<P extends Power>
extends RegistryEntry<PowerFactory<?>> {
    private final ResourceLocation id;
    private boolean hasConditions = false;
    protected SerializableData data;
    protected Function<SerializableData.Instance, BiFunction<PowerType<P>, PlayerEntity, P>> factoryConstructor;

    public PowerFactory(ResourceLocation id, SerializableData data, Function<SerializableData.Instance, BiFunction<PowerType<P>, PlayerEntity, P>> factoryConstructor) {
        this.id = id;
        this.data = data;
        this.factoryConstructor = factoryConstructor;
    }

    public PowerFactory<P> allowCondition() {
        if (!this.hasConditions) {
            this.hasConditions = true;
            this.data.add("condition", SerializableDataType.ENTITY_CONDITION, null);
        }
        return this;
    }

    public ResourceLocation getSerializerId() {
        return this.id;
    }

    public Instance read(JsonObject json) {
        return new Instance(this.data.read(json));
    }

    public Instance read(PacketBuffer buffer) {
        return new Instance(this.data.read(buffer));
    }

    public class Instance
    implements BiFunction<PowerType<P>, PlayerEntity, P> {
        private final SerializableData.Instance dataInstance;

        private Instance(SerializableData.Instance data) {
            this.dataInstance = data;
        }

        public void write(PacketBuffer buf) {
            buf.func_192572_a(PowerFactory.this.id);
            PowerFactory.this.data.write(buf, this.dataInstance);
        }

        @Override
        public P apply(PowerType<P> pPowerType, PlayerEntity playerEntity) {
            BiFunction powerFactory = PowerFactory.this.factoryConstructor.apply(this.dataInstance);
            Power p = (Power)powerFactory.apply(pPowerType, playerEntity);
            if (PowerFactory.this.hasConditions && this.dataInstance.isPresent("condition")) {
                p.addCondition((Predicate)this.dataInstance.get("condition"));
            }
            return p;
        }
    }
}

