/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.action;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.CooldownPower;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.VariableIntPower;
import io.github.apace100.origins.power.factory.action.ActionFactory;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.ClassUtil;
import io.github.apace100.origins.util.FilterableWeightedList;
import io.github.apace100.origins.util.Scheduler;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import io.github.apace100.origins.util.Space;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.server.ServerWorld;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.logging.log4j.util.TriConsumer;

public class EntityActions {
    public static void register() {
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("and"), new SerializableData().add("actions", SerializableDataType.ENTITY_ACTIONS), (data, entity) -> ((List)data.get("actions")).forEach(e -> e.accept(entity))));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("chance"), new SerializableData().add("action", SerializableDataType.ENTITY_ACTION).add("chance", SerializableDataType.FLOAT), (data, entity) -> {
            Random random = new Random();
            if (random.nextFloat() < data.getFloat("chance")) {
                ((ActionFactory.Instance)data.get("action")).accept(entity);
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("if_else"), new SerializableData().add("condition", SerializableDataType.ENTITY_CONDITION).add("if_action", SerializableDataType.ENTITY_ACTION).add("else_action", SerializableDataType.ENTITY_ACTION, null), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                if (((ConditionFactory.Instance)data.get("condition")).test((LivingEntity)entity)) {
                    ((ActionFactory.Instance)data.get("if_action")).accept(entity);
                } else if (data.isPresent("else_action")) {
                    ((ActionFactory.Instance)data.get("else_action")).accept(entity);
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("choice"), new SerializableData().add("actions", SerializableDataType.weightedList(SerializableDataType.ENTITY_ACTION)), (data, entity) -> {
            FilterableWeightedList actionList = (FilterableWeightedList)((Object)((Object)data.get("actions")));
            ActionFactory.Instance action = (ActionFactory.Instance)actionList.func_226318_b_(new Random());
            action.accept(entity);
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("if_else_list"), new SerializableData().add("actions", SerializableDataType.list(SerializableDataType.compound(ClassUtil.castClass(Tuple.class), new SerializableData().add("action", SerializableDataType.ENTITY_ACTION).add("condition", SerializableDataType.ENTITY_CONDITION), inst -> new Tuple((Object)((ConditionFactory.Instance)inst.get("condition")), (Object)((ActionFactory.Instance)inst.get("action"))), (data, pair) -> {
            SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
            inst.set("condition", pair.func_76341_a());
            inst.set("action", pair.func_76340_b());
            return inst;
        }))), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                List actions = (List)data.get("actions");
                for (Tuple action : actions) {
                    if (!((ConditionFactory.Instance)action.func_76341_a()).test(entity)) continue;
                    ((ActionFactory.Instance)action.func_76340_b()).accept(entity);
                    break;
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("damage"), new SerializableData().add("amount", SerializableDataType.FLOAT).add("source", SerializableDataType.DAMAGE_SOURCE), (data, entity) -> entity.func_70097_a((DamageSource)data.get("source"), data.getFloat("amount"))));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("heal"), new SerializableData().add("amount", SerializableDataType.FLOAT), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).func_70691_i(data.getFloat("amount"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("play_sound"), new SerializableData().add("sound", SerializableDataType.SOUND_EVENT).add("volume", SerializableDataType.FLOAT, Float.valueOf(1.0f)).add("pitch", SerializableDataType.FLOAT, Float.valueOf(1.0f)), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                entity.field_70170_p.func_184148_a((PlayerEntity)null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), (SoundEvent)data.get("sound"), SoundCategory.PLAYERS, data.getFloat("volume"), data.getFloat("pitch"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("exhaust"), new SerializableData().add("amount", SerializableDataType.FLOAT), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_71024_bL().func_75113_a(data.getFloat("amount"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("apply_effect"), new SerializableData().add("effect", SerializableDataType.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataType.STATUS_EFFECT_INSTANCES, null), (data, entity) -> {
            if (entity instanceof LivingEntity && !entity.field_70170_p.field_72995_K) {
                LivingEntity le = (LivingEntity)entity;
                if (data.isPresent("effect")) {
                    EffectInstance effect = (EffectInstance)data.get("effect");
                    le.func_195064_c(new EffectInstance(effect));
                }
                if (data.isPresent("effects")) {
                    ((List)data.get("effects")).forEach(e -> le.func_195064_c(new EffectInstance(e)));
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("clear_effect"), new SerializableData().add("effect", SerializableDataType.STATUS_EFFECT, null), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                if (data.isPresent("effect")) {
                    le.func_195063_d((Effect)data.get("effect"));
                } else {
                    le.func_195061_cb();
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("set_on_fire"), new SerializableData().add("duration", SerializableDataType.INT), (data, entity) -> entity.func_70015_d(data.getInt("duration"))));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("add_velocity"), new SerializableData().add("x", SerializableDataType.FLOAT, Float.valueOf(0.0f)).add("y", SerializableDataType.FLOAT, Float.valueOf(0.0f)).add("z", SerializableDataType.FLOAT, Float.valueOf(0.0f)).add("space", SerializableDataType.SPACE, Space.WORLD).add("set", SerializableDataType.BOOLEAN, false), (data, entity) -> {
            Space space = (Space)((Object)((Object)data.get("space")));
            Vector3f vec = new Vector3f(data.getFloat("x"), data.getFloat("y"), data.getFloat("z"));
            TriConsumer method = (arg_0, arg_1, arg_2) -> ((Entity)entity).func_70024_g(arg_0, arg_1, arg_2);
            if (data.getBoolean("set")) {
                method = (arg_0, arg_1, arg_2) -> ((Entity)entity).func_213293_j(arg_0, arg_1, arg_2);
            }
            switch (space) {
                case WORLD: {
                    method.accept((Object)Float.valueOf(data.getFloat("x")), (Object)Float.valueOf(data.getFloat("y")), (Object)Float.valueOf(data.getFloat("z")));
                    break;
                }
                case LOCAL: {
                    Space.rotateVectorToBase(entity.func_70040_Z(), vec);
                    method.accept((Object)Float.valueOf(vec.func_195899_a()), (Object)Float.valueOf(vec.func_195900_b()), (Object)Float.valueOf(vec.func_195902_c()));
                    break;
                }
                case LOCAL_HORIZONTAL: {
                    Vector3d vel = entity.func_70040_Z();
                    Vector3d velH = new Vector3d(vel.field_72450_a, 0.0, vel.field_72449_c);
                    if (!(velH.func_189985_c() > 5.0E-5)) break;
                    velH = velH.func_72432_b();
                    Space.rotateVectorToBase(velH, vec);
                    method.accept((Object)Float.valueOf(vec.func_195899_a()), (Object)Float.valueOf(vec.func_195900_b()), (Object)Float.valueOf(vec.func_195902_c()));
                    break;
                }
                case VELOCITY: {
                    Space.rotateVectorToBase(entity.func_213322_ci(), vec);
                    method.accept((Object)Float.valueOf(vec.func_195899_a()), (Object)Float.valueOf(vec.func_195900_b()), (Object)Float.valueOf(vec.func_195902_c()));
                    break;
                }
                case VELOCITY_NORMALIZED: {
                    Space.rotateVectorToBase(entity.func_213322_ci().func_72432_b(), vec);
                    method.accept((Object)Float.valueOf(vec.func_195899_a()), (Object)Float.valueOf(vec.func_195900_b()), (Object)Float.valueOf(vec.func_195902_c()));
                    break;
                }
                case VELOCITY_HORIZONTAL: {
                    Vector3d vel = entity.func_213322_ci();
                    Vector3d velH = new Vector3d(vel.field_72450_a, 0.0, vel.field_72449_c);
                    Space.rotateVectorToBase(velH, vec);
                    method.accept((Object)Float.valueOf(vec.func_195899_a()), (Object)Float.valueOf(vec.func_195900_b()), (Object)Float.valueOf(vec.func_195902_c()));
                    break;
                }
                case VELOCITY_HORIZONTAL_NORMALIZED: {
                    Vector3d vel = entity.func_213322_ci();
                    Vector3d velH = new Vector3d(vel.field_72450_a, 0.0, vel.field_72449_c);
                    if (!(velH.func_189985_c() > 5.0E-5)) break;
                    velH = velH.func_72432_b();
                    Space.rotateVectorToBase(velH, vec);
                    method.accept((Object)Float.valueOf(vec.func_195899_a()), (Object)Float.valueOf(vec.func_195900_b()), (Object)Float.valueOf(vec.func_195902_c()));
                }
            }
            entity.field_70133_I = true;
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("spawn_entity"), new SerializableData().add("entity_type", SerializableDataType.ENTITY_TYPE).add("tag", SerializableDataType.NBT, null).add("entity_action", SerializableDataType.ENTITY_ACTION, null), (data, entity) -> {
            Entity e = ((EntityType)data.get("entity_type")).func_200721_a(entity.field_70170_p);
            if (e != null) {
                e.func_70012_b(entity.func_213303_ch().field_72450_a, entity.func_213303_ch().field_72448_b, entity.func_213303_ch().field_72449_c, entity.field_70177_z, entity.field_70125_A);
                if (data.isPresent("tag")) {
                    CompoundNBT mergedTag = e.func_189511_e(new CompoundNBT());
                    mergedTag.func_197643_a((CompoundNBT)data.get("tag"));
                    e.func_70020_e(mergedTag);
                }
                entity.field_70170_p.func_217376_c(e);
                if (data.isPresent("entity_action")) {
                    ((ActionFactory.Instance)data.get("entity_action")).accept(e);
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("gain_air"), new SerializableData().add("value", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                le.func_70050_g(Math.min(le.func_70086_ai() + data.getInt("value"), le.func_205010_bg()));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("block_action_at"), new SerializableData().add("block_action", SerializableDataType.BLOCK_ACTION), (data, entity) -> ((ActionFactory.Instance)data.get("block_action")).accept(Triple.of((Object)entity.field_70170_p, (Object)entity.func_233580_cy_(), (Object)Direction.UP))));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("spawn_effect_cloud"), new SerializableData().add("radius", SerializableDataType.FLOAT, Float.valueOf(3.0f)).add("radius_on_use", SerializableDataType.FLOAT, Float.valueOf(-0.5f)).add("wait_time", SerializableDataType.INT, 10).add("effect", SerializableDataType.STATUS_EFFECT_INSTANCE, null).add("effects", SerializableDataType.STATUS_EFFECT_INSTANCES, null), (data, entity) -> {
            AreaEffectCloudEntity areaEffectCloudEntity = new AreaEffectCloudEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            if (entity instanceof LivingEntity) {
                areaEffectCloudEntity.func_184481_a((LivingEntity)entity);
            }
            areaEffectCloudEntity.func_184483_a(data.getFloat("radius"));
            areaEffectCloudEntity.func_184495_b(data.getFloat("radius_on_use"));
            areaEffectCloudEntity.func_184485_d(data.getInt("wait_time"));
            areaEffectCloudEntity.func_184487_c(-areaEffectCloudEntity.func_184490_j() / (float)areaEffectCloudEntity.func_184489_o());
            LinkedList<EffectInstance> effects = new LinkedList<EffectInstance>();
            if (data.isPresent("effect")) {
                effects.add((EffectInstance)data.get("effect"));
            }
            if (data.isPresent("effects")) {
                effects.addAll((Collection)data.get("effects"));
            }
            areaEffectCloudEntity.func_184482_a(PotionUtils.func_185181_a(effects));
            effects.forEach(arg_0 -> ((AreaEffectCloudEntity)areaEffectCloudEntity).func_184496_a(arg_0));
            entity.field_70170_p.func_217376_c((Entity)areaEffectCloudEntity);
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("extinguish"), new SerializableData(), (data, entity) -> entity.func_70066_B()));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("execute_command"), new SerializableData().add("command", SerializableDataType.STRING).add("permission_level", SerializableDataType.INT, 4), (data, entity) -> {
            MinecraftServer server = entity.field_70170_p.func_73046_m();
            if (server != null) {
                CommandSource source = new CommandSource(ICommandSource.field_213139_a_, entity.func_213303_ch(), entity.func_189653_aC(), entity.field_70170_p instanceof ServerWorld ? (ServerWorld)entity.field_70170_p : null, data.getInt("permission_level"), entity.func_200200_C_().getString(), entity.func_145748_c_(), entity.field_70170_p.func_73046_m(), entity);
                server.func_195571_aL().func_197059_a(source, (String)data.get("command"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("change_resource"), new SerializableData().add("resource", SerializableDataType.POWER_TYPE).add("change", SerializableDataType.INT), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                OriginComponent component = ModComponentsArchitectury.getOriginComponent(entity);
                Object p = component.getPower((PowerType)data.get("resource"));
                if (p instanceof VariableIntPower) {
                    VariableIntPower vip = (VariableIntPower)p;
                    int newValue = vip.getValue() + data.getInt("change");
                    vip.setValue(newValue);
                    OriginComponent.sync((PlayerEntity)entity);
                } else if (p instanceof CooldownPower) {
                    CooldownPower cp = (CooldownPower)p;
                    cp.modify(data.getInt("change"));
                    OriginComponent.sync((PlayerEntity)entity);
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("feed"), new SerializableData().add("food", SerializableDataType.INT).add("saturation", SerializableDataType.FLOAT), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_71024_bL().func_75122_a(data.getInt("food"), data.getFloat("saturation"));
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("add_xp"), new SerializableData().add("points", SerializableDataType.INT, 0).add("levels", SerializableDataType.INT, 0), (data, entity) -> {
            if (entity instanceof PlayerEntity) {
                int points = data.getInt("points");
                int levels = data.getInt("levels");
                if (points > 0) {
                    ((PlayerEntity)entity).func_195068_e(points);
                }
                ((PlayerEntity)entity).func_82242_a(levels);
            }
        }));
        Scheduler scheduler = new Scheduler();
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("delay"), new SerializableData().add("ticks", SerializableDataType.INT).add("action", SerializableDataType.ENTITY_ACTION), (data, entity) -> {
            ActionFactory.Instance action = (ActionFactory.Instance)data.get("action");
            scheduler.queue(s -> action.accept(entity), data.getInt("ticks"));
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("set_fall_distance"), new SerializableData().add("fall_distance", SerializableDataType.FLOAT), (data, entity) -> {
            entity.field_70143_R = data.getFloat("fall_distance");
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("give"), new SerializableData().add("stack", SerializableDataType.ITEM_STACK), (data, entity) -> {
            if (!entity.field_70170_p.func_201670_d()) {
                ItemStack stack = (ItemStack)data.get("stack");
                stack = stack.func_77946_l();
                if (entity instanceof PlayerEntity) {
                    ((PlayerEntity)entity).field_71071_by.func_191975_a(entity.field_70170_p, stack);
                } else {
                    entity.field_70170_p.func_217376_c((Entity)new ItemEntity(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), stack));
                }
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("equipped_item_action"), new SerializableData().add("equipment_slot", SerializableDataType.EQUIPMENT_SLOT).add("action", SerializableDataType.ITEM_ACTION), (data, entity) -> {
            if (entity instanceof LivingEntity) {
                ItemStack stack = ((LivingEntity)entity).func_184582_a((EquipmentSlotType)data.get("equipment_slot"));
                ActionFactory.Instance action = (ActionFactory.Instance)data.get("action");
                action.accept(stack);
            }
        }));
        EntityActions.register(new ActionFactory<Entity>(Origins.identifier("trigger_cooldown"), new SerializableData().add("power", SerializableDataType.POWER_TYPE), (data, entity) -> {
            OriginComponent component;
            Object p;
            if (entity instanceof PlayerEntity && (p = (component = ModComponentsArchitectury.getOriginComponent(entity)).getPower((PowerType)data.get("power"))) instanceof CooldownPower) {
                CooldownPower cp = (CooldownPower)p;
                cp.use();
            }
        }));
    }

    private static void register(ActionFactory<Entity> actionFactory) {
        ModRegistriesArchitectury.ENTITY_ACTION.register(actionFactory.getSerializerId(), () -> actionFactory);
    }
}

