/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.LightType;

public class BlockConditions {
    public static void register() {
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("constant"), new SerializableData().add("value", SerializableDataType.BOOLEAN), (data, block) -> data.getBoolean("value")));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("and"), new SerializableData().add("conditions", SerializableDataType.BLOCK_CONDITIONS), (data, block) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(block))));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("or"), new SerializableData().add("conditions", SerializableDataType.BLOCK_CONDITIONS), (data, block) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(block))));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("offset"), new SerializableData().add("condition", SerializableDataType.BLOCK_CONDITION).add("x", SerializableDataType.INT, 0).add("y", SerializableDataType.INT, 0).add("z", SerializableDataType.INT, 0), (data, block) -> ((ConditionFactory.Instance)data.get("condition")).test(new CachedBlockInfo(block.func_196960_c(), block.func_177508_d().func_177982_a(data.getInt("x"), data.getInt("y"), data.getInt("z")), true))));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("height"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT), (data, block) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(block.func_177508_d().func_177956_o(), data.getInt("compare_to"))));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("block"), new SerializableData().add("block", SerializableDataType.BLOCK), (data, block) -> block.func_177509_a().func_203425_a((Block)data.get("block"))));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("in_tag"), new SerializableData().add("tag", SerializableDataType.BLOCK_TAG), (data, block) -> {
            if (block == null || block.func_177509_a() == null) {
                return false;
            }
            return block.func_177509_a().func_235714_a_((ITag)data.get("tag"));
        }));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("adjacent"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT).add("adjacent_condition", SerializableDataType.BLOCK_CONDITION), (data, block) -> {
            ConditionFactory.Instance adjacentCondition = (ConditionFactory.Instance)data.get("adjacent_condition");
            int adjacent = 0;
            for (Direction d : Direction.values()) {
                if (!adjacentCondition.test(new CachedBlockInfo(block.func_196960_c(), block.func_177508_d().func_177972_a(d), true))) continue;
                ++adjacent;
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(adjacent, data.getInt("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("replacable"), new SerializableData(), (data, block) -> block.func_177509_a().func_185904_a().func_76222_j()));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("attachable"), new SerializableData(), (data, block) -> {
            for (Direction d : Direction.values()) {
                BlockPos adjacent = block.func_177508_d().func_177972_a(d);
                if (!block.func_196960_c().func_180495_p(adjacent).func_224755_d((IBlockReader)block.func_196960_c(), block.func_177508_d(), d.func_176734_d())) continue;
                return true;
            }
            return false;
        }));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("fluid"), new SerializableData().add("fluid_condition", SerializableDataType.FLUID_CONDITION), (data, block) -> ((ConditionFactory.Instance)data.get("fluid_condition")).test(block.func_196960_c().func_204610_c(block.func_177508_d()))));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("movement_blocking"), new SerializableData(), (data, block) -> block.func_177509_a().func_185904_a().func_76230_c() && !block.func_177509_a().func_196952_d((IBlockReader)block.func_196960_c(), block.func_177508_d()).func_197766_b()));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("light_blocking"), new SerializableData(), (data, block) -> block.func_177509_a().func_185904_a().func_76218_k()));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("water_loggable"), new SerializableData(), (data, block) -> block.func_177509_a().func_177230_c() instanceof ILiquidContainer));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("exposed_to_sky"), new SerializableData(), (data, block) -> block.func_196960_c().func_226660_f_(block.func_177508_d())));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("light_level"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.INT).add("light_type", SerializableDataType.enumValue(LightType.class), null), (data, block) -> {
            int value;
            if (data.isPresent("light_type")) {
                LightType lightType = (LightType)data.get("light_type");
                value = block.func_196960_c().func_226658_a_(lightType, block.func_177508_d());
            } else {
                value = block.func_196960_c().func_201696_r(block.func_177508_d());
            }
            return ((Comparison)((Object)((Object)data.get("comparison")))).compare(value, data.getInt("compare_to"));
        }));
        BlockConditions.register(new ConditionFactory<CachedBlockInfo>(Origins.identifier("block_state"), new SerializableData().add("property", SerializableDataType.STRING).add("comparison", SerializableDataType.COMPARISON, null).add("compare_to", SerializableDataType.INT, null).add("value", SerializableDataType.BOOLEAN, null).add("enum", SerializableDataType.STRING, null), (data, block) -> {
            BlockState state = block.func_177509_a();
            Collection properties = state.func_235904_r_();
            String desiredPropertyName = data.getString("property");
            Property property = null;
            for (Property p : properties) {
                if (!p.func_177701_a().equals(desiredPropertyName)) continue;
                property = p;
                break;
            }
            if (property != null) {
                Comparable value = state.func_177229_b(property);
                if (data.isPresent("enum") && value instanceof Enum) {
                    return ((Enum)((Object)value)).name().equalsIgnoreCase(data.getString("enum"));
                }
                if (data.isPresent("value") && value instanceof Boolean) {
                    return ((Boolean)value).booleanValue() == data.getBoolean("value");
                }
                if (data.isPresent("comparison") && data.isPresent("compare_to") && value instanceof Integer) {
                    return ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Integer)value).intValue(), data.getInt("compare_to"));
                }
            }
            return false;
        }));
    }

    private static void register(ConditionFactory<CachedBlockInfo> conditionFactory) {
        ModRegistriesArchitectury.BLOCK_CONDITION.register(conditionFactory.getSerializerId(), () -> conditionFactory);
    }
}

