/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import com.google.gson.JsonObject;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import me.shedaniel.architectury.core.RegistryEntry;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class ConditionFactory<T>
extends RegistryEntry<ConditionFactory<T>> {
    private final ResourceLocation identifier;
    protected SerializableData data;
    private final BiFunction<SerializableData.Instance, T, Boolean> condition;

    public ConditionFactory(ResourceLocation identifier, SerializableData data, BiFunction<SerializableData.Instance, T, Boolean> condition) {
        this.identifier = identifier;
        this.condition = condition;
        this.data = data;
        this.data.add("inverted", SerializableDataType.BOOLEAN, false);
    }

    public ResourceLocation getSerializerId() {
        return this.identifier;
    }

    public Instance read(JsonObject json) {
        return new Instance(this.data.read(json));
    }

    public Instance read(PacketBuffer buffer) {
        return new Instance(this.data.read(buffer));
    }

    public class Instance
    implements Predicate<T> {
        private final SerializableData.Instance dataInstance;

        private Instance(SerializableData.Instance data) {
            this.dataInstance = data;
        }

        @Override
        public final boolean test(T t) {
            boolean fulfilled = this.isFulfilled(t);
            if (this.dataInstance.getBoolean("inverted")) {
                return !fulfilled;
            }
            return fulfilled;
        }

        public boolean isFulfilled(T t) {
            return (Boolean)ConditionFactory.this.condition.apply(this.dataInstance, t);
        }

        public void write(PacketBuffer buf) {
            buf.func_192572_a(ConditionFactory.this.identifier);
            ConditionFactory.this.data.write(buf, this.dataInstance);
        }
    }
}

