/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import java.util.Optional;
import me.shedaniel.architectury.registry.Registry;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class ConditionType<T> {
    private final String conditionTypeName;
    private final Registry<ConditionFactory<T>> conditionRegistry;

    public ConditionType(String conditionTypeName, Registry<ConditionFactory<T>> conditionRegistry) {
        this.conditionTypeName = conditionTypeName;
        this.conditionRegistry = conditionRegistry;
    }

    public void write(PacketBuffer buf, ConditionFactory.Instance conditionInstance) {
        conditionInstance.write(buf);
    }

    public ConditionFactory.Instance read(PacketBuffer buf) {
        ResourceLocation type = ResourceLocation.func_208304_a((String)buf.func_150789_c(Short.MAX_VALUE));
        ConditionFactory conditionFactory = (ConditionFactory)((Object)this.conditionRegistry.get(type));
        return conditionFactory.read(buf);
    }

    public ConditionFactory.Instance read(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject obj = jsonElement.getAsJsonObject();
            if (!obj.has("type")) {
                throw new JsonSyntaxException(this.conditionTypeName + " json requires \"type\" identifier.");
            }
            String typeIdentifier = JSONUtils.func_151200_h((JsonObject)obj, (String)"type");
            ResourceLocation type = ResourceLocation.func_208304_a((String)typeIdentifier);
            Optional<ConditionFactory> optionalCondition = Optional.ofNullable((ConditionFactory)((Object)this.conditionRegistry.get(type)));
            if (!optionalCondition.isPresent()) {
                throw new JsonSyntaxException(this.conditionTypeName + " json type \"" + type + "\" is not defined.");
            }
            return optionalCondition.get().read(obj);
        }
        throw new JsonSyntaxException(this.conditionTypeName + " has to be a JsonObject!");
    }
}

