/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.Tuple;

public class DamageConditions {
    public static void register() {
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Origins.identifier("constant"), new SerializableData().add("value", SerializableDataType.BOOLEAN), (data, dmg) -> data.getBoolean("value")));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Origins.identifier("and"), new SerializableData().add("conditions", SerializableDataType.DAMAGE_CONDITIONS), (data, dmg) -> ((List)data.get("conditions")).stream().allMatch(condition -> condition.test(dmg))));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Origins.identifier("or"), new SerializableData().add("conditions", SerializableDataType.DAMAGE_CONDITIONS), (data, dmg) -> ((List)data.get("conditions")).stream().anyMatch(condition -> condition.test(dmg))));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Origins.identifier("amount"), new SerializableData().add("comparison", SerializableDataType.COMPARISON).add("compare_to", SerializableDataType.FLOAT), (data, dmg) -> ((Comparison)((Object)((Object)data.get("comparison")))).compare(((Float)dmg.func_76340_b()).floatValue(), data.getFloat("compare_to"))));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Origins.identifier("fire"), new SerializableData(), (data, dmg) -> ((DamageSource)dmg.func_76341_a()).func_76347_k()));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Origins.identifier("name"), new SerializableData().add("name", SerializableDataType.STRING), (data, dmg) -> ((DamageSource)dmg.func_76341_a()).func_76355_l().equals(data.get("name"))));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Origins.identifier("projectile"), new SerializableData().add("projectile", SerializableDataType.ENTITY_TYPE, null), (data, dmg) -> {
            if (dmg.func_76341_a() instanceof IndirectEntityDamageSource) {
                Entity projectile = ((DamageSource)dmg.func_76341_a()).func_76364_f();
                return projectile != null && (!data.isPresent("projectile") || projectile.func_200600_R() == data.get("projectile"));
            }
            return false;
        }));
        DamageConditions.register(new ConditionFactory<Tuple<DamageSource, Float>>(Origins.identifier("attacker"), new SerializableData().add("entity_condition", SerializableDataType.ENTITY_CONDITION, null), (data, dmg) -> {
            Entity attacker = ((DamageSource)dmg.func_76341_a()).func_76346_g();
            if (attacker instanceof LivingEntity && (!data.isPresent("entity_condition") || ((ConditionFactory.Instance)data.get("entity_condition")).test((LivingEntity)attacker))) {
                return true;
            }
            return false;
        }));
    }

    private static void register(ConditionFactory<Tuple<DamageSource, Float>> conditionFactory) {
        ModRegistriesArchitectury.DAMAGE_CONDITION.register(conditionFactory.getSerializerId(), () -> conditionFactory);
    }
}

