/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.networking.ModPackets;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.Origin;
import io.github.apace100.origins.origin.OriginLayer;
import io.github.apace100.origins.origin.OriginRegistry;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.registry.ModItems;
import io.github.apace100.origins.screen.WaitForNextLayerScreen;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ChooseOriginScreen
extends Screen {
    private static final ResourceLocation WINDOW = new ResourceLocation("origins", "textures/gui/choose_origin.png");
    private final ArrayList<OriginLayer> layerList;
    private final int currentLayerIndex;
    private int currentOrigin = 0;
    private final List<Origin> originSelection;
    private final int maxSelection;
    private static final int windowWidth = 176;
    private static final int windowHeight = 182;
    private int scrollPos = 0;
    private int currentMaxScroll = 0;
    private static final int border = 13;
    private int guiTop;
    private int guiLeft;
    private boolean showDirtBackground;
    private Origin randomOrigin;
    private IFormattableTextComponent randomOriginText;

    public ChooseOriginScreen(ArrayList<OriginLayer> layerList, int currentLayerIndex, boolean showDirtBackground) {
        super((ITextComponent)new TranslationTextComponent("origins.screen.choose_origin"));
        this.layerList = layerList;
        this.currentLayerIndex = currentLayerIndex;
        this.originSelection = new ArrayList<Origin>(10);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        OriginLayer currentLayer = layerList.get(currentLayerIndex);
        List<ResourceLocation> originIdentifiers = currentLayer.getOrigins((PlayerEntity)player);
        originIdentifiers.forEach(arg_0 -> this.lambda$new$0((PlayerEntity)player, arg_0));
        this.originSelection.sort((a, b) -> {
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
        int maxSelection = this.originSelection.size();
        if (currentLayer.isRandomAllowed() && currentLayer.getRandomOrigins((PlayerEntity)player).size() > 0) {
            ++maxSelection;
        }
        this.maxSelection = maxSelection;
        if (maxSelection == 0) {
            this.openNextLayerScreen();
            return;
        }
        this.showDirtBackground = showDirtBackground;
    }

    private void openNextLayerScreen() {
        Minecraft.func_71410_x().func_147108_a((Screen)new WaitForNextLayerScreen(this.layerList, this.currentLayerIndex, this.showDirtBackground));
    }

    public boolean func_231178_ax__() {
        return false;
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - 176) / 2;
        this.guiTop = (this.field_230709_l_ - 182) / 2;
        this.func_230480_a_((Widget)new Button(this.guiLeft - 40, this.field_230709_l_ / 2 - 10, 20, 20, (ITextComponent)new StringTextComponent("<"), b -> {
            this.currentOrigin = (this.currentOrigin - 1 + this.maxSelection) % this.maxSelection;
            this.scrollPos = 0;
        }));
        this.func_230480_a_((Widget)new Button(this.guiLeft + 176 + 20, this.field_230709_l_ / 2 - 10, 20, 20, (ITextComponent)new StringTextComponent(">"), b -> {
            this.currentOrigin = (this.currentOrigin + 1) % this.maxSelection;
            this.scrollPos = 0;
        }));
        this.func_230480_a_((Widget)new Button(this.guiLeft + 88 - 50, this.guiTop + 182 + 5, 100, 20, (ITextComponent)new TranslationTextComponent("origins.gui.select"), b -> {
            PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
            if (this.currentOrigin == this.originSelection.size()) {
                buf.func_180714_a(this.layerList.get(this.currentLayerIndex).getIdentifier().toString());
                NetworkManager.sendToServer((ResourceLocation)ModPackets.CHOOSE_RANDOM_ORIGIN, (PacketBuffer)buf);
            } else {
                buf.func_180714_a(this.getCurrentOrigin().getIdentifier().toString());
                buf.func_180714_a(this.layerList.get(this.currentLayerIndex).getIdentifier().toString());
                NetworkManager.sendToServer((ResourceLocation)ModPackets.CHOOSE_ORIGIN, (PacketBuffer)buf);
            }
            this.openNextLayerScreen();
        }));
    }

    private Origin getCurrentOrigin() {
        if (this.currentOrigin == this.originSelection.size()) {
            if (this.randomOrigin == null) {
                this.initRandomOrigin();
            }
            return this.randomOrigin;
        }
        return this.originSelection.get(this.currentOrigin);
    }

    private void initRandomOrigin() {
        this.randomOrigin = new Origin(Origins.identifier("random"), new ItemStack((IItemProvider)ModItems.ORB_OF_ORIGIN), Impact.NONE, -1, Integer.MAX_VALUE);
        this.randomOriginText = new StringTextComponent("");
        List<ResourceLocation> randoms = this.layerList.get(this.currentLayerIndex).getRandomOrigins((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        randoms.sort((ia, ib) -> {
            Origin a = OriginRegistry.get(ia);
            Origin b = OriginRegistry.get(ib);
            int impDelta = a.getImpact().getImpactValue() - b.getImpact().getImpactValue();
            return impDelta == 0 ? a.getOrder() - b.getOrder() : impDelta;
        });
        for (ResourceLocation id : randoms) {
            this.randomOriginText.func_230529_a_((ITextComponent)OriginRegistry.get(id).getName());
            this.randomOriginText.func_230529_a_((ITextComponent)new StringTextComponent("\n"));
        }
    }

    public void func_238651_a_(MatrixStack matrices, int vOffset) {
        if (this.showDirtBackground) {
            super.func_231165_f_(vOffset);
        } else {
            super.func_238651_a_(matrices, vOffset);
        }
    }

    public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
        if (this.maxSelection == 0) {
            this.openNextLayerScreen();
            return;
        }
        this.func_230446_a_(matrices);
        this.renderOriginWindow(matrices, mouseX, mouseY);
        super.func_230430_a_(matrices, mouseX, mouseY, delta);
    }

    private void renderOriginWindow(MatrixStack matrices, int mouseX, int mouseY) {
        RenderSystem.enableBlend();
        this.renderWindowBackground(matrices, 16, 0);
        this.renderOriginContent(matrices, mouseX, mouseY);
        this.field_230706_i_.func_110434_K().func_110577_a(WINDOW);
        this.func_238474_b_(matrices, this.guiLeft, this.guiTop, 0, 0, 176, 182);
        this.renderOriginName(matrices);
        this.field_230706_i_.func_110434_K().func_110577_a(WINDOW);
        this.renderOriginImpact(matrices, mouseX, mouseY);
        TranslationTextComponent title = new TranslationTextComponent("origins.gui.choose_origin.title", new Object[]{new TranslationTextComponent(this.layerList.get(this.currentLayerIndex).getTranslationKey())});
        ChooseOriginScreen.func_238471_a_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)title.getString(), (int)(this.field_230708_k_ / 2), (int)(this.guiTop - 15), (int)0xFFFFFF);
        RenderSystem.disableBlend();
    }

    private void renderOriginImpact(MatrixStack matrices, int mouseX, int mouseY) {
        Impact impact = this.getCurrentOrigin().getImpact();
        int impactValue = impact.getImpactValue();
        int wOffset = impactValue * 8;
        for (int i = 0; i < 3; ++i) {
            if (i < impactValue) {
                this.func_238474_b_(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176 + wOffset, 16, 8, 8);
                continue;
            }
            this.func_238474_b_(matrices, this.guiLeft + 128 + i * 10, this.guiTop + 19, 176, 16, 8, 8);
        }
        if (mouseX >= this.guiLeft + 128 && mouseX <= this.guiLeft + 158 && mouseY >= this.guiTop + 19 && mouseY <= this.guiTop + 27) {
            TranslationTextComponent ttc = (TranslationTextComponent)new TranslationTextComponent("origins.gui.impact.impact").func_240702_b_(": ").func_230529_a_((ITextComponent)impact.getTextComponent());
            this.func_238652_a_(matrices, (ITextComponent)ttc, mouseX, mouseY);
        }
    }

    private void renderOriginName(MatrixStack matrices) {
        ITextProperties originName = this.field_230712_o_.func_238417_a_((ITextProperties)this.getCurrentOrigin().getName(), 140);
        ChooseOriginScreen.func_238476_c_((MatrixStack)matrices, (FontRenderer)this.field_230712_o_, (String)originName.getString(), (int)(this.guiLeft + 39), (int)(this.guiTop + 19), (int)0xFFFFFF);
        ItemStack is = this.getCurrentOrigin().getDisplayItem();
        this.field_230707_j_.func_239390_c_(is, this.guiLeft + 15, this.guiTop + 15);
    }

    private void renderWindowBackground(MatrixStack matrices, int offsetYStart, int offsetYEnd) {
        int endX = this.guiLeft + 176 - 13;
        int endY = this.guiTop + 182 - 13;
        this.field_230706_i_.func_110434_K().func_110577_a(WINDOW);
        for (int x = this.guiLeft; x < endX; x += 16) {
            for (int y = this.guiTop + offsetYStart; y < endY + offsetYEnd; y += 16) {
                this.func_238474_b_(matrices, x, y, 176, 0, Math.max(16, endX - x), Math.max(16, endY + offsetYEnd - y));
            }
        }
    }

    public boolean func_231043_a_(double x, double y, double z) {
        boolean retValue = super.func_231043_a_(x, y, z);
        int np = this.scrollPos - (int)z * 4;
        this.scrollPos = np < 0 ? 0 : Math.min(np, this.currentMaxScroll);
        return retValue;
    }

    private void renderOriginContent(MatrixStack matrices, int mouseX, int mouseY) {
        int y;
        Origin origin = this.getCurrentOrigin();
        int x = this.guiLeft + 18;
        int startY = y = this.guiTop + 50;
        int endY = y - 72 + 182;
        y -= this.scrollPos;
        TranslationTextComponent orgDesc = origin.getDescription();
        List descLines = this.field_230712_o_.func_238425_b_((ITextProperties)orgDesc, 140);
        for (IReorderingProcessor iReorderingProcessor : descLines) {
            if (y >= startY - 18 && y <= endY + 12) {
                this.field_230712_o_.func_238422_b_(matrices, iReorderingProcessor, (float)(x + 2), (float)(y - 6), 0xCCCCCC);
            }
            y += 12;
        }
        if (origin == this.randomOrigin) {
            List drawLines = this.field_230712_o_.func_238425_b_((ITextProperties)this.randomOriginText, 140);
            for (IReorderingProcessor line : drawLines) {
                if ((y += 12) < startY - 24 || y > endY + 12) continue;
                this.field_230712_o_.func_238422_b_(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
            }
            y += 14;
        } else {
            for (PowerType powerType : origin.getPowerTypes()) {
                if (powerType.isHidden()) continue;
                IReorderingProcessor name = LanguageMap.func_74808_a().func_241870_a(this.field_230712_o_.func_238417_a_((ITextProperties)powerType.getName().func_240699_a_(TextFormatting.UNDERLINE), 140));
                TranslationTextComponent desc = powerType.getDescription();
                List drawLines = this.field_230712_o_.func_238425_b_((ITextProperties)desc, 140);
                if (y >= startY - 24 && y <= endY + 12) {
                    this.field_230712_o_.func_238422_b_(matrices, name, (float)x, (float)y, 0xFFFFFF);
                }
                for (IReorderingProcessor line : drawLines) {
                    if ((y += 12) < startY - 24 || y > endY + 12) continue;
                    this.field_230712_o_.func_238422_b_(matrices, line, (float)(x + 2), (float)y, 0xCCCCCC);
                }
                y += 14;
            }
        }
        this.currentMaxScroll = (y += this.scrollPos) - 182 - 15;
        if (this.currentMaxScroll < 0) {
            this.currentMaxScroll = 0;
        }
    }

    private /* synthetic */ void lambda$new$0(PlayerEntity player, ResourceLocation originId) {
        Origin origin = OriginRegistry.get(originId);
        if (origin.isChoosable()) {
            ItemStack displayItem = origin.getDisplayItem();
            if (!(displayItem.func_77973_b() != Items.field_196184_dx || displayItem.func_77942_o() && displayItem.func_77978_p().func_74764_b("SkullOwner"))) {
                displayItem.func_196082_o().func_74778_a("SkullOwner", player.func_145748_c_().getString());
            }
            this.originSelection.add(origin);
        }
    }
}

