/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.apace100.origins.OriginsClient;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.HudRendered;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.screen.GameHudRender;
import io.github.apace100.origins.util.HudRender;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PowerHudRenderer
extends AbstractGui
implements GameHudRender {
    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(MatrixStack matrices, float delta) {
        Minecraft client = Minecraft.func_71410_x();
        OriginComponent component = ModComponentsArchitectury.getOriginComponent((Entity)client.field_71439_g);
        if (component.hasAllOrigins()) {
            int x = client.func_228018_at_().func_198107_o() / 2 + 20 + OriginsClient.config.xOffset;
            int y = client.func_228018_at_().func_198087_p() - 47 + OriginsClient.config.yOffset;
            Entity vehicle = client.field_71439_g.func_184187_bx();
            if (vehicle instanceof LivingEntity && ((LivingEntity)vehicle).func_110138_aP() > 20.0f) {
                y -= 8;
            }
            if (client.field_71439_g.func_208600_a((ITag)FluidTags.field_206959_a) || client.field_71439_g.func_70086_ai() < client.field_71439_g.func_205010_bg()) {
                y -= 8;
            }
            int barWidth = 71;
            int barHeight = 5;
            int iconSize = 8;
            List hudPowers = component.getPowers().stream().filter(p -> p instanceof HudRendered).map(p -> (HudRendered)((Object)p)).sorted(Comparator.comparing(hudRenderedA -> hudRenderedA.getRenderSettings().getSpriteLocation())).collect(Collectors.toList());
            ResourceLocation lastLocation = null;
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            for (HudRendered hudPower : hudPowers) {
                HudRender render = hudPower.getRenderSettings();
                if (!render.shouldRender((PlayerEntity)client.field_71439_g) || !hudPower.shouldRender()) continue;
                ResourceLocation currentLocation = render.getSpriteLocation();
                if (currentLocation != lastLocation) {
                    client.func_110434_K().func_110577_a(currentLocation);
                    lastLocation = currentLocation;
                }
                this.func_238474_b_(matrices, x, y, 0, 0, barWidth, barHeight);
                int v = 10 + render.getBarIndex() * 10;
                int w = (int)(hudPower.getFill() * (float)barWidth);
                this.func_238474_b_(matrices, x, y, 0, v, w, barHeight);
                this.func_230926_e_(this.func_230927_p_() + 1);
                this.func_238474_b_(matrices, x - iconSize - 2, y - 2, 73, v - 2, iconSize, iconSize);
                this.func_230926_e_(this.func_230927_p_() - 1);
                y -= 8;
            }
        }
    }
}

