/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import java.util.Comparator;
import java.util.List;
import net.minecraft.entity.ai.attributes.AttributeModifier;

public final class AttributeUtil {
    public static void sortModifiers(List<AttributeModifier> modifiers) {
        modifiers.sort(Comparator.comparing(e -> e.func_220375_c().func_220371_a()));
    }

    public static double sortAndApplyModifiers(List<AttributeModifier> modifiers, double baseValue) {
        AttributeUtil.sortModifiers(modifiers);
        return AttributeUtil.applyModifiers(modifiers, baseValue);
    }

    public static double applyModifiers(List<AttributeModifier> modifiers, double baseValue) {
        double currentValue = baseValue;
        if (modifiers != null) {
            for (AttributeModifier modifier : modifiers) {
                switch (modifier.func_220375_c()) {
                    case ADDITION: {
                        currentValue += modifier.func_111164_d();
                        break;
                    }
                    case MULTIPLY_BASE: {
                        currentValue += baseValue * modifier.func_111164_d();
                        break;
                    }
                    case MULTIPLY_TOTAL: {
                        currentValue *= 1.0 + modifier.func_111164_d();
                    }
                }
            }
        }
        return currentValue;
    }
}

