/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;

public class HudRender {
    public static final HudRender DONT_RENDER = new HudRender(false, 0, Origins.identifier("textures/gui/resource_bar.png"), null);
    private final boolean shouldRender;
    private final int barIndex;
    private final ResourceLocation spriteLocation;
    private final ConditionFactory.Instance playerCondition;

    public HudRender(boolean shouldRender, int barIndex, ResourceLocation spriteLocation, ConditionFactory.Instance condition) {
        this.shouldRender = shouldRender;
        this.barIndex = barIndex;
        this.spriteLocation = spriteLocation;
        this.playerCondition = condition;
    }

    public ResourceLocation getSpriteLocation() {
        return this.spriteLocation;
    }

    public int getBarIndex() {
        return this.barIndex;
    }

    public boolean shouldRender() {
        return this.shouldRender;
    }

    public boolean shouldRender(PlayerEntity player) {
        return this.shouldRender && (this.playerCondition == null || this.playerCondition.test(player));
    }

    public ConditionFactory.Instance getCondition() {
        return this.playerCondition;
    }
}

