/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.ReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MultiJsonDataLoader
extends ReloadListener<Map<ResourceLocation, List<JsonElement>>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int FILE_SUFFIX_LENGTH = ".json".length();
    private final Gson gson;
    private final String dataType;

    public MultiJsonDataLoader(Gson gson, String dataType) {
        this.gson = gson;
        this.dataType = dataType;
    }

    protected Map<ResourceLocation, List<JsonElement>> prepare(IResourceManager resourceManager, IProfiler profiler) {
        HashMap map = Maps.newHashMap();
        int i = this.dataType.length() + 1;
        Iterator var5 = resourceManager.func_199003_a(this.dataType, stringx -> stringx.endsWith(".json")).iterator();
        HashSet resourcesHandled = new HashSet();
        while (var5.hasNext()) {
            ResourceLocation identifier = (ResourceLocation)var5.next();
            String string = identifier.func_110623_a();
            ResourceLocation identifier2 = new ResourceLocation(identifier.func_110624_b(), string.substring(i, string.length() - FILE_SUFFIX_LENGTH));
            resourcesHandled.clear();
            try {
                resourceManager.func_199004_b(identifier).forEach(resource -> {
                    if (!resourcesHandled.contains(resource.func_199026_d())) {
                        resourcesHandled.add(resource.func_199026_d());
                        try {
                            try (InputStream inputStream = resource.func_199027_b();
                                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                                JsonElement jsonElement = (JsonElement)JSONUtils.func_193839_a((Gson)this.gson, (Reader)reader, JsonElement.class);
                                if (jsonElement != null) {
                                    if (map.containsKey(identifier2)) {
                                        ((List)map.get(identifier2)).add(jsonElement);
                                    } else {
                                        LinkedList<JsonElement> elementList = new LinkedList<JsonElement>();
                                        elementList.add(jsonElement);
                                        map.put(identifier2, elementList);
                                    }
                                } else {
                                    LOGGER.error("Couldn't load data file {} from {} as it's null or empty", (Object)identifier2, (Object)identifier);
                                }
                            }
                            finally {
                                resource.close();
                            }
                        }
                        catch (JsonParseException | IOException | IllegalArgumentException var68) {
                            LOGGER.error("Couldn't parse data file {} from {}", (Object)identifier2, (Object)identifier, (Object)var68);
                        }
                    }
                });
            }
            catch (IOException e) {
                LOGGER.error("Couldn't parse data file {} from {}", (Object)identifier2, (Object)identifier, (Object)e);
            }
        }
        return map;
    }
}

