/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.common.collect.Lists;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.RecipePower;
import io.github.apace100.origins.registry.ModRecipes;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class OriginRestrictedCraftingRecipe
extends SpecialRecipe {
    public OriginRestrictedCraftingRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingInventory inv, World world) {
        return this.getRecipes(inv).stream().anyMatch(r -> r.func_77569_a((IInventory)inv, world));
    }

    public ItemStack craft(CraftingInventory inv) {
        Optional<IRecipe> optional;
        PlayerEntity player = this.getPlayerFromInventory(inv);
        if (player != null && (optional = this.getRecipes(inv).stream().filter(r -> r.func_77569_a((IInventory)inv, player.field_70170_p)).findFirst()).isPresent()) {
            IRecipe recipe = optional.get();
            return recipe.func_77572_b((IInventory)inv);
        }
        return ItemStack.field_190927_a;
    }

    public boolean func_194133_a(int width, int height) {
        return true;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return ModRecipes.ORIGIN_RESTRICTED;
    }

    private PlayerEntity getPlayerFromInventory(CraftingInventory inv) {
        return this.getPlayerFromHandler(inv.field_70465_c);
    }

    private List<IRecipe<CraftingInventory>> getRecipes(CraftingInventory inv) {
        PlayerEntity player = this.getPlayerFromHandler(inv.field_70465_c);
        if (player != null) {
            return OriginComponent.getPowers((Entity)player, RecipePower.class).stream().map(RecipePower::getRecipe).collect(Collectors.toList());
        }
        return Lists.newArrayList();
    }

    private PlayerEntity getPlayerFromHandler(Container screenHandler) {
        if (screenHandler instanceof WorkbenchContainer) {
            return ((WorkbenchContainer)screenHandler).field_192390_i;
        }
        if (screenHandler instanceof PlayerContainer) {
            return ((PlayerContainer)screenHandler).field_82862_h;
        }
        return null;
    }
}

