/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeReference;
import io.github.apace100.origins.registry.ModComponentsArchitectury;
import io.github.apace100.origins.registry.ModLoot;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class PowerLootCondition
implements ILootCondition {
    private final PowerType<?> powerType;

    private PowerLootCondition(ResourceLocation powerId) {
        this(new PowerTypeReference(powerId));
    }

    private PowerLootCondition(PowerType<?> powerType) {
        this.powerType = powerType;
    }

    public LootConditionType func_230419_b_() {
        return ModLoot.POWER_LOOT_CONDITION;
    }

    public boolean test(LootContext lootContext) {
        Optional<OriginComponent> optional = ModComponentsArchitectury.maybeGetOriginComponent((Entity)lootContext.func_216031_c(LootParameters.field_216281_a));
        if (optional.isPresent()) {
            OriginComponent component = optional.get();
            return component.hasPower(this.powerType);
        }
        return false;
    }

    public static ILootCondition.IBuilder builder(String powerId) {
        return PowerLootCondition.builder(new ResourceLocation(powerId));
    }

    public static ILootCondition.IBuilder builder(ResourceLocation powerId) {
        return PowerLootCondition.builder(new PowerTypeReference(powerId));
    }

    public static ILootCondition.IBuilder builder(PowerType<?> powerType) {
        return () -> new PowerLootCondition(powerType);
    }

    public static class Serializer
    implements ILootSerializer<PowerLootCondition> {
        public void toJson(JsonObject jsonObject, PowerLootCondition originLootCondition, JsonSerializationContext jsonSerializationContext) {
            jsonObject.addProperty("power", originLootCondition.powerType.getIdentifier().toString());
        }

        public PowerLootCondition fromJson(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return new PowerLootCondition(new ResourceLocation(JSONUtils.func_151200_h((JsonObject)jsonObject, (String)"power")));
        }
    }
}

