/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.apace100.origins.Origins;
import io.github.apace100.origins.origin.Impact;
import io.github.apace100.origins.origin.OriginUpgrade;
import io.github.apace100.origins.power.Active;
import io.github.apace100.origins.power.PowerType;
import io.github.apace100.origins.power.PowerTypeReference;
import io.github.apace100.origins.power.PowerTypes;
import io.github.apace100.origins.power.factory.action.ActionFactory;
import io.github.apace100.origins.power.factory.action.ActionType;
import io.github.apace100.origins.power.factory.action.ActionTypes;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.power.factory.condition.ConditionType;
import io.github.apace100.origins.power.factory.condition.ConditionTypes;
import io.github.apace100.origins.util.AttributedEntityAttributeModifier;
import io.github.apace100.origins.util.ClassUtil;
import io.github.apace100.origins.util.Comparison;
import io.github.apace100.origins.util.FilterableWeightedList;
import io.github.apace100.origins.util.HudRender;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializationHelper;
import io.github.apace100.origins.util.Space;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.shedaniel.architectury.hooks.TagHooks;
import me.shedaniel.architectury.platform.Platform;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Tuple;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class SerializableDataType<T> {
    public static final SerializableDataType<Integer> INT = new SerializableDataType<Integer>(Integer.class, PacketBuffer::writeInt, PacketBuffer::readInt, JsonElement::getAsInt);
    public static final SerializableDataType<Boolean> BOOLEAN = new SerializableDataType<Boolean>(Boolean.class, PacketBuffer::writeBoolean, PacketBuffer::readBoolean, JsonElement::getAsBoolean);
    public static final SerializableDataType<Float> FLOAT = new SerializableDataType<Float>(Float.class, PacketBuffer::writeFloat, PacketBuffer::readFloat, JsonElement::getAsFloat);
    public static final SerializableDataType<Double> DOUBLE = new SerializableDataType<Double>(Double.class, PacketBuffer::writeDouble, PacketBuffer::readDouble, JsonElement::getAsDouble);
    public static final SerializableDataType<String> STRING = new SerializableDataType<String>(String.class, PacketBuffer::func_180714_a, buf -> buf.func_150789_c(Short.MAX_VALUE), JsonElement::getAsString);
    public static final SerializableDataType<ResourceLocation> IDENTIFIER = new SerializableDataType<ResourceLocation>(ResourceLocation.class, PacketBuffer::func_192572_a, PacketBuffer::func_192575_l, json -> {
        String idString = json.getAsString();
        if (idString.contains(":")) {
            String[] idSplit = idString.split(":");
            if (idSplit.length != 2) {
                throw new ResourceLocationException("Incorrect number of `:` in identifier: \"" + idString + "\".");
            }
            if (idSplit[0].contains("*")) {
                if (PowerTypes.CURRENT_NAMESPACE != null) {
                    idSplit[0] = idSplit[0].replace("*", PowerTypes.CURRENT_NAMESPACE);
                } else {
                    throw new ResourceLocationException("Identifier may only contain a `*` in the namespace inside of powers.");
                }
            }
            if (idSplit[1].contains("*")) {
                if (PowerTypes.CURRENT_PATH != null) {
                    idSplit[1] = idSplit[1].replace("*", PowerTypes.CURRENT_PATH);
                } else {
                    throw new ResourceLocationException("Identifier may only contain a `*` in the path inside of powers.");
                }
            }
            idString = idSplit[0] + ":" + idSplit[1];
        } else if (idString.contains("*")) {
            if (PowerTypes.CURRENT_PATH != null) {
                idString = idString.replace("*", PowerTypes.CURRENT_PATH);
            } else {
                throw new ResourceLocationException("Identifier may only contain a `*` in the path inside of powers.");
            }
        }
        return ResourceLocation.func_208304_a((String)idString);
    });
    public static final SerializableDataType<List<ResourceLocation>> IDENTIFIERS = SerializableDataType.list(IDENTIFIER);
    public static final SerializableDataType<Impact> IMPACT = SerializableDataType.enumValue(Impact.class);
    public static final SerializableDataType<OriginUpgrade> UPGRADE = new SerializableDataType<OriginUpgrade>(OriginUpgrade.class, (buf, upgrade) -> upgrade.write((PacketBuffer)buf), OriginUpgrade::read, OriginUpgrade::fromJson);
    public static final SerializableDataType<List<OriginUpgrade>> UPGRADES = SerializableDataType.list(UPGRADE);
    public static final SerializableDataType<Enchantment> ENCHANTMENT = SerializableDataType.registry(Enchantment.class, Registry.field_212628_q);
    public static final SerializableDataType<DamageSource> DAMAGE_SOURCE = SerializableDataType.compound(DamageSource.class, new SerializableData().add("name", STRING).add("bypasses_armor", BOOLEAN, false).add("fire", BOOLEAN, false).add("unblockable", BOOLEAN, false).add("magic", BOOLEAN, false).add("out_of_world", BOOLEAN, false), data -> {
        DamageSource damageSource = new DamageSource((String)data.get("name"));
        if (data.getBoolean("bypasses_armor")) {
            damageSource.func_76348_h();
        }
        if (data.getBoolean("fire")) {
            damageSource.func_76361_j();
        }
        if (data.getBoolean("unblockable")) {
            damageSource.func_151518_m();
        }
        if (data.getBoolean("magic")) {
            damageSource.func_82726_p();
        }
        if (data.getBoolean("out_of_world")) {
            damageSource.func_76359_i();
        }
        return damageSource;
    }, (data, ds) -> {
        SerializableData.Instance inst = (SerializableData)data.new SerializableData.Instance();
        inst.set("name", ds.field_76373_n);
        inst.set("fire", ds.func_76347_k());
        inst.set("unblockable", ds.func_151517_h());
        inst.set("bypasses_armor", ds.func_76363_c());
        inst.set("out_of_world", ds.func_76357_e());
        inst.set("magic", ds.func_82725_o());
        return inst;
    });
    public static final SerializableDataType<Attribute> ATTRIBUTE = SerializableDataType.registry(Attribute.class, Registry.field_239692_aP_);
    public static final SerializableDataType<AttributeModifier> ATTRIBUTE_MODIFIER = new SerializableDataType<AttributeModifier>(AttributeModifier.class, SerializationHelper::writeAttributeModifier, SerializationHelper::readAttributeModifier, SerializationHelper::readAttributeModifier);
    public static final SerializableDataType<AttributeModifier.Operation> MODIFIER_OPERATION = SerializableDataType.enumValue(AttributeModifier.Operation.class);
    public static final SerializableDataType<AttributedEntityAttributeModifier> ATTRIBUTED_ATTRIBUTE_MODIFIER = SerializableDataType.compound(AttributedEntityAttributeModifier.class, new SerializableData().add("attribute", ATTRIBUTE).add("operation", MODIFIER_OPERATION).add("value", DOUBLE).add("name", STRING, "Unnamed EntityAttributeModifier"), dataInst -> {
        Attribute attribute = (Attribute)dataInst.get("attribute");
        if (attribute == null) {
            return null;
        }
        return new AttributedEntityAttributeModifier(attribute, new AttributeModifier((String)dataInst.get("name"), dataInst.getDouble("value"), (AttributeModifier.Operation)dataInst.get("operation")));
    }, (data, inst) -> {
        SerializableData.Instance dataInst = (SerializableData)data.new SerializableData.Instance();
        dataInst.set("attribute", inst.getAttribute());
        dataInst.set("operation", inst.getModifier().func_220375_c());
        dataInst.set("value", inst.getModifier().func_111164_d());
        dataInst.set("name", inst.getModifier().func_111166_b());
        return dataInst;
    });
    public static final SerializableDataType<List<AttributeModifier>> ATTRIBUTE_MODIFIERS = SerializableDataType.list(ATTRIBUTE_MODIFIER);
    public static final SerializableDataType<List<AttributedEntityAttributeModifier>> ATTRIBUTED_ATTRIBUTE_MODIFIERS = SerializableDataType.list(ATTRIBUTED_ATTRIBUTE_MODIFIER);
    public static final SerializableDataType<PowerTypeReference> POWER_TYPE = SerializableDataType.wrap(PowerTypeReference.class, IDENTIFIER, PowerType::getIdentifier, PowerTypeReference::new);
    public static final SerializableDataType<Item> ITEM = SerializableDataType.registry(Item.class, Registry.field_212630_s);
    public static final SerializableDataType<Effect> STATUS_EFFECT = SerializableDataType.registry(Effect.class, Registry.field_212631_t);
    public static final SerializableDataType<List<Effect>> STATUS_EFFECTS = SerializableDataType.list(STATUS_EFFECT);
    public static final SerializableDataType<EffectInstance> STATUS_EFFECT_INSTANCE = new SerializableDataType<EffectInstance>(EffectInstance.class, SerializationHelper::writeStatusEffect, SerializationHelper::readStatusEffect, SerializationHelper::readStatusEffect);
    public static final SerializableDataType<List<EffectInstance>> STATUS_EFFECT_INSTANCES = SerializableDataType.list(STATUS_EFFECT_INSTANCE);
    public static final SerializableDataType<ITag<Fluid>> FLUID_TAG = SerializableDataType.wrap(ClassUtil.castClass(ITag.class), IDENTIFIER, fluid -> TagCollectionManager.func_242178_a().func_241837_c().func_232975_b_(fluid), SerializationHelper::getFluidTagFromId);
    public static final SerializableDataType<ITag<Block>> BLOCK_TAG = SerializableDataType.wrap(ClassUtil.castClass(ITag.class), IDENTIFIER, block -> TagCollectionManager.func_242178_a().func_241835_a().func_232975_b_(block), SerializationHelper::getBlockTagFromId);
    public static final SerializableDataType<Comparison> COMPARISON = SerializableDataType.enumValue(Comparison.class, SerializationHelper.buildEnumMap(Comparison.class, Comparison::getComparisonString));
    public static final SerializableDataType<Space> SPACE = SerializableDataType.enumValue(Space.class);
    public static final SerializableDataType<ConditionFactory.Instance> ENTITY_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.ENTITY);
    public static final SerializableDataType<List<ConditionFactory.Instance>> ENTITY_CONDITIONS = SerializableDataType.list(ENTITY_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> ITEM_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.ITEM);
    public static final SerializableDataType<List<ConditionFactory.Instance>> ITEM_CONDITIONS = SerializableDataType.list(ITEM_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> BLOCK_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.BLOCK);
    public static final SerializableDataType<List<ConditionFactory.Instance>> BLOCK_CONDITIONS = SerializableDataType.list(BLOCK_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> FLUID_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.FLUID);
    public static final SerializableDataType<List<ConditionFactory.Instance>> FLUID_CONDITIONS = SerializableDataType.list(FLUID_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> DAMAGE_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.DAMAGE);
    public static final SerializableDataType<List<ConditionFactory.Instance>> DAMAGE_CONDITIONS = SerializableDataType.list(DAMAGE_CONDITION);
    public static final SerializableDataType<ConditionFactory.Instance> BIOME_CONDITION = SerializableDataType.condition(ClassUtil.castClass(ConditionFactory.Instance.class), ConditionTypes.BIOME);
    public static final SerializableDataType<List<ConditionFactory.Instance>> BIOME_CONDITIONS = SerializableDataType.list(BIOME_CONDITION);
    public static final SerializableDataType<ActionFactory.Instance> ENTITY_ACTION = SerializableDataType.effect(ClassUtil.castClass(ActionFactory.Instance.class), ActionTypes.ENTITY);
    public static final SerializableDataType<List<ActionFactory.Instance>> ENTITY_ACTIONS = SerializableDataType.list(ENTITY_ACTION);
    public static final SerializableDataType<ActionFactory.Instance> BLOCK_ACTION = SerializableDataType.effect(ClassUtil.castClass(ActionFactory.Instance.class), ActionTypes.BLOCK);
    public static final SerializableDataType<List<ActionFactory.Instance>> BLOCK_ACTIONS = SerializableDataType.list(BLOCK_ACTION);
    public static final SerializableDataType<ActionFactory.Instance> ITEM_ACTION = SerializableDataType.effect(ClassUtil.castClass(ActionFactory.Instance.class), ActionTypes.ITEM);
    public static final SerializableDataType<List<ActionFactory.Instance>> ITEM_ACTIONS = SerializableDataType.list(ITEM_ACTION);
    public static final SerializableDataType<Ingredient> INGREDIENT = new SerializableDataType<Ingredient>(Ingredient.class, (buffer, ingredient) -> ingredient.func_199564_a(buffer), Ingredient::func_199566_b, Ingredient::func_199802_a);
    public static final SerializableDataType<Block> BLOCK = SerializableDataType.registry(Block.class, Registry.field_212618_g);
    public static final SerializableDataType<HudRender> HUD_RENDER = SerializableDataType.compound(HudRender.class, new SerializableData().add("should_render", BOOLEAN, true).add("bar_index", INT, 0).add("sprite_location", IDENTIFIER, Origins.identifier("textures/gui/resource_bar.png")).add("condition", ENTITY_CONDITION, null), dataInst -> new HudRender(dataInst.getBoolean("should_render"), dataInst.getInt("bar_index"), dataInst.getId("sprite_location"), (ConditionFactory.Instance)dataInst.get("condition")), (data, inst) -> {
        SerializableData.Instance dataInst = (SerializableData)data.new SerializableData.Instance();
        dataInst.set("should_render", inst.shouldRender());
        dataInst.set("bar_index", inst.getBarIndex());
        dataInst.set("sprite_location", inst.getSpriteLocation());
        dataInst.set("condition", inst.getCondition());
        return dataInst;
    });
    public static final SerializableDataType<CreatureAttribute> ENTITY_GROUP = SerializableDataType.mapped(CreatureAttribute.class, HashBiMap.create((Map)ImmutableMap.of((Object)"default", (Object)CreatureAttribute.field_223222_a_, (Object)"undead", (Object)CreatureAttribute.field_223223_b_, (Object)"arthropod", (Object)CreatureAttribute.field_223224_c_, (Object)"illager", (Object)CreatureAttribute.field_223225_d_, (Object)"aquatic", (Object)CreatureAttribute.field_203100_e)));
    public static final SerializableDataType<EquipmentSlotType> EQUIPMENT_SLOT = SerializableDataType.enumValue(EquipmentSlotType.class);
    public static final SerializableDataType<SoundEvent> SOUND_EVENT = SerializableDataType.registry(SoundEvent.class, Registry.field_212633_v);
    public static final SerializableDataType<EntityType<?>> ENTITY_TYPE = SerializableDataType.registry(ClassUtil.castClass(EntityType.class), Registry.field_212629_r);
    public static final SerializableDataType<ParticleType<?>> PARTICLE_TYPE = SerializableDataType.registry(ClassUtil.castClass(ParticleType.class), Registry.field_212632_u);
    public static final SerializableDataType<CompoundNBT> NBT = SerializableDataType.wrap(CompoundNBT.class, STRING, CompoundNBT::toString, str -> {
        try {
            return new JsonToNBT(new StringReader(str)).func_193593_f();
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Could not parse NBT tag, exception: " + e.getMessage());
        }
    });
    public static final SerializableDataType<ItemStack> ITEM_STACK = SerializableDataType.compound(ItemStack.class, new SerializableData().add("item", ITEM).add("amount", INT, 1).add("tag", NBT, null), data -> {
        ItemStack stack = new ItemStack((IItemProvider)data.get("item"), data.getInt("amount"));
        if (data.isPresent("tag")) {
            stack.func_77982_d((CompoundNBT)data.get("tag"));
        }
        return stack;
    }, (serializableData, itemStack) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("item", itemStack.func_77973_b());
        data.set("amount", itemStack.func_190916_E());
        data.set("tag", itemStack.func_77942_o() ? itemStack.func_77978_p() : null);
        return data;
    });
    public static final SerializableDataType<List<ItemStack>> ITEM_STACKS = SerializableDataType.list(ITEM_STACK);
    public static final SerializableDataType<Tuple<Integer, ItemStack>> POSITIONED_ITEM_STACK = SerializableDataType.compound(ClassUtil.castClass(Tuple.class), new SerializableData().add("item", ITEM).add("amount", INT, 1).add("tag", NBT, null).add("slot", INT, Integer.MIN_VALUE), data -> {
        ItemStack stack = new ItemStack((IItemProvider)data.get("item"), data.getInt("amount"));
        if (data.isPresent("tag")) {
            stack.func_77982_d((CompoundNBT)data.get("tag"));
        }
        return new Tuple((Object)data.getInt("slot"), (Object)stack);
    }, (serializableData, positionedStack) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("item", ((ItemStack)positionedStack.func_76340_b()).func_77973_b());
        data.set("amount", ((ItemStack)positionedStack.func_76340_b()).func_190916_E());
        data.set("tag", ((ItemStack)positionedStack.func_76340_b()).func_77942_o() ? ((ItemStack)positionedStack.func_76340_b()).func_77978_p() : null);
        data.set("slot", positionedStack.func_76341_a());
        return data;
    });
    public static final SerializableDataType<List<Tuple<Integer, ItemStack>>> POSITIONED_ITEM_STACKS = SerializableDataType.list(POSITIONED_ITEM_STACK);
    public static SerializableDataType<RegistryKey<World>> DIMENSION = SerializableDataType.wrap(ClassUtil.castClass(RegistryKey.class), IDENTIFIER, RegistryKey::func_240901_a_, identifier -> RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)identifier));
    public static final SerializableDataType<Active.Key> KEY = SerializableDataType.compound(Active.Key.class, new SerializableData().add("key", STRING).add("continuous", BOOLEAN, false), data -> {
        Active.Key key = new Active.Key();
        key.key = data.getString("key");
        key.continuous = data.getBoolean("continuous");
        return key;
    }, (serializableData, key) -> {
        SerializableData.Instance data = (SerializableData)serializableData.new SerializableData.Instance();
        data.set("key", key.key);
        data.set("continuous", key.continuous);
        return data;
    });
    public static final SerializableDataType<Active.Key> BACKWARDS_COMPATIBLE_KEY = new SerializableDataType<Active.Key>(Active.Key.class, SerializableDataType.KEY.send, SerializableDataType.KEY.receive, jsonElement -> {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            String keyString = jsonElement.getAsString();
            Active.Key key = new Active.Key();
            key.key = keyString.equals("secondary") ? "key.origins.secondary_active" : "key.origins.primary_active";
            key.continuous = false;
            return key;
        }
        return (Active.Key)SerializableDataType.KEY.read.apply((JsonElement)jsonElement);
    });
    public static final SerializableDataType<ITag<EntityType<?>>> ENTITY_TAG = SerializableDataType.wrap(ClassUtil.castClass(ITag.class), IDENTIFIER, tag -> TagCollectionManager.func_242178_a().func_241838_d().func_232975_b_(tag), TagHooks::getEntityTypeOptional);
    public static final SerializableDataType<IRecipe> RECIPE = new SerializableDataType<IRecipe>(IRecipe.class, (buffer, recipe) -> {
        buffer.func_192572_a(Registry.field_218368_I.func_177774_c((Object)recipe.func_199559_b()));
        buffer.func_192572_a(recipe.func_199560_c());
        recipe.func_199559_b().func_199427_a_(buffer, recipe);
    }, buffer -> {
        ResourceLocation recipeSerializerId = buffer.func_192575_l();
        ResourceLocation recipeId = buffer.func_192575_l();
        IRecipeSerializer serializer = (IRecipeSerializer)Registry.field_218368_I.func_82594_a(recipeSerializerId);
        return serializer.func_199426_a_(recipeId, buffer);
    }, jsonElement -> {
        if (!jsonElement.isJsonObject()) {
            throw new RuntimeException("Expected recipe to be a JSON object.");
        }
        JsonObject json = jsonElement.getAsJsonObject();
        ResourceLocation recipeSerializerId = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)"type"));
        ResourceLocation recipeId = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)"id"));
        IRecipeSerializer serializer = (IRecipeSerializer)Registry.field_218368_I.func_82594_a(recipeSerializerId);
        return serializer.func_199425_a_(recipeId, json);
    });
    public static final SerializableDataType<ItemStack> ITEM_OR_ITEM_STACK = new SerializableDataType<ItemStack>(ItemStack.class, SerializableDataType.ITEM_STACK.send, SerializableDataType.ITEM_STACK.receive, jsonElement -> {
        if (jsonElement.isJsonPrimitive() && jsonElement.getAsJsonPrimitive().isString()) {
            Item item = ITEM.read((JsonElement)jsonElement);
            return new ItemStack((IItemProvider)item);
        }
        return (ItemStack)SerializableDataType.ITEM_STACK.read.apply((JsonElement)jsonElement);
    });
    private final Class<T> dataClass;
    private final BiConsumer<PacketBuffer, T> send;
    private final Function<PacketBuffer, T> receive;
    private final Function<JsonElement, T> read;

    public SerializableDataType(Class<T> dataClass, BiConsumer<PacketBuffer, T> send, Function<PacketBuffer, T> receive, Function<JsonElement, T> read) {
        this.dataClass = dataClass;
        this.send = send;
        this.receive = receive;
        this.read = read;
    }

    public void send(PacketBuffer buffer, Object value) {
        this.send.accept(buffer, (PacketBuffer)this.cast(value));
    }

    public T receive(PacketBuffer buffer) {
        return this.receive.apply(buffer);
    }

    public T read(JsonElement jsonElement) {
        return this.read.apply(jsonElement);
    }

    public T cast(Object data) {
        return this.dataClass.cast(data);
    }

    public static <T> SerializableDataType<List<T>> list(SerializableDataType<T> singleDataType) {
        return new SerializableDataType<List<T>>(ClassUtil.castClass(List.class), (buf, list) -> {
            buf.writeInt(list.size());
            for (Object elem : list) {
                singleDataType.send((PacketBuffer)buf, elem);
            }
        }, buf -> {
            int count = buf.readInt();
            LinkedList list = new LinkedList();
            for (int i = 0; i < count; ++i) {
                list.add(singleDataType.receive((PacketBuffer)buf));
            }
            return list;
        }, json -> {
            LinkedList list = new LinkedList();
            if (json.isJsonArray()) {
                for (JsonElement je : json.getAsJsonArray()) {
                    Object res = singleDataType.read(je);
                    if (res == null) continue;
                    list.add(res);
                }
            } else {
                Object res = singleDataType.read((JsonElement)json);
                if (res != null) {
                    list.add(res);
                }
            }
            return list;
        });
    }

    public static <T> SerializableDataType<T> registry(Class<T> dataClass, Registry<T> registry) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> buf.func_192572_a(registry.func_177774_c(t)), buf -> registry.func_82594_a(buf.func_192575_l()), json -> {
            ResourceLocation id;
            boolean isOptional = false;
            if (json.isJsonPrimitive()) {
                id = ResourceLocation.func_208304_a((String)json.getAsString());
            } else if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                id = ResourceLocation.func_208304_a((String)obj.get("name").getAsString());
                if (obj.has("platform") && !obj.get("platform").getAsString().equalsIgnoreCase(Platform.getModLoader())) {
                    return null;
                }
                isOptional = obj.has("optional") && obj.get("optional").getAsBoolean();
            } else {
                throw new RuntimeException("Json entry was neither a string nor an object.");
            }
            if (!registry.func_148742_b().contains(id)) {
                if (isOptional) {
                    return null;
                }
                throw new RuntimeException("Identifier \"" + id + "\" was not registered in registry \"" + registry.func_243578_f().func_240901_a_() + "\".");
            }
            return registry.func_82594_a(id);
        });
    }

    public static <T> SerializableDataType<T> compound(Class<T> dataClass, SerializableData data, Function<SerializableData.Instance, T> toInstance, BiFunction<SerializableData, T, SerializableData.Instance> toData) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> data.write((PacketBuffer)buf, (SerializableData.Instance)toData.apply(data, t)), buf -> toInstance.apply(data.read((PacketBuffer)buf)), json -> toInstance.apply(data.read(json.getAsJsonObject())));
    }

    public static <T extends Enum<T>> SerializableDataType<T> enumValue(Class<T> dataClass) {
        return SerializableDataType.enumValue(dataClass, null);
    }

    public static <T extends Enum<T>> SerializableDataType<T> enumValue(Class<T> dataClass, HashMap<String, T> additionalMap) {
        return new SerializableDataType<Enum>(dataClass, (buf, t) -> buf.writeInt(t.ordinal()), buf -> ((Enum[])dataClass.getEnumConstants())[buf.readInt()], json -> {
            if (json.isJsonPrimitive()) {
                JsonPrimitive primitive = json.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    int enumOrdinal = primitive.getAsInt();
                    Enum[] enumValues = (Enum[])dataClass.getEnumConstants();
                    if (enumOrdinal < 0 || enumOrdinal >= enumValues.length) {
                        throw new JsonSyntaxException("Expected to be in the range of 0 - " + (enumValues.length - 1));
                    }
                    return enumValues[enumOrdinal];
                }
                if (primitive.isString()) {
                    String enumName = primitive.getAsString();
                    try {
                        return Enum.valueOf(dataClass, enumName);
                    }
                    catch (IllegalArgumentException e0) {
                        try {
                            return Enum.valueOf(dataClass, enumName.toUpperCase(Locale.ROOT));
                        }
                        catch (IllegalArgumentException e1) {
                            try {
                                if (additionalMap == null || !additionalMap.containsKey(enumName)) {
                                    throw new IllegalArgumentException();
                                }
                                return (Enum)additionalMap.get(enumName);
                            }
                            catch (IllegalArgumentException e2) {
                                Enum[] enumValues = (Enum[])dataClass.getEnumConstants();
                                String stringOf = enumValues[0].name() + ", " + enumValues[0].name().toLowerCase(Locale.ROOT);
                                for (int i = 1; i < enumValues.length; ++i) {
                                    stringOf = stringOf + ", " + enumValues[i].name() + ", " + enumValues[i].name().toLowerCase(Locale.ROOT);
                                }
                                throw new JsonSyntaxException("Expected value to be a string of: " + stringOf);
                            }
                        }
                    }
                }
            }
            throw new JsonSyntaxException("Expected value to be either an integer or a string.");
        });
    }

    public static <T> SerializableDataType<T> mapped(Class<T> dataClass, BiMap<String, T> map) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> buf.func_180714_a((String)map.inverse().get(t)), buf -> map.get((Object)buf.func_150789_c(Short.MAX_VALUE)), json -> {
            JsonPrimitive primitive;
            if (json.isJsonPrimitive() && (primitive = json.getAsJsonPrimitive()).isString()) {
                String name = primitive.getAsString();
                try {
                    if (map == null || !map.containsKey((Object)name)) {
                        throw new IllegalArgumentException();
                    }
                    return map.get((Object)name);
                }
                catch (IllegalArgumentException e2) {
                    throw new JsonSyntaxException("Expected value to be a string of: " + map.keySet().stream().reduce((s0, s1) -> s0 + ", " + s1));
                }
            }
            throw new JsonSyntaxException("Expected value to be either a string.");
        });
    }

    public static <T> SerializableDataType<ConditionFactory.Instance> condition(Class<ConditionFactory.Instance> dataClass, ConditionType<T> conditionType) {
        return new SerializableDataType<ConditionFactory.Instance>(dataClass, conditionType::write, conditionType::read, conditionType::read);
    }

    public static <T> SerializableDataType<ActionFactory.Instance> effect(Class<ActionFactory.Instance> dataClass, ActionType<T> actionType) {
        return new SerializableDataType<ActionFactory.Instance>(dataClass, actionType::write, actionType::read, actionType::read);
    }

    public static <T, U> SerializableDataType<T> wrap(Class<T> dataClass, SerializableDataType<U> base, Function<T, U> toFunction, Function<U, T> fromFunction) {
        return new SerializableDataType<Object>(dataClass, (buf, t) -> base.send((PacketBuffer)buf, toFunction.apply(t)), buf -> fromFunction.apply(base.receive((PacketBuffer)buf)), json -> fromFunction.apply(base.read((JsonElement)json)));
    }

    public static <T> SerializableDataType<FilterableWeightedList<T>> weightedList(SerializableDataType<T> base) {
        return new SerializableDataType<FilterableWeightedList<T>>(ClassUtil.castClass(FilterableWeightedList.class), (buf, list) -> {
            buf.writeInt(list.size());
            list.entryStream().forEach(entry -> {
                base.send((PacketBuffer)buf, entry.func_220647_b());
                buf.writeInt(entry.field_220652_c);
            });
        }, buf -> {
            int count = buf.readInt();
            FilterableWeightedList list = new FilterableWeightedList();
            for (int i = 0; i < count; ++i) {
                Object t = base.receive((PacketBuffer)buf);
                int weight = buf.readInt();
                list.func_226313_a_(t, weight);
            }
            return list;
        }, json -> {
            FilterableWeightedList list = new FilterableWeightedList();
            if (json.isJsonArray()) {
                for (JsonElement je : json.getAsJsonArray()) {
                    JsonObject weightedObj = je.getAsJsonObject();
                    Object elem = base.read(weightedObj.get("element"));
                    int weight = JSONUtils.func_151203_m((JsonObject)weightedObj, (String)"weight");
                    list.func_226313_a_(elem, weight);
                }
            }
            return list;
        });
    }
}

