/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import me.shedaniel.architectury.hooks.TagHooks;
import net.minecraft.block.Block;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.fluid.Fluid;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;

public class SerializationHelper {
    public static ITag<Fluid> getFluidTagFromId(ResourceLocation id) {
        Optional<ITag.INamedTag> tag = FluidTags.func_241280_c_().stream().filter(f -> f.func_230234_a_().equals((Object)id)).findAny();
        if (tag.isPresent()) {
            return (ITag)tag.get();
        }
        return TagHooks.getFluidOptional((ResourceLocation)id);
    }

    public static ITag<Block> getBlockTagFromId(ResourceLocation id) {
        return TagHooks.getBlockOptional((ResourceLocation)id);
    }

    public static AttributeModifier readAttributeModifier(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            String name = JSONUtils.func_151219_a((JsonObject)json, (String)"name", (String)"Unnamed attribute modifier");
            String operation = JSONUtils.func_151200_h((JsonObject)json, (String)"operation").toUpperCase(Locale.ROOT);
            double value = JSONUtils.func_151217_k((JsonObject)json, (String)"value");
            return new AttributeModifier(name, value, AttributeModifier.Operation.valueOf((String)operation));
        }
        throw new JsonSyntaxException("Attribute modifier needs to be a JSON object.");
    }

    public static AttributeModifier readAttributeModifier(PacketBuffer buf) {
        String modName = buf.func_150789_c(Short.MAX_VALUE);
        double modValue = buf.readDouble();
        int operation = buf.readInt();
        return new AttributeModifier(modName, modValue, AttributeModifier.Operation.func_220372_a((int)operation));
    }

    public static void writeAttributeModifier(PacketBuffer buf, AttributeModifier modifier) {
        buf.func_180714_a(modifier.func_111166_b());
        buf.writeDouble(modifier.func_111164_d());
        buf.writeInt(modifier.func_220375_c().func_220371_a());
    }

    public static void writeAttributeModifier(AttributeModifier modifier, PacketBuffer buf) {
        buf.func_180714_a(modifier.func_111166_b());
        buf.writeDouble(modifier.func_111164_d());
        buf.writeInt(modifier.func_220375_c().func_220371_a());
    }

    public static EffectInstance readStatusEffect(JsonElement jsonElement) {
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            String effect = JSONUtils.func_151200_h((JsonObject)json, (String)"effect");
            Optional effectOptional = Registry.field_212631_t.func_241873_b(ResourceLocation.func_208304_a((String)effect));
            if (!effectOptional.isPresent()) {
                throw new JsonSyntaxException("Error reading status effect: could not find status effect with id: " + effect);
            }
            int duration = JSONUtils.func_151208_a((JsonObject)json, (String)"duration", (int)100);
            int amplifier = JSONUtils.func_151208_a((JsonObject)json, (String)"amplifier", (int)0);
            boolean ambient = JSONUtils.func_151209_a((JsonObject)json, (String)"is_ambient", (boolean)false);
            boolean showParticles = JSONUtils.func_151209_a((JsonObject)json, (String)"show_particles", (boolean)true);
            boolean showIcon = JSONUtils.func_151209_a((JsonObject)json, (String)"show_icon", (boolean)true);
            return new EffectInstance((Effect)effectOptional.get(), duration, amplifier, ambient, showParticles, showIcon);
        }
        throw new JsonSyntaxException("Expected status effect to be a json object.");
    }

    public static EffectInstance readStatusEffect(PacketBuffer buf) {
        ResourceLocation effect = buf.func_192575_l();
        int duration = buf.readInt();
        int amplifier = buf.readInt();
        boolean ambient = buf.readBoolean();
        boolean showParticles = buf.readBoolean();
        boolean showIcon = buf.readBoolean();
        return new EffectInstance((Effect)Registry.field_212631_t.func_82594_a(effect), duration, amplifier, ambient, showParticles, showIcon);
    }

    public static void writeStatusEffect(PacketBuffer buf, EffectInstance statusEffectInstance) {
        buf.func_192572_a(Registry.field_212631_t.func_177774_c((Object)statusEffectInstance.func_188419_a()));
        buf.writeInt(statusEffectInstance.func_76459_b());
        buf.writeInt(statusEffectInstance.func_76458_c());
        buf.writeBoolean(statusEffectInstance.func_82720_e());
        buf.writeBoolean(statusEffectInstance.func_188418_e());
        buf.writeBoolean(statusEffectInstance.func_205348_f());
    }

    public static <T extends Enum<T>> HashMap<String, T> buildEnumMap(Class<T> enumClass, Function<T, String> enumToString) {
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            map.put(enumToString.apply(enumConstant), enumConstant);
        }
        return map;
    }
}

