/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.config;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.BooleanToggleBuilder;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextDescriptionBuilder;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.util.LocalizableItem;
import snownee.kiwi.util.Util;

public class ClothConfigIntegration {
    private static final class_2561 requiresRestart = class_2561.method_43471((String)"kiwi.config.requiresRestart").method_27692(class_124.field_1061);

    public static class_437 create(class_437 parent, String namespace) {
        ConfigBuilder builder = ConfigBuilder.create();
        builder.setParentScreen(parent);
        List<ConfigHandler> configs = KiwiConfigManager.allConfigs.stream().filter($ -> $.getModId().equals(namespace)).toList();
        Joiner joiner = Joiner.on((char)'.');
        for (ConfigHandler config : configs) {
            String titleKey = config.getFileName().equals(config.getModId() + "-" + config.getType().extension()) ? config.getType().extension() : (config.getFileName().equals(config.getModId() + "-modules") ? "modules" : config.getFileName());
            class_5250 title = class_1074.method_4663((String)("kiwi.config." + titleKey)) ? class_2561.method_43471((String)("kiwi.config." + titleKey)) : class_2561.method_43470((String)Util.friendlyText(titleKey));
            ConfigCategory category = builder.getOrCreateCategory((class_2561)title);
            HashMap subCatsMap = Maps.newHashMap();
            ArrayList subCats = Lists.newArrayList();
            subCatsMap.put("", arg_0 -> ((ConfigCategory)category).addEntry(arg_0));
            for (ConfigHandler.Value<?> value : config.valueMap.values()) {
                ConfigUI.ItemType itemType;
                ConfigUI.Hide hide = value.getAnnotation(ConfigUI.Hide.class);
                if (hide != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String key = config.getModId() + ".config." + value.translation;
                title = class_1074.method_4663((String)key) ? class_2561.method_43471((String)key) : class_2561.method_43470((String)Util.friendlyText((String)path.get(path.size() - 1)));
                ConfigEntryBuilder entryBuilder = builder.entryBuilder();
                path.remove(path.size() - 1);
                String subCatKey = joiner.join((Iterable)path);
                Consumer subCat = subCatsMap.computeIfAbsent(subCatKey, $ -> {
                    String key0 = config.getModId() + ".config." + $;
                    class_5250 title0 = class_1074.method_4663((String)key0) ? class_2561.method_43471((String)key0) : class_2561.method_43470((String)Util.friendlyText((String)path.get(path.size() - 1)));
                    SubCategoryBuilder builder0 = entryBuilder.startSubCategory((class_2561)title0);
                    builder0.setExpanded(true);
                    subCats.add(builder0);
                    return arg_0 -> ((SubCategoryBuilder)builder0).add(arg_0);
                });
                ConfigUI.TextDescription description = value.field == null ? null : value.field.getAnnotation(ConfigUI.TextDescription.class);
                ClothConfigIntegration.putDescription(subCat, entryBuilder, description, false);
                BooleanListEntry entry = null;
                Class<?> type = value.getType();
                if (type == Boolean.TYPE) {
                    BooleanToggleBuilder toggle = entryBuilder.startBooleanToggle((class_2561)title, ((Boolean)value.value).booleanValue());
                    toggle.setTooltip(ClothConfigIntegration.createComment(value));
                    toggle.setSaveConsumer($ -> value.accept($, config.onChanged));
                    toggle.setDefaultValue(((Boolean)value.defValue).booleanValue());
                    entry = toggle.build();
                } else if (type == Integer.TYPE) {
                    ConfigUI.Color color = value.getAnnotation(ConfigUI.Color.class);
                    if (color != null) {
                        field = entryBuilder.startAlphaColorField((class_2561)title, ((Integer)value.value).intValue());
                        field.setAlphaMode(color.alpha());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue(((Integer)value.defValue).intValue());
                        entry = field.build();
                    } else if (value.getAnnotation(ConfigUI.Slider.class) != null) {
                        field = entryBuilder.startIntSlider((class_2561)title, ((Integer)value.value).intValue(), (int)value.min, (int)value.max);
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue(((Integer)value.defValue).intValue());
                        entry = field.build();
                    } else {
                        field = entryBuilder.startIntField((class_2561)title, ((Integer)value.value).intValue());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        if (!Double.isNaN(value.min)) {
                            field.setMin((int)value.min);
                        }
                        if (!Double.isNaN(value.max)) {
                            field.setMax((int)value.max);
                        }
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue(((Integer)value.defValue).intValue());
                        entry = field.build();
                    }
                } else if (type == Double.TYPE) {
                    field = entryBuilder.startDoubleField((class_2561)title, ((Double)value.value).doubleValue());
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    if (!Double.isNaN(value.min)) {
                        field.setMin(value.min);
                    }
                    if (!Double.isNaN(value.max)) {
                        field.setMax(value.max);
                    }
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue(((Double)value.defValue).doubleValue());
                    entry = field.build();
                } else if (type == Float.TYPE) {
                    field = entryBuilder.startFloatField((class_2561)title, ((Float)value.value).floatValue());
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    if (!Double.isNaN(value.min)) {
                        field.setMin((float)value.min);
                    }
                    if (!Double.isNaN(value.max)) {
                        field.setMax((float)value.max);
                    }
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue(((Float)value.defValue).floatValue());
                    entry = field.build();
                } else if (type == Long.TYPE) {
                    if (value.getAnnotation(ConfigUI.Slider.class) != null) {
                        field = entryBuilder.startLongSlider((class_2561)title, ((Long)value.value).longValue(), (long)value.min, (long)value.max);
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue(((Long)value.defValue).longValue());
                        entry = field.build();
                    } else {
                        field = entryBuilder.startLongField((class_2561)title, ((Long)value.value).longValue());
                        field.setTooltip(ClothConfigIntegration.createComment(value));
                        if (!Double.isNaN(value.min)) {
                            field.setMin((long)value.min);
                        }
                        if (!Double.isNaN(value.max)) {
                            field.setMax((long)value.max);
                        }
                        field.setSaveConsumer($ -> value.accept($, config.onChanged));
                        field.setDefaultValue(((Long)value.defValue).longValue());
                        entry = field.build();
                    }
                } else if (type == String.class) {
                    field = entryBuilder.startTextField((class_2561)title, (String)value.value);
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue((String)value.defValue);
                    entry = field.build();
                } else if (Enum.class.isAssignableFrom(type)) {
                    field = entryBuilder.startEnumSelector((class_2561)title, type, (Enum)value.value);
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue((Enum)value.defValue);
                    field.setEnumNameProvider($ -> {
                        if ($ instanceof LocalizableItem) {
                            LocalizableItem item = (LocalizableItem)((Object)$);
                            return item.getDisplayName().method_27661();
                        }
                        return class_2561.method_43470((String)$.name());
                    });
                    field.setTooltipSupplier($ -> {
                        ArrayList tooltip = Lists.newArrayList();
                        if ($ instanceof LocalizableItem) {
                            LocalizableItem item = (LocalizableItem)((Object)$);
                            tooltip.add(item.getDisplayName().method_27661().method_27693(" - ").method_10852(item.getDescription()));
                        }
                        ClothConfigIntegration.createComment(value).map(Arrays::asList).ifPresent(tooltip::addAll);
                        return tooltip.isEmpty() ? Optional.empty() : Optional.of((class_2561[])tooltip.toArray(class_2561[]::new));
                    });
                    entry = field.build();
                } else if (List.class.isAssignableFrom(type) && (itemType = value.field.getAnnotation(ConfigUI.ItemType.class)).value() == String.class) {
                    field = entryBuilder.startStrList((class_2561)title, (List)value.value);
                    field.setTooltip(ClothConfigIntegration.createComment(value));
                    field.setSaveConsumer($ -> value.accept($, config.onChanged));
                    field.setDefaultValue((List)value.defValue);
                    entry = field.build();
                }
                if (entry != null) {
                    entry.setRequiresRestart(value.requiresRestart);
                    subCat.accept(entry);
                }
                ClothConfigIntegration.putDescription(subCat, entryBuilder, description, true);
            }
            subCats.forEach($ -> category.addEntry((AbstractConfigListEntry)$.build()));
        }
        builder.setSavingRunnable(() -> configs.forEach(ConfigHandler::save));
        return builder.build();
    }

    private static void putDescription(Consumer<AbstractConfigListEntry<?>> subCat, ConfigEntryBuilder entryBuilder, ConfigUI.TextDescription description, boolean after) {
        if (description == null || description.after() != after) {
            return;
        }
        class_5250 component = class_1074.method_4663((String)description.value()) ? class_2561.method_43471((String)description.value()) : class_2561.method_43470((String)description.value());
        TextDescriptionBuilder builder = entryBuilder.startTextDescription((class_2561)component);
        subCat.accept((AbstractConfigListEntry<?>)builder.build());
    }

    private static Optional<class_2561[]> createComment(ConfigHandler.Value<?> value) {
        ArrayList tooltip = Lists.newArrayList();
        if (value.comment != null) {
            for (String comment : value.comment) {
                tooltip.add(class_2561.method_43470((String)comment));
            }
        }
        if (value.requiresRestart) {
            tooltip.add(requiresRestart);
        }
        return tooltip.isEmpty() ? Optional.empty() : Optional.of((class_2561[])tooltip.toArray(class_2561[]::new));
    }
}

