/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.contributor.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3883;
import net.minecraft.class_591;
import net.minecraft.class_742;
import snownee.kiwi.Kiwi;
import snownee.kiwi.contributor.client.CosmeticLayer;
import snownee.kiwi.contributor.impl.JsonTierProvider;
import snownee.kiwi.contributor.impl.client.layer.FoxTailLayer;
import snownee.kiwi.contributor.impl.client.layer.PlanetLayer;
import snownee.kiwi.contributor.impl.client.layer.SantaHatLayer;
import snownee.kiwi.contributor.impl.client.layer.SunnyMilkLayer;
import snownee.kiwi.loader.Platform;

public class KiwiTierProvider
extends JsonTierProvider {
    private final List<String> renderableTiers = ImmutableList.of((Object)"2020q3", (Object)"2020q4", (Object)"sunny_milk", (Object)"xmas");

    public KiwiTierProvider() {
        super("Snownee", KiwiTierProvider::getURLs);
    }

    private static List<String> getURLs() {
        String cdn = "https://cdn.jsdelivr.net/gh/Snownee/Kiwi@master/contributors.json";
        String github = "https://raw.githubusercontent.com/Snownee/Kiwi/master/contributors.json";
        String coding = "https://snownee.coding.net/p/test/d/test/git/raw/master/contributors.json";
        Locale locale = Locale.getDefault();
        if ("CN".equals(locale.getCountry()) && Calendar.getInstance().get(15) == 28800000) {
            Kiwi.logger.debug("Use fetching strategy 1");
            return ImmutableList.of((Object)cdn, (Object)coding);
        }
        Kiwi.logger.debug("Use fetching strategy 2");
        return ImmutableList.of((Object)cdn, (Object)github);
    }

    private static boolean isInXmas() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 15;
    }

    @Override
    public Set<String> getPlayerTiers(String playerName) {
        HashSet ret = super.getPlayerTiers(Platform.isProduction() ? playerName : "Dev");
        if (KiwiTierProvider.isInXmas()) {
            ret = Sets.newHashSet(ret);
            ret.add("xmas");
        }
        return ret;
    }

    @Override
    public Set<String> getTiers() {
        return ImmutableSet.copyOf(this.getRenderableTiers());
    }

    @Override
    public List<String> getRenderableTiers() {
        return this.renderableTiers;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public CosmeticLayer createRenderer(class_3883<class_742, class_591<class_742>> entityRenderer, String tier) {
        switch (tier) {
            case "2020q3": {
                return new PlanetLayer(entityRenderer);
            }
            case "2020q4": {
                return new FoxTailLayer(entityRenderer);
            }
            case "xmas": {
                return new SantaHatLayer(entityRenderer);
            }
            case "sunny_milk": {
                return new SunnyMilkLayer(entityRenderer);
            }
        }
        return null;
    }
}

