/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7699;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import snownee.kiwi.Kiwi;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.item.ItemCategoryFiller;

public class GroupSetting {
    private String[] groups;
    private String[] after;

    public static GroupSetting of(KiwiModule.Category category, GroupSetting preset) {
        if (preset != null && category.value().length == 0) {
            return new GroupSetting(preset.groups, category.after());
        }
        return new GroupSetting(category.value(), category.after());
    }

    public GroupSetting(String[] groups, String[] after) {
        this.groups = groups;
        this.after = after;
    }

    public void apply(ItemCategoryFiller filler) {
        List<class_1761> tabs = Stream.of(this.groups).map(Kiwi::getGroup).filter(Objects::nonNull).toList();
        Set afterItems = Stream.of(this.after).map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0)).filter(Predicate.not(class_1802.field_8162::equals)).collect(Collectors.toSet());
        for (class_1761 tab : tabs) {
            ItemGroupEvents.modifyEntriesEvent((class_5321)((class_5321)class_7923.field_44687.method_29113((Object)tab).orElseThrow())).register(entries -> {
                List<Object> items = Lists.newArrayList();
                filler.fillItemCategory(tab, entries.getEnabledFeatures(), entries.shouldShowOpRestrictedItems(), items);
                items = GroupSetting.getEnabledStacks(items, entries.getEnabledFeatures());
                GroupSetting.addAfter(items, entries.getDisplayStacks(), afterItems);
                GroupSetting.addAfter(items, entries.getSearchTabStacks(), afterItems);
            });
        }
    }

    private static void addAfter(List<class_1799> toAdd, List<class_1799> destination, Set<class_1792> afterItems) {
        int lastFound = -1;
        if (!afterItems.isEmpty()) {
            for (int i = 0; i < destination.size(); ++i) {
                class_1799 stack = destination.get(i);
                if (!afterItems.contains(stack.method_7909())) continue;
                lastFound = i;
            }
        }
        if (lastFound >= 0) {
            destination.addAll(lastFound + 1, toAdd);
        } else {
            destination.addAll(toAdd);
        }
    }

    private static List<class_1799> getEnabledStacks(List<class_1799> newStacks, class_7699 enabledFeatures) {
        if (newStacks.stream().allMatch($ -> GroupSetting.isEnabled($, enabledFeatures))) {
            return newStacks;
        }
        return newStacks.stream().filter($ -> GroupSetting.isEnabled($, enabledFeatures)).toList();
    }

    private static boolean isEnabled(class_1799 stack, class_7699 enabledFeatures) {
        return stack.method_7909().method_45382(enabledFeatures);
    }
}

