/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricBlockLootTableProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_52;
import net.minecraft.class_7923;
import snownee.kiwi.KiwiModules;
import snownee.kiwi.ModuleInfo;

public abstract class KiwiBlockLoot
extends FabricBlockLootTableProvider {
    private final List<class_2248> knownBlocks;
    private final Map<Class<?>, Function<class_2248, class_52.class_53>> handlers = Maps.newIdentityHashMap();
    private final Set<class_2248> added = Sets.newHashSet();
    private Function<class_2248, class_52.class_53> defaultHandler;

    protected KiwiBlockLoot(class_2960 moduleId, FabricDataOutput dataOutput) {
        super(dataOutput);
        ModuleInfo info = KiwiModules.get(moduleId);
        Objects.requireNonNull(info);
        this.knownBlocks = info.getRegistries(class_7923.field_41175);
    }

    protected void handle(Class<? extends class_2248> clazz, Function<class_2248, class_52.class_53> handler) {
        this.handlers.put(clazz, handler);
    }

    protected void handleDefault(Function<class_2248, class_52.class_53> handler) {
        this.defaultHandler = handler;
    }

    public void method_10379() {
        this.addTables();
        for (class_2248 block : this.knownBlocks) {
            class_52.class_53 builder;
            if (this.added.contains(block)) continue;
            this.added.add(block);
            Function<class_2248, class_52.class_53> handler = this.handlers.get(block.getClass());
            if (handler == null) {
                handler = this.defaultHandler;
            }
            if (handler == null || (builder = handler.apply(block)) == null) continue;
            this.method_45988(block, builder);
        }
    }

    protected abstract void addTables();

    public void method_45988(class_2248 block, class_52.class_53 builder) {
        super.method_45988(block, builder);
        this.added.add(block);
    }

    public List<class_2248> getKnownBlocks() {
        return this.knownBlocks;
    }
}

