/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_247;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import org.joml.Vector3d;
import snownee.kiwi.util.EnumUtil;

public final class VoxelUtil {
    private static final Vector3d fromOrigin = new Vector3d(-0.5, -0.5, -0.5);

    private VoxelUtil() {
    }

    public static class_238 rotate(class_238 box, class_2350 side) {
        switch (side) {
            case field_11033: {
                return box;
            }
            case field_11036: {
                return new class_238(box.field_1323, -box.field_1322, -box.field_1321, box.field_1320, -box.field_1325, -box.field_1324);
            }
            case field_11043: {
                return new class_238(box.field_1323, -box.field_1321, box.field_1322, box.field_1320, -box.field_1324, box.field_1325);
            }
            case field_11035: {
                return new class_238(-box.field_1323, -box.field_1321, -box.field_1322, -box.field_1320, -box.field_1324, -box.field_1325);
            }
            case field_11039: {
                return new class_238(box.field_1322, -box.field_1321, -box.field_1323, box.field_1325, -box.field_1324, -box.field_1320);
            }
            case field_11034: {
                return new class_238(-box.field_1322, -box.field_1321, box.field_1323, -box.field_1325, -box.field_1324, box.field_1320);
            }
        }
        return box;
    }

    public static class_238 rotate(class_238 box, class_2470 rotation) {
        switch (rotation) {
            case field_11467: {
                return box;
            }
            case field_11463: {
                return new class_238(-box.field_1321, box.field_1322, box.field_1323, -box.field_1324, box.field_1325, box.field_1320);
            }
            case field_11464: {
                return new class_238(-box.field_1323, box.field_1322, -box.field_1321, -box.field_1320, box.field_1325, -box.field_1324);
            }
            case field_11465: {
                return new class_238(box.field_1321, box.field_1322, -box.field_1323, box.field_1324, box.field_1325, -box.field_1320);
            }
        }
        return box;
    }

    public static class_238 rotateHorizontal(class_238 box, class_2350 side) {
        switch (side) {
            case field_11043: {
                return VoxelUtil.rotate(box, class_2470.field_11467);
            }
            case field_11035: {
                return VoxelUtil.rotate(box, class_2470.field_11464);
            }
            case field_11039: {
                return VoxelUtil.rotate(box, class_2470.field_11465);
            }
            case field_11034: {
                return VoxelUtil.rotate(box, class_2470.field_11463);
            }
        }
        return box;
    }

    public static class_265 rotate(class_265 shape, class_2350 side) {
        if (shape.method_1110() || shape == class_259.method_1077()) {
            return shape;
        }
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotate(box, side));
    }

    public static class_265 rotate(class_265 shape, class_2470 rotation) {
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotate(box, rotation));
    }

    public static class_265 rotateHorizontal(class_265 shape, class_2350 side) {
        if (shape.method_1110() || shape == class_259.method_1077()) {
            return shape;
        }
        return VoxelUtil.rotate(shape, box -> VoxelUtil.rotateHorizontal(box, side));
    }

    public static class_265 rotate(class_265 shape, UnaryOperator<class_238> rotateFunction) {
        ArrayList<class_265> rotatedPieces = new ArrayList<class_265>();
        List sourceBoundingBoxes = shape.method_1090();
        for (class_238 sourceBoundingBox : sourceBoundingBoxes) {
            rotatedPieces.add(class_259.method_1078((class_238)((class_238)rotateFunction.apply(sourceBoundingBox.method_989(VoxelUtil.fromOrigin.x, VoxelUtil.fromOrigin.y, VoxelUtil.fromOrigin.z))).method_989(-VoxelUtil.fromOrigin.x, -VoxelUtil.fromOrigin.z, -VoxelUtil.fromOrigin.z)));
        }
        return VoxelUtil.combine(rotatedPieces);
    }

    public static class_265 combine(class_265 ... shapes) {
        return VoxelUtil.batchCombine(class_259.method_1073(), class_247.field_1366, true, shapes);
    }

    public static class_265 combine(Collection<class_265> shapes) {
        return VoxelUtil.batchCombine(class_259.method_1073(), class_247.field_1366, true, shapes);
    }

    public static class_265 exclude(class_265 ... shapes) {
        return VoxelUtil.batchCombine(class_259.method_1077(), class_247.field_16886, true, shapes);
    }

    public static class_265 batchCombine(class_265 initial, class_247 function, boolean simplify, Collection<class_265> shapes) {
        class_265 combinedShape = initial;
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)shape, (class_247)function);
        }
        return simplify ? combinedShape.method_1097() : combinedShape;
    }

    public static class_265 batchCombine(class_265 initial, class_247 function, boolean simplify, class_265 ... shapes) {
        class_265 combinedShape = initial;
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)shape, (class_247)function);
        }
        return simplify ? combinedShape.method_1097() : combinedShape;
    }

    public static void setShape(class_265 shape, class_265[] dest, boolean verticalAxis) {
        VoxelUtil.setShape(shape, dest, verticalAxis, false);
    }

    public static void setShape(class_265 shape, class_265[] dest, boolean verticalAxis, boolean invert) {
        class_2350[] dirs;
        for (class_2350 side : dirs = verticalAxis ? EnumUtil.DIRECTIONS : EnumUtil.HORIZONTAL_DIRECTIONS) {
            dest[verticalAxis ? side.ordinal() : side.ordinal() - 2] = verticalAxis ? VoxelUtil.rotate(shape, invert ? side.method_10153() : side) : VoxelUtil.rotateHorizontal(shape, side);
        }
    }

    public static void setShape(class_265 shape, class_265[] dest) {
        VoxelUtil.setShape(shape, dest, false, false);
    }
}

