/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.block.entity;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.block.def.SimpleBlockDefinition;
import snownee.kiwi.block.entity.ModBlockEntity;
import snownee.kiwi.util.NBTHelper;

public abstract class RetextureBlockEntity
extends ModBlockEntity {
    @Nullable
    protected Map<String, BlockDefinition> textures;

    public RetextureBlockEntity(class_2591<?> tileEntityTypeIn, class_2338 level, class_2680 state, String ... textureKeys) {
        super(tileEntityTypeIn, level, state);
        this.persistData = true;
        this.textures = textureKeys.length == 0 ? null : Maps.newHashMapWithExpectedSize((int)textureKeys.length);
        for (String key : textureKeys) {
            this.textures.put(key, null);
        }
    }

    public static void setTexture(Map<String, String> textures, String key, String path) {
        if (!textures.containsKey(key)) {
            return;
        }
        textures.put(key, path);
    }

    public void setTexture(String key, BlockDefinition modelSupplier) {
        if (modelSupplier == null || !this.isValidTexture(modelSupplier)) {
            return;
        }
        RetextureBlockEntity.setTexture(this.textures, key, modelSupplier);
    }

    public boolean isValidTexture(BlockDefinition modelSupplier) {
        return true;
    }

    public static void setTexture(Map<String, BlockDefinition> textures, String key, BlockDefinition modelSupplier) {
        if (textures == null || !textures.containsKey(key)) {
            return;
        }
        textures.put(key, modelSupplier);
    }

    public static void setTexture(Map<String, BlockDefinition> textures, String key, class_1792 item) {
        class_2248 block = class_2248.method_9503((class_1792)item);
        if (block != null) {
            RetextureBlockEntity.setTexture(textures, key, SimpleBlockDefinition.of(block.method_9564()));
        }
    }

    @Override
    public void refresh() {
        if (this.field_11863 == null || !this.field_11863.field_9236) {
            super.refresh();
        }
    }

    @Override
    protected void readPacketData(class_2487 data) {
        if (!data.method_10573("Overrides", 10)) {
            return;
        }
        boolean shouldRefresh = RetextureBlockEntity.readTextures(this.textures, data.method_10562("Overrides"), (Predicate<BlockDefinition>)((Predicate)this::isValidTexture));
        if (shouldRefresh) {
            this.refresh();
        }
    }

    public static boolean readTextures(Map<String, BlockDefinition> textures, class_2487 data, Predicate<BlockDefinition> validator) {
        if (textures == null) {
            return false;
        }
        boolean shouldRefresh = false;
        NBTHelper helper = NBTHelper.of(data);
        for (String k : textures.keySet()) {
            BlockDefinition supplier;
            class_2487 v = helper.getTag(k);
            if (v == null || (supplier = BlockDefinition.fromNBT(v)) != null && !validator.test((Object)supplier) || Objects.equals(textures.get(k), supplier)) continue;
            shouldRefresh = true;
            textures.put(k, supplier);
        }
        return shouldRefresh;
    }

    @Override
    @NotNull
    protected class_2487 writePacketData(class_2487 data, class_7225.class_7874 provider) {
        RetextureBlockEntity.writeTextures(this.textures, data);
        return data;
    }

    public static class_2487 writeTextures(Map<String, BlockDefinition> textures, class_2487 data) {
        if (textures != null) {
            NBTHelper tag = NBTHelper.of(data);
            textures.forEach((k, v) -> {
                if (v == null) {
                    return;
                }
                class_2487 compound = new class_2487();
                v.save(compound);
                compound.method_10582("Type", v.getFactory().getId());
                tag.setTag("Overrides." + k, (class_2520)compound);
            });
        }
        return data;
    }
}

