/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_7157;
import snownee.kiwi.config.ClothConfigIntegration;
import snownee.kiwi.config.ConfigLibAttributes;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.loader.Platform;

public class KiwiClientCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 registryAccess) {
        LiteralArgumentBuilder builder = ClientCommandManager.literal((String)"kiwic");
        LiteralArgumentBuilder configure = ClientCommandManager.literal((String)"configure");
        ArrayList list = Lists.newArrayList();
        if (Platform.isModLoaded("cloth-config")) {
            list.add(ClothConfigIntegration.attributes());
        }
        if (list.isEmpty()) {
            configure.executes(ctx -> {
                ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.kiwi.configure.install"));
                return 0;
            });
        } else {
            HashSet addedMods = Sets.newHashSet();
            for (ConfigLibAttributes attributes : list) {
                KiwiClientCommand.putMods(attributes, addedMods, (LiteralArgumentBuilder<FabricClientCommandSource>)configure);
            }
        }
        builder.then((ArgumentBuilder)configure);
        dispatcher.register(builder);
    }

    private static void putMods(ConfigLibAttributes attributes, Set<String> addedMods, LiteralArgumentBuilder<FabricClientCommandSource> node) {
        for (String modId : KiwiConfigManager.getModsWithScreen(attributes)) {
            if (addedMods.contains(modId)) continue;
            addedMods.add(modId);
            node.then(ClientCommandManager.literal((String)modId).executes(ctx -> {
                class_437 screen = attributes.screenFactory().apply(modId);
                if (screen == null) {
                    ((FabricClientCommandSource)ctx.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"commands.kiwi.configure.failed"));
                    return 0;
                }
                class_310.method_1551().method_18858(() -> class_310.method_1551().method_1507(screen));
                return 1;
            }));
        }
    }
}

