/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2405;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7417;
import net.minecraft.class_7784;
import net.minecraft.class_7924;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.util.GameObjectLookup;
import snownee.kiwi.util.KUtil;

public class KiwiLanguageProvider
extends FabricLanguageProvider {
    protected final String languageCode;
    protected final CompletableFuture<class_7225.class_7874> registryLookup;

    public KiwiLanguageProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
        this(dataOutput, "en_us", registryLookup);
    }

    public KiwiLanguageProvider(FabricDataOutput dataOutput, String languageCode, CompletableFuture<class_7225.class_7874> registryLookup) {
        super(dataOutput, languageCode, registryLookup);
        this.languageCode = languageCode;
        this.registryLookup = registryLookup;
    }

    public void generateTranslations(class_7225.class_7874 registryLookup, FabricLanguageProvider.TranslationBuilder translationBuilder) {
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        try {
            Path existingFilePath = this.createPath(this.languageCode + ".existing");
            translationBuilder.add(existingFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public Path createPath(String path) {
        return (Path)this.dataOutput.getModContainer().findPath("assets/%s/lang/%s.json".formatted(this.dataOutput.getModId(), path)).orElseThrow();
    }

    public CompletableFuture<?> method_10319(class_7403 writer) {
        TreeMap translationEntries = new TreeMap();
        return this.registryLookup.thenCompose(lookup -> {
            this.generateModNameAndDescription(translationEntries);
            this.generateConfigEntries(translationEntries);
            this.generateTranslations((class_7225.class_7874)lookup, (key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                if (translationEntries.containsKey(key)) {
                    throw new RuntimeException("Existing translation key found - " + key + " - Duplicate will be ignored.");
                }
                translationEntries.put(key, value);
            });
            this.putExistingTranslations((key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                translationEntries.put(key, value);
            });
            JsonObject langEntryJson = new JsonObject();
            for (Map.Entry entry : translationEntries.entrySet()) {
                langEntryJson.addProperty((String)entry.getKey(), (String)entry.getValue());
            }
            return class_2405.method_10320((class_7403)writer, (JsonElement)langEntryJson, (Path)this.getLangFilePath(this.languageCode));
        });
    }

    protected void generateConfigEntries(Map<String, String> translationEntries) {
        for (ConfigHandler handler : KiwiConfigManager.allConfigs) {
            String fileName;
            if (!Objects.equals(handler.getModId(), this.dataOutput.getModId()) || (fileName = handler.getFileName()).equals("test")) continue;
            String key = handler.getTranslationKey();
            if (Objects.equals(key, fileName)) {
                translationEntries.put("kiwi.config." + key, KUtil.friendlyText(key));
            }
            HashSet subCats = Sets.newHashSet();
            for (ConfigHandler.Value<?> value : handler.getValueMap().values()) {
                ConfigUI.Hide hide;
                if (value.path.startsWith("modules.test") || (hide = value.getAnnotation(ConfigUI.Hide.class)) != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String title = KUtil.friendlyText((String)path.remove(path.size() - 1));
                String subCatKey = String.join((CharSequence)".", path);
                if (!path.isEmpty() && !subCats.contains(subCatKey)) {
                    subCats.add(subCatKey);
                    translationEntries.put(handler.getModId() + ".config." + subCatKey, KUtil.friendlyText((String)path.get(path.size() - 1)));
                }
                translationEntries.put(value.translation, title);
                translationEntries.put(value.translation + ".desc", "");
            }
        }
    }

    protected void generateGameObjectsEntries(Map<String, String> translationEntries) {
        this.generateGameObjectEntries(translationEntries, class_7924.field_41254, class_2248::method_9539);
        this.generateGameObjectEntries(translationEntries, class_7924.field_41197, class_1792::method_7876);
        this.generateGameObjectEntries(translationEntries, class_7924.field_41266, class_1299::method_5882);
        this.generateGameObjectEntries(translationEntries, class_7924.field_44688, tab -> {
            class_2561 component = tab.method_7737();
            class_7417 patt0$temp = component.method_10851();
            if (patt0$temp instanceof class_2588) {
                class_2588 contents = (class_2588)patt0$temp;
                return contents.method_11022();
            }
            return null;
        });
        this.generateGameObjectEntries(translationEntries, class_7924.field_41263, stat -> class_156.method_646((String)"stat", (class_2960)stat));
        this.generateGameObjectEntries(translationEntries, class_7924.field_41208, class_1291::method_5567);
    }

    protected void generateModNameAndDescription(Map<String, String> translationEntries) {
        ModContainer container = this.dataOutput.getModContainer();
        String modId = this.dataOutput.getModId();
        translationEntries.put("modmenu.nameTranslation.%s".formatted(modId), container.getMetadata().getName());
        translationEntries.put("modmenu.descriptionTranslation.%s".formatted(modId), container.getMetadata().getDescription());
    }

    protected <T> void generateGameObjectEntries(Map<String, String> translationEntries, class_5321<class_2378<T>> registryKey, Function<T, String> keyMapper) {
        GameObjectLookup.allHolders(registryKey, this.dataOutput.getModId()).forEach(holder -> {
            String key = (String)keyMapper.apply(holder.comp_349());
            if (key != null) {
                translationEntries.put(key, KUtil.friendlyText(holder.method_40237().method_29177().method_12832()));
            }
        });
    }

    private Path getLangFilePath(String code) {
        return this.dataOutput.method_45973(class_7784.class_7490.field_39368, "lang").method_44107(class_2960.method_60655((String)this.dataOutput.getModId(), (String)code));
    }
}

