/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.chars.Char2ObjectArrayMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_8957;
import net.minecraft.class_9129;
import net.minecraft.class_9694;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicShapedRecipe
extends class_1852 {
    protected class_8957 pattern;
    protected String rawPattern;
    protected boolean differentInputs;
    protected boolean showNotification;
    protected class_1799 result;
    protected String group;

    public DynamicShapedRecipe(String group, class_7710 category, class_8957 pattern, class_1799 result, boolean showNotification, boolean differentInputs) {
        super(category);
        this.group = group;
        this.pattern = pattern;
        this.rawPattern = String.join((CharSequence)"", ((class_8957.class_8958)pattern.field_51640.orElseThrow()).comp_2086());
        this.result = result;
        this.showNotification = showNotification;
        this.differentInputs = differentInputs;
    }

    public DynamicShapedRecipe(class_7710 category) {
        super(category);
    }

    public boolean matches(class_9694 input, class_1937 worldIn) {
        return this.search(input) != null;
    }

    @Nullable
    public int[] search(class_9694 input) {
        for (int x = 0; x <= input.method_59991() - this.getWidth(); ++x) {
            for (int y = 0; y <= input.method_59992() - this.getHeight(); ++y) {
                if (!this.checkMatch(input, x, y) || !this.checkEmpty(input, x, y)) continue;
                return new int[]{x, y};
            }
        }
        return null;
    }

    public class_1799 item(char key, class_9694 inv, int[] matchPos) {
        int i = this.rawPattern.indexOf(key);
        if (i != -1) {
            int x = matchPos[0] + i % this.getWidth();
            int y = matchPos[1] + i / this.getWidth();
            return inv.method_59984(x + y * inv.method_59991());
        }
        return class_1799.field_8037;
    }

    public List<class_1799> items(char key, class_9694 inv, int[] matchPos) {
        ArrayList items = Lists.newArrayList();
        for (int i = 0; i < this.rawPattern.length(); ++i) {
            if (key != this.rawPattern.charAt(i)) continue;
            int x = matchPos[0] + i % this.getWidth();
            int y = matchPos[1] + i / this.getWidth();
            items.add(inv.method_59984(x + y * inv.method_59991()));
        }
        return items;
    }

    public abstract class_1799 assemble(class_9694 var1, class_7225.class_7874 var2);

    public int getWidth() {
        return this.pattern.method_59995();
    }

    public int getHeight() {
        return this.pattern.method_59996();
    }

    public boolean method_8113(int width, int height) {
        return width >= this.getWidth() && height >= this.getHeight();
    }

    public String method_8112() {
        return this.group;
    }

    public boolean method_49188() {
        return this.showNotification;
    }

    public class_1799 result() {
        return this.result;
    }

    public class_8957 pattern() {
        return this.pattern;
    }

    public boolean allowDifferentInputs() {
        return this.differentInputs;
    }

    public class_2371<class_1856> method_8117() {
        return this.pattern.method_59997();
    }

    public abstract class_1865<?> method_8119();

    protected boolean checkMatch(class_9694 input, int startX, int startY) {
        Char2ObjectArrayMap ingredientsArrayMap = null;
        if (!this.differentInputs) {
            ingredientsArrayMap = new Char2ObjectArrayMap();
        }
        for (int y = startY; y < startY + this.getHeight(); ++y) {
            for (int x = startX; x < startX + this.getWidth(); ++x) {
                int i;
                char key;
                int rx = x - startX;
                int ry = y - startY;
                if (!this.matches(input, x, y, rx, ry)) {
                    return false;
                }
                if (this.differentInputs || (key = this.rawPattern.charAt(i = rx + ry * this.getWidth())) == ' ') continue;
                class_1799 stack0 = input.method_59984(x + y * input.method_59991());
                class_1799 stack1 = (class_1799)ingredientsArrayMap.get(key);
                if (stack1 == null) {
                    ingredientsArrayMap.put(key, (Object)stack0);
                    continue;
                }
                if (class_1799.method_31577((class_1799)stack1, (class_1799)stack0)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean matches(class_9694 inv, int x, int y, int rx, int ry) {
        class_1856 ingredient = (class_1856)this.method_8117().get(rx + ry * this.getWidth());
        return ingredient.method_8093(inv.method_59984(x + y * inv.method_59991()));
    }

    protected boolean checkEmpty(class_9694 inv, int startX, int startY) {
        for (int y = 0; y < inv.method_59992(); ++y) {
            int subY = y - startY;
            for (int x = 0; x < inv.method_59991(); ++x) {
                int subX = x - startX;
                if (subX >= 0 && subY >= 0 && subX < this.getWidth() && subY < this.getHeight() || this.getEmptyPredicate().test(inv.method_59984(x + y * inv.method_59991()))) continue;
                return false;
            }
        }
        return true;
    }

    protected Predicate<class_1799> getEmptyPredicate() {
        return class_1856.field_9017;
    }

    public static abstract class Serializer<T extends DynamicShapedRecipe>
    implements class_1865<T> {
        public static <T extends DynamicShapedRecipe> T fromNetwork(Function<class_7710, T> constructor, class_9129 buffer) {
            DynamicShapedRecipe recipe = (DynamicShapedRecipe)((Object)constructor.apply((class_7710)buffer.method_10818(class_7710.class)));
            recipe.group = buffer.method_10800(256);
            recipe.result = (class_1799)class_1799.field_48349.decode((Object)buffer);
            recipe.pattern = (class_8957)class_8957.field_48359.decode((Object)buffer);
            recipe.differentInputs = buffer.readBoolean();
            return (T)((Object)recipe);
        }

        public static <T extends DynamicShapedRecipe> void toNetwork(class_9129 buffer, T recipe) {
            buffer.method_10817((Enum)recipe.method_45441());
            buffer.method_10788(recipe.method_8112(), 256);
            class_1799.field_48349.encode((Object)buffer, (Object)recipe.result);
            class_8957.field_48359.encode((Object)buffer, (Object)recipe.pattern);
            recipe.rawPattern = String.join((CharSequence)"", ((class_8957.class_8958)recipe.pattern.field_51640.orElseThrow()).comp_2086());
            buffer.method_52964(recipe.differentInputs);
        }
    }
}

