/*
 * Decompiled with CFR 0.152.
 */
package gd.rf.acro.platos;

import gd.rf.acro.platos.ConfigUtils;
import gd.rf.acro.platos.blocks.BlockControlWheel;
import gd.rf.acro.platos.blocks.NotFullBlock;
import gd.rf.acro.platos.entity.BlockShipEntity;
import gd.rf.acro.platos.entity.BlockShipEntityRenderer;
import gd.rf.acro.platos.items.BoardingStairsItem;
import gd.rf.acro.platos.items.ClearingScytheItem;
import gd.rf.acro.platos.items.ControlKeyItem;
import gd.rf.acro.platos.items.LiftJackItem;
import gd.rf.acro.platos.items.WrenchItem;
import gd.rf.acro.platos.network.NetworkHandler;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="platos")
public class PlatosTransporters {
    public static final String MODID = "platos";
    public static final ItemGroup TAB = ItemGroup.field_78026_f;
    public static KeyBinding SHIP_UP;
    public static KeyBinding SHIP_DOWN;
    public static KeyBinding SHIP_STOP;
    public static final EntityType<BlockShipEntity> BLOCK_SHIP_ENTITY_ENTITY_TYPE;
    public static final ITag.INamedTag BOAT_MATERIAL;
    public static final ITag.INamedTag BOAT_MATERIAL_BLACKLIST;
    public static final ITag.INamedTag SCYTHEABLE;
    public static final BlockControlWheel BLOCK_CONTROL_WHEEL;
    public static final NotFullBlock BALLOON_BLOCK;
    public static final NotFullBlock FLOAT_BLOCK;
    public static final NotFullBlock WHEEL_BLOCK;
    public static final ControlKeyItem CONTROL_KEY_ITEM;
    public static final LiftJackItem LIFT_JACK_ITEM;
    public static final WrenchItem WRENCH_ITEM;
    public static final ClearingScytheItem CLEARING_SCYTHE_ITEM;
    public static final BoardingStairsItem BOARDING_STAIRS_ITEM;

    private static <T extends AnimalEntity> EntityType<T> createEntity(String name, EntityType.IFactory<T> factory, float width, float height) {
        ResourceLocation location = new ResourceLocation(MODID, name);
        EntityType entity = EntityType.Builder.func_220322_a(factory, (EntityClassification)EntityClassification.CREATURE).func_220321_a(width, height).setTrackingRange(64).setUpdateInterval(1).func_206830_a(location.toString());
        entity.setRegistryName(location);
        return entity;
    }

    static InputMappings.Input getKey(int key) {
        return InputMappings.Type.KEYSYM.func_197944_a(key);
    }

    public PlatosTransporters() {
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.registerBlocks();
        this.registerItems();
        ConfigUtils.checkConfigs();
        NetworkHandler.registerMessages();
        System.out.println("Hello Fabric world!");
        eventBus.addListener(this::setupClient);
    }

    private static KeyBinding registerKeybinding(KeyBinding key) {
        ClientRegistry.registerKeyBinding((KeyBinding)key);
        return key;
    }

    public void setupClient(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(BLOCK_SHIP_ENTITY_ENTITY_TYPE, BlockShipEntityRenderer::new);
        SHIP_UP = PlatosTransporters.registerKeybinding(new KeyBinding("key.platos.up", 90, "category.platos.main"));
        SHIP_DOWN = PlatosTransporters.registerKeybinding(new KeyBinding("key.platos.down", 67, "category.platos.main"));
        SHIP_STOP = PlatosTransporters.registerKeybinding(new KeyBinding("key.platos.stop", 86, "category.platos.main"));
    }

    private void registerBlocks() {
        PlatosTransporters.registerBlock((Block)BLOCK_CONTROL_WHEEL, "ship_controller");
        PlatosTransporters.registerBlock(BALLOON_BLOCK, "balloon_block");
        PlatosTransporters.registerBlock(FLOAT_BLOCK, "float_block");
        PlatosTransporters.registerBlock(WHEEL_BLOCK, "wheel_block");
    }

    private void registerItems() {
        PlatosTransporters.registerItem(CONTROL_KEY_ITEM, "control_key");
        PlatosTransporters.registerItem(LIFT_JACK_ITEM, "lift_jack");
        PlatosTransporters.registerItem(WRENCH_ITEM, "wrench");
        PlatosTransporters.registerItem(CLEARING_SCYTHE_ITEM, "clearing_scythe");
        PlatosTransporters.registerItem(BOARDING_STAIRS_ITEM, "boarding_stairs");
    }

    public static void givePlayerStartBook(PlayerEntity playerEntity) {
        if (!playerEntity.func_184216_O().contains("platos_new") && playerEntity.field_70170_p.field_72995_K) {
            playerEntity.func_191521_c(PlatosTransporters.createBook("Acro", "Plato's Transporters", I18n.func_135052_a((String)"book.platos.page1", (Object[])new Object[0]), I18n.func_135052_a((String)"book.platos.page2", (Object[])new Object[0]), I18n.func_135052_a((String)"book.platos.page3", (Object[])new Object[0]), I18n.func_135052_a((String)"book.platos.page4", (Object[])new Object[0]), I18n.func_135052_a((String)"book.platos.page5", (Object[])new Object[0]), I18n.func_135052_a((String)"book.platos.page6", (Object[])new Object[0]), I18n.func_135052_a((String)"book.platos.page7", (Object[])new Object[0])));
        }
        playerEntity.func_184211_a("platos_new");
    }

    private static ItemStack createBook(String author, String title, Object ... pages) {
        ItemStack book = new ItemStack((IItemProvider)Items.field_151164_bB);
        CompoundNBT tags = new CompoundNBT();
        tags.func_74778_a("author", author);
        tags.func_74778_a("title", title);
        ListNBT contents = new ListNBT();
        for (Object page : pages) {
            contents.add((Object)StringNBT.func_229705_a_((String)("{\"text\":\"" + page + "\"}")));
        }
        tags.func_218657_a("pages", (INBT)contents);
        book.func_77982_d(tags);
        return book;
    }

    public static Item registerItem(Item item, String name) {
        item.setRegistryName(name);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
        return item;
    }

    public static Block registerBlock(Block block, String name) {
        BlockItem itemBlock = new BlockItem(block, new Item.Properties().func_200916_a(TAB));
        block.setRegistryName(name);
        itemBlock.setRegistryName(name);
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        return block;
    }

    static {
        BLOCK_SHIP_ENTITY_ENTITY_TYPE = PlatosTransporters.createEntity("block_ship", BlockShipEntity::new, 1.0f, 1.0f);
        BOAT_MATERIAL = BlockTags.func_199894_a((String)"platos:boat_material");
        BOAT_MATERIAL_BLACKLIST = BlockTags.func_199894_a((String)"platos:boat_material_blacklist");
        SCYTHEABLE = BlockTags.func_199894_a((String)"platos:scytheable");
        BLOCK_CONTROL_WHEEL = new BlockControlWheel(AbstractBlock.Properties.func_200945_a((Material)Material.field_151575_d));
        BALLOON_BLOCK = new NotFullBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n));
        FLOAT_BLOCK = new NotFullBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n));
        WHEEL_BLOCK = new NotFullBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151580_n));
        CONTROL_KEY_ITEM = new ControlKeyItem(new Item.Properties().func_200916_a(TAB));
        LIFT_JACK_ITEM = new LiftJackItem(new Item.Properties().func_200916_a(TAB));
        WRENCH_ITEM = new WrenchItem(new Item.Properties().func_200916_a(TAB));
        CLEARING_SCYTHE_ITEM = new ClearingScytheItem(new Item.Properties().func_200916_a(TAB).func_200918_c(100));
        BOARDING_STAIRS_ITEM = new BoardingStairsItem(new Item.Properties().func_200916_a(TAB));
    }
}

