/*
 * Decompiled with CFR 0.152.
 */
package com.cobbs.rabbit_tamer.Util.Events;

import com.cobbs.rabbit_tamer.Util.DataStorage.Rabbit.EPosition;
import com.cobbs.rabbit_tamer.Util.DataStorage.Rabbit.IRabbitCapability;
import com.cobbs.rabbit_tamer.Util.DataStorage.Rabbit.RabbitCapabilityProvider;
import com.cobbs.rabbit_tamer.Util.ModHelper;
import com.cobbs.rabbit_tamer.Util.RabbitFollowGoal;
import com.cobbs.rabbit_tamer.Util.RabbitNoRunAway;
import com.cobbs.rabbit_tamer.Util.RabbitSittingGoal;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ModEvents {
    public static final ResourceLocation res = new ResourceLocation("rabbit_tamer", "tame_data");

    @SubscribeEvent
    public void attachCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        World world = ((Entity)event.getObject()).field_70170_p;
        if (ModHelper.isServer(world) && event.getObject() instanceof EntityRabbit) {
            event.addCapability(res, (ICapabilityProvider)new RabbitCapabilityProvider((EntityRabbit)event.getObject()));
        }
    }

    @SubscribeEvent
    public void rabbitAddedToWorld(EntityJoinWorldEvent event) {
        EntityRabbit rabbit;
        IRabbitCapability data;
        World world = event.getEntity().field_70170_p;
        if (ModHelper.isServer(world) && event.getEntity() instanceof EntityRabbit && !(data = ModHelper.getData((EntityLivingBase)(rabbit = (EntityRabbit)event.getEntity()))).isOwner("")) {
            ModEvents.removeRunAway(rabbit);
            ModEvents.applyGoals(rabbit);
        }
    }

    @SubscribeEvent
    public void entityHurt(LivingHurtEvent event) {
        EntityRabbit rabbit;
        IRabbitCapability data;
        World world = event.getEntity().field_70170_p;
        if (ModHelper.isServer(world) && event.getEntity() instanceof EntityRabbit && !(data = ModHelper.getData((EntityLivingBase)(rabbit = (EntityRabbit)event.getEntity()))).isOwner("") && !event.getSource().field_76373_n.equalsIgnoreCase("outOfWorld")) {
            Entity e = data.getOwner((WorldServer)world);
            if (e instanceof EntityPlayer) {
                if (event.getSource().func_76346_g() != e || ModHelper.isRidingOrBeingRiddenBy(e, (Entity)rabbit)) {
                    event.setAmount(0.0f);
                    event.setCanceled(true);
                }
            } else {
                event.setAmount(0.0f);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void rabbitBaby(BabyEntitySpawnEvent event) {
        World world;
        EntityPlayer player = event.getCausedByPlayer();
        if (player != null && ModHelper.isServer(world = player.field_70170_p) && event.getChild() instanceof EntityRabbit) {
            IRabbitCapability data;
            String ownerID = "";
            if (event.getParentA() instanceof EntityRabbit) {
                data = ModHelper.getData((EntityLivingBase)event.getParentA());
                ownerID = data.getOwnerID();
            }
            if (ownerID.equals("")) {
                data = ModHelper.getData((EntityLivingBase)event.getParentB());
                ownerID = data.getOwnerID();
            }
            if (!ownerID.equals("")) {
                data = ModHelper.getData((EntityLivingBase)event.getChild());
                data.setOwner(player);
            }
        }
    }

    @SubscribeEvent
    public void interactWithRabbit(PlayerInteractEvent.EntityInteract event) {
        World world = event.getEntity().field_70170_p;
        if (event.getHand() == EnumHand.MAIN_HAND && ModHelper.isServer(world) && event.getTarget() instanceof EntityRabbit) {
            EntityPlayer p = event.getEntityPlayer();
            EntityRabbit rabbit = (EntityRabbit)event.getTarget();
            IRabbitCapability data = ModHelper.getData((EntityLivingBase)rabbit);
            ItemStack stack = p.func_184586_b(EnumHand.MAIN_HAND);
            if (data.isOwner("")) {
                if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151015_O) {
                    ModHelper.actionBarMessage(p, rabbit.func_145748_c_().func_150254_d() + " is now tamed!");
                    stack.func_190918_g(1);
                    data.setOwner(p);
                    ModEvents.removeRunAway(rabbit);
                    ModEvents.applyGoals(rabbit);
                } else if (!ModHelper.isBreedingItem(stack)) {
                    ModHelper.actionBarMessage(p, "Tamable with " + new ItemStack(Items.field_151015_O).func_82833_r());
                }
            } else if (data.isOwner(p) && !ModHelper.isBreedingItem(stack)) {
                data.setState(ModEvents.nextState(data.getState(), p, rabbit));
            }
        }
    }

    public static void removeRunAway(EntityRabbit rabbit) {
        try {
            Set goals = (Set)ObfuscationReflectionHelper.getPrivateValue(EntityAITasks.class, (Object)rabbit.field_70714_bg, (String)"field_75782_a");
            goals.removeIf(g -> g.field_75733_a instanceof EntityAIAvoidEntity || g.field_75733_a instanceof EntityAIPanic);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static EPosition nextState(EPosition current, EntityPlayer p, EntityRabbit rabbit) {
        switch (current) {
            case STOPPED: {
                ModHelper.actionBarMessage(p, rabbit.func_145748_c_().func_150254_d() + " is now wandering!");
                return EPosition.WANDERING;
            }
            case FOLLOWING: {
                ModHelper.actionBarMessage(p, rabbit.func_145748_c_().func_150254_d() + " is now stopped!");
                return EPosition.STOPPED;
            }
            case WANDERING: {
                ModHelper.actionBarMessage(p, rabbit.func_145748_c_().func_150254_d() + " is now following!");
                return EPosition.FOLLOWING;
            }
        }
        return EPosition.STOPPED;
    }

    public static void applyGoals(EntityRabbit rabbit) {
        rabbit.field_70714_bg.func_75776_a(1, (EntityAIBase)new RabbitSittingGoal(rabbit));
        rabbit.field_70714_bg.func_75776_a(2, (EntityAIBase)new RabbitFollowGoal(rabbit, 2.0, 10.0f, 2.0f, false));
        rabbit.field_70714_bg.func_75776_a(3, (EntityAIBase)new RabbitNoRunAway(rabbit, 2.0));
    }
}

