/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks;

import com.cannolicatfish.rankine.blocks.CharredWoodBlock;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineItems;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CharcoalPitBlock
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    int TICKS = 1;
    int MAX_HEIGHT;
    int RADIUS;

    public CharcoalPitBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.MAX_HEIGHT = (Integer)Config.MACHINES.CHARCOAL_PIT_HEIGHT.get();
        this.RADIUS = (Integer)Config.MACHINES.CHARCOAL_PIT_RADIUS.get();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151033_d || item == RankineItems.SPARK_LIGHTER.get()) {
            itemstack.func_222118_a(1, (LivingEntity)player, p_220287_1_ -> p_220287_1_.func_213334_d(handIn));
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(0, -this.MAX_HEIGHT, 0), (BlockPos)pos.func_177982_a(0, this.MAX_HEIGHT, 0))) {
                if (worldIn.func_180495_p(blockpos).func_177230_c() != RankineBlocks.CHARCOAL_PIT.get()) continue;
                worldIn.func_180501_a(blockpos, (BlockState)worldIn.func_180495_p(blockpos).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 2);
            }
            return ActionResultType.SUCCESS;
        }
        if (item == Items.field_151059_bz) {
            itemstack.func_190918_g(1);
            for (BlockPos blockpos : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(0, -this.MAX_HEIGHT, 0), (BlockPos)pos.func_177982_a(0, this.MAX_HEIGHT, 0))) {
                if (worldIn.func_180495_p(blockpos).func_177230_c() != RankineBlocks.CHARCOAL_PIT.get()) continue;
                worldIn.func_180501_a(blockpos, (BlockState)((Block)RankineBlocks.CHARCOAL_PIT.get()).func_176223_P().func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 2);
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    public boolean func_149653_t(BlockState stateIn) {
        return (Boolean)stateIn.func_177229_b((Property)LIT);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }

    private boolean connected(World worldIn, BlockPos pos, List<BlockPos> logs) {
        List<BlockPos> Sides = Arrays.asList(pos.func_177977_b(), pos.func_177978_c(), pos.func_177974_f(), pos.func_177976_e(), pos.func_177968_d(), pos.func_177984_a());
        for (BlockPos Side : Sides) {
            if (!logs.contains(Side) || logs.contains(pos) || !worldIn.func_180495_p(pos).func_177230_c().getTags().contains(new ResourceLocation("minecraft:logs_that_burn"))) continue;
            return true;
        }
        return false;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        int HEIGHT = this.heightCheck(worldIn, pos);
        ArrayList<BlockPos> Connected = new ArrayList<BlockPos>();
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            if (worldIn.func_180495_p(pos.func_177977_b()) == this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(true))) {
                return;
            }
            if (this.TICKS % (Integer)Config.MACHINES.CHARCOAL_PIT_SPEED.get() == 0) {
                for (int y = 0; y <= HEIGHT; ++y) {
                    Connected.add(pos.func_177981_b(y));
                    if (worldIn.func_180495_p(pos.func_177981_b(y).func_177978_c()).func_177230_c().getTags().contains(new ResourceLocation("minecraft:logs_that_burn"))) {
                        Connected.add(pos.func_177981_b(y).func_177978_c());
                    }
                    if (worldIn.func_180495_p(pos.func_177981_b(y).func_177974_f()).func_177230_c().getTags().contains(new ResourceLocation("minecraft:logs_that_burn"))) {
                        Connected.add(pos.func_177981_b(y).func_177974_f());
                    }
                    if (worldIn.func_180495_p(pos.func_177981_b(y).func_177968_d()).func_177230_c().getTags().contains(new ResourceLocation("minecraft:logs_that_burn"))) {
                        Connected.add(pos.func_177981_b(y).func_177968_d());
                    }
                    if (!worldIn.func_180495_p(pos.func_177981_b(y).func_177976_e()).func_177230_c().getTags().contains(new ResourceLocation("minecraft:logs_that_burn"))) continue;
                    Connected.add(pos.func_177981_b(y).func_177976_e());
                }
                for (int R = 1; R <= 3; ++R) {
                    for (int y = 0; y <= HEIGHT; ++y) {
                        for (BlockPos B : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-R, y, -R), (BlockPos)pos.func_177982_a(R, y, R))) {
                            if (!this.connected((World)worldIn, B, Connected)) continue;
                            Connected.add(B.func_185334_h());
                        }
                    }
                }
                for (BlockPos blockpos : Connected) {
                    String path = worldIn.func_180495_p(blockpos).func_177230_c().getRegistryName().func_110623_a();
                    List<BlockPos> Sides = Arrays.asList(blockpos.func_177977_b(), blockpos.func_177978_c(), blockpos.func_177974_f(), blockpos.func_177976_e(), blockpos.func_177968_d(), blockpos.func_177984_a());
                    boolean valid = true;
                    for (BlockPos Side : Sides) {
                        if (worldIn.func_180495_p(Side).func_200015_d((IBlockReader)worldIn, Side)) continue;
                        valid = false;
                        break;
                    }
                    if (!valid) continue;
                    int quality = path.contains("douglas_fir") ? 460 : (path.contains("ancient") ? 400 : (path.contains("archwood") ? 400 : (path.contains("dead") ? 300 : (path.contains("pinyon_pine") ? 520 : (path.contains("redwood") ? 440 : (path.contains("alder") ? 420 : (path.contains("apple") ? 520 : (path.contains("ash") ? 470 : (path.contains("aspen") ? 430 : (path.contains("basswood") ? 390 : (path.contains("beech") ? 530 : (path.contains("elder") ? 430 : (path.contains("cherry") ? 450 : (path.contains("chestnut") ? 430 : (path.contains("black_birch") ? 470 : (path.contains("yellow_birch") ? 490 : (path.contains("birch") ? 450 : (path.contains("dogwood") ? 600 : (path.contains("elm") ? 450 : (path.contains("cottonwood") ? 410 : (path.contains("fir") ? 390 : (path.contains("silver_maple") ? 440 : (path.contains("mulberry") ? 510 : (path.contains("poplar") ? 350 : (path.contains("maple") ? 500 : (path.contains("cedar") ? 410 : (path.contains("white_pine") ? 410 : (path.contains("spruce") ? 410 : (path.contains("white_oak") ? 540 : (path.contains("red_oak") ? 500 : (path.contains("oak") ? 520 : (path.contains("jungle") ? 450 : (path.contains("walnut") ? 470 : (path.contains("pine") ? 420 : (path.contains("willow") ? 420 : (path.contains("sycamore") ? 440 : (path.contains("hickory") ? 530 : (path.contains("coconut") ? 450 : (path.contains("juniper") ? 480 : (path.contains("acacia") ? 500 : (path.contains("magnolia") ? 450 : (path.contains("hemlock") ? 440 : (path.contains("larch") ? 440 : (path.contains("robinia") ? 550 : (path.contains("eucalyptus") ? 570 : (path.contains("ironwood") ? 510 : (path.contains("locust") ? 550 : 300)))))))))))))))))))))))))))))))))))))))))))))));
                    int count = new Random().nextFloat() < (float)(quality % 100) / 250.0f ? (int)Math.floor((float)quality / 100.0f) - 3 + 1 : (int)Math.floor((float)quality / 100.0f) - 3;
                    if (count > 3) {
                        count = 3;
                    } else if (count < 0) {
                        count = 0;
                    }
                    worldIn.func_175656_a(blockpos, (BlockState)((Block)RankineBlocks.CHARRED_WOOD.get()).func_176223_P().func_206870_a((Property)CharredWoodBlock.TYPE, (Comparable)Integer.valueOf(count)));
                }
            }
            ++this.TICKS;
        }
    }

    private int heightCheck(ServerWorld worldIn, BlockPos pos) {
        int HEIGHT = 0;
        for (int i = 1; i <= (Integer)Config.MACHINES.CHARCOAL_PIT_HEIGHT.get() - 1 && worldIn.func_180495_p(pos.func_177981_b(i)) == this.func_176223_P(); ++i) {
            ++HEIGHT;
        }
        return HEIGHT;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if ((double)rand.nextFloat() < 0.7 && ((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            Random random = worldIn.func_201674_k();
            BasicParticleType basicparticletype = ParticleTypes.field_218417_ae;
            worldIn.func_217404_b((IParticleData)basicparticletype, true, (double)pos.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)pos.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        }
    }
}

