/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class RankineVerticalSlabBlock
extends Block {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.field_208145_at;
    public static final DirectionProperty HORIZONTAL_FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape NORTH_B = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_B = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape EAST_B = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_B = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_T = Block.func_208617_a((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NORTH_T = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST_T = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_T = Block.func_208617_a((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public RankineVerticalSlabBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(TYPE, (Comparable)SlabType.BOTTOM)).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH));
    }

    public boolean func_220074_n(BlockState state) {
        return state.func_177229_b(TYPE) != SlabType.DOUBLE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        SlabType slabtype = (SlabType)state.func_177229_b(TYPE);
        Direction facing = (Direction)state.func_177229_b((Property)HORIZONTAL_FACING);
        switch (slabtype) {
            case DOUBLE: {
                return VoxelShapes.func_197868_b();
            }
            case TOP: {
                switch (facing) {
                    case NORTH: {
                        return NORTH_T;
                    }
                    case SOUTH: {
                        return SOUTH_T;
                    }
                    case WEST: {
                        return WEST_T;
                    }
                    case EAST: {
                        return EAST_T;
                    }
                }
            }
        }
        switch (facing) {
            case SOUTH: {
                return SOUTH_B;
            }
            case WEST: {
                return WEST_B;
            }
            case EAST: {
                return EAST_B;
            }
        }
        return NORTH_B;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos blockpos = context.func_195995_a();
        BlockState blockstate = context.func_195991_k().func_180495_p(blockpos);
        BlockState blockstate1 = this.func_176223_P();
        if (blockstate.func_203425_a((Block)this)) {
            return (BlockState)((BlockState)blockstate.func_206870_a(TYPE, (Comparable)SlabType.DOUBLE)).func_206870_a((Property)HORIZONTAL_FACING, (Comparable)Direction.NORTH);
        }
        blockstate1 = (BlockState)((BlockState)blockstate1.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a(TYPE, (Comparable)SlabType.BOTTOM);
        return blockstate1;
    }

    public boolean func_196253_a(BlockState state, BlockItemUseContext useContext) {
        ItemStack itemstack = useContext.func_195996_i();
        SlabType slabtype = (SlabType)state.func_177229_b(TYPE);
        if (slabtype != SlabType.DOUBLE && itemstack.func_77973_b() == this.func_199767_j()) {
            if (useContext.func_196012_c()) {
                return useContext.func_196000_l() == state.func_177229_b((Property)HORIZONTAL_FACING);
            }
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == stateIn.func_177229_b((Property)HORIZONTAL_FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)HORIZONTAL_FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)HORIZONTAL_FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{TYPE, HORIZONTAL_FACING});
    }
}

