/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks;

import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.init.RankineBlocks;
import java.util.HashSet;
import java.util.Stack;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class TrampolineBlock
extends Block {
    public TrampolineBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        if (entityIn.func_226272_bl_()) {
            super.func_180658_a(worldIn, pos, entityIn, fallDistance);
        } else {
            entityIn.func_225503_b_(fallDistance, 0.0f);
        }
    }

    public void func_176216_a(IBlockReader worldIn, Entity entityIn) {
        if (entityIn.func_226272_bl_()) {
            super.func_176216_a(worldIn, entityIn);
        } else {
            this.bounceEntity(entityIn, worldIn);
        }
    }

    private void bounceEntity(Entity entity, IBlockReader worldIn) {
        Vector3d vector3d = entity.func_213322_ci();
        if (vector3d.field_72448_b < 0.0) {
            double size = this.trampolineSize(entity, worldIn);
            entity.func_213293_j(vector3d.field_72450_a, -vector3d.field_72448_b * size, vector3d.field_72449_c);
        }
    }

    private double trampolineSize(Entity entity, IBlockReader worldIn) {
        if (entity instanceof LivingEntity) {
            if ((Integer)Config.GENERAL.TRAMPOLINE_SIZE.get() == 0) {
                return 1.3;
            }
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            toCheck.add(entity.func_233580_cy_());
            while (!toCheck.isEmpty()) {
                BlockPos cp = (BlockPos)toCheck.pop();
                if (checkedBlocks.contains(cp)) continue;
                checkedBlocks.add(cp);
                if (worldIn.func_180495_p(cp.func_177978_c()).func_177230_c().func_235332_a_((Block)RankineBlocks.TRAMPOLINE.get())) {
                    toCheck.add(cp.func_177978_c());
                }
                if (worldIn.func_180495_p(cp.func_177974_f()).func_177230_c().func_235332_a_((Block)RankineBlocks.TRAMPOLINE.get())) {
                    toCheck.add(cp.func_177974_f());
                }
                if (worldIn.func_180495_p(cp.func_177968_d()).func_177230_c().func_235332_a_((Block)RankineBlocks.TRAMPOLINE.get())) {
                    toCheck.add(cp.func_177968_d());
                }
                if (worldIn.func_180495_p(cp.func_177976_e()).func_177230_c().func_235332_a_((Block)RankineBlocks.TRAMPOLINE.get())) {
                    toCheck.add(cp.func_177976_e());
                }
                if (checkedBlocks.size() < (Integer)Config.GENERAL.TRAMPOLINE_SIZE.get()) continue;
                break;
            }
            return Math.min(Math.exp((double)checkedBlocks.size() / (double)((Integer)Config.GENERAL.TRAMPOLINE_SIZE.get()).intValue()), 2.0);
        }
        return 0.8;
    }
}

