/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.alloyfurnace;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.init.RankineRecipes;
import com.cannolicatfish.rankine.items.AlloyTemplateItem;
import com.cannolicatfish.rankine.items.alloys.AlloyItem;
import com.cannolicatfish.rankine.recipe.AlloyingRecipe;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import java.util.AbstractMap;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class AlloyFurnaceContainer
extends Container {
    private final IInventory furnaceInventory;
    private TileEntity tileEntity;
    private PlayerEntity playerEntity;
    private IItemHandler playerInventory;
    private final IIntArray data;

    public AlloyFurnaceContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        this(windowId, world, pos, playerInventory, player, (IInventory)new Inventory(9), (IIntArray)new IntArray(5));
    }

    public AlloyFurnaceContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, IInventory furnaceInventoryIn, IIntArray furnaceData) {
        super(RankineBlocks.ALLOY_FURNACE_CONTAINER, windowId);
        this.tileEntity = world.func_175625_s(pos);
        AlloyFurnaceContainer.func_216962_a((IInventory)furnaceInventoryIn, (int)9);
        AlloyFurnaceContainer.func_216959_a((IIntArray)furnaceData, (int)5);
        this.playerEntity = player;
        this.furnaceInventory = furnaceInventoryIn;
        this.data = furnaceData;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.func_75146_a(new Slot(this.furnaceInventory, 0, 33, 23));
        this.func_75146_a(new Slot(this.furnaceInventory, 1, 33, 41));
        this.func_75146_a(new Slot(this.furnaceInventory, 2, 51, 23));
        this.func_75146_a(new Slot(this.furnaceInventory, 3, 51, 41));
        this.func_75146_a(new Slot(this.furnaceInventory, 4, 69, 23));
        this.func_75146_a(new Slot(this.furnaceInventory, 5, 69, 41));
        this.func_75146_a(new Slot(this.furnaceInventory, 6, 10, 37));
        this.func_75146_a(new Slot(this.furnaceInventory, 7, 134, 7));
        this.func_75146_a(new Slot(this.furnaceInventory, 8, 134, 31));
        this.layoutPlayerInventorySlots(8, 86);
        this.func_216961_a(furnaceData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public AbstractMap.SimpleEntry<String[], Integer> getOutputString() {
        if (this.furnaceInventory.func_70301_a(7).func_77973_b() instanceof AlloyTemplateItem) {
            ItemStack template = this.furnaceInventory.func_70301_a(7);
            boolean correctInputs = true;
            if ((AlloyTemplateItem.getTier(template) & 1) != 1) {
                correctInputs = false;
            }
            if (correctInputs) {
                for (ItemStack input : AlloyTemplateItem.getInputStacks(template)) {
                    Item tempItem = input.func_77973_b();
                    int count = input.func_190916_E();
                    if (this.furnaceInventory.func_213901_a(tempItem) >= count) continue;
                    correctInputs = false;
                }
            }
            return new AbstractMap.SimpleEntry<String[], Integer>(new String[]{"Template: " + new TranslationTextComponent(AlloyTemplateItem.getResult(template).func_77973_b().func_77658_a()).getString(), AlloyTemplateItem.getOutputAlloyData(template)}, correctInputs ? 0x55FF55 : 0xFF5555);
        }
        AlloyingRecipe recipe = this.playerEntity.func_130014_f_().func_199532_z().func_215371_a(RankineRecipeTypes.ALLOYING, this.furnaceInventory, this.playerEntity.func_130014_f_()).orElse(null);
        if (recipe != null) {
            ItemStack stack = recipe.generateResult(this.furnaceInventory, 1);
            INBT nbt = AlloyItem.getComposition(stack).func_150305_b(0).func_74781_a("comp");
            if (nbt != null) {
                return new AbstractMap.SimpleEntry<String[], Integer>(new String[]{new TranslationTextComponent(stack.func_77973_b().func_77658_a()).getString(), nbt.func_150285_a_()}, 0x55FF55);
            }
            return new AbstractMap.SimpleEntry<String[], Integer>(new String[0], 0xFFFFFF);
        }
        String ret = RankineRecipes.generateAlloyString(this.furnaceInventory);
        return new AbstractMap.SimpleEntry<String[], Integer>(new String[]{"None", ret}, 0xFF5555);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnTime() {
        return this.data.func_221476_a(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCurrentBurnTime() {
        return this.data.func_221476_a(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookTime() {
        return this.data.func_221476_a(2);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTotalCookTime() {
        return this.data.func_221476_a(3);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return AlloyFurnaceContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)((Block)RankineBlocks.ALLOY_FURNACE.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index == 8) {
                if (!this.func_75135_a(stack, 9, 45, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (index > 8 ? (PeriodicTableUtils.getInstance().hasElement(stack.func_77973_b()) ? !this.func_75135_a(stack, 0, 6, false) : (AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack) ? !this.func_75135_a(stack, 6, 7, false) : (stack.func_77973_b() == RankineItems.ALLOY_TEMPLATE.get() ? !this.func_75135_a(stack, 7, 8, false) : (index < 36 ? !this.func_75135_a(stack, 36, 45, false) : index < 45 && !this.func_75135_a(stack, 9, 36, false))))) : !this.func_75135_a(stack, 9, 45, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnLeftScaled(int pixels) {
        int i = this.getCurrentBurnTime();
        if (i == 0) {
            i = 200;
        }
        return this.getBurnTime() * pixels / i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressScaled(int pixels) {
        int i = this.getCookTime();
        int j = this.getTotalCookTime();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBurning() {
        return this.getBurnTime() > 0;
    }
}

