/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.beehiveoven;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.BeehiveOvenRecipe;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BeehiveOvenPitBlock
extends Block {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private final Block blockType;
    int height;

    public BeehiveOvenPitBlock(Block blockType, AbstractBlock.Properties properties) {
        super(properties);
        this.blockType = blockType;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149653_t(BlockState stateIn) {
        return (Boolean)stateIn.func_177229_b((Property)LIT);
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208190_q) != false ? super.getLightValue(state, world, pos) : 0;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{LIT});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        ItemStack itemstack = player.func_184586_b(handIn);
        Item item = itemstack.func_77973_b();
        if (item == Items.field_151033_d || item == RankineItems.SPARK_LIGHTER.get()) {
            itemstack.func_222118_a(1, (LivingEntity)player, p_220287_1_ -> p_220287_1_.func_213334_d(handIn));
            this.getBeehiveOven(worldIn, pos);
        } else if (item == Items.field_151059_bz) {
            itemstack.func_190918_g(1);
            this.getBeehiveOven(worldIn, pos);
        } else if (player.func_184614_ca().func_77973_b() == Items.field_151065_br && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            boolean flag = true;
            for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 1, -1), (BlockPos)pos.func_177982_a(1, 2, 1))) {
                ItemStack output;
                BeehiveOvenRecipe recipe = worldIn.func_199532_z().func_215371_a(RankineRecipeTypes.BEEHIVE, (IInventory)new Inventory(new ItemStack[]{new ItemStack((IItemProvider)worldIn.func_180495_p(p).func_177230_c())}), worldIn).orElse(null);
                if (recipe == null || (output = recipe.func_77571_b()).func_190926_b() || !(output.func_77973_b() instanceof BlockItem)) continue;
                worldIn.func_180501_a(p, ((BlockItem)output.func_77973_b()).func_179223_d().func_176223_P(), 2);
                flag = false;
                break;
            }
            if (flag) {
                worldIn.func_180501_a(pos, (BlockState)worldIn.func_180495_p(pos).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.FALSE), 2);
            }
            if (!player.func_184812_l_()) {
                player.func_184614_ca().func_190918_g(1);
            }
            worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187616_bj, SoundCategory.BLOCKS, 0.5f, 1.3f, false);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        ServerWorld world = worldIn.func_201672_e();
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        this.getBeehiveOven((World)world, pos);
        if (((Boolean)state.func_177229_b((Property)LIT)).booleanValue()) {
            this.height = 2;
            float chance = this.structureCheck((World)worldIn, pos);
            if (rand.nextFloat() <= chance) {
                boolean flag = true;
                for (BlockPos p : BlockPos.func_218278_a((BlockPos)pos.func_177982_a(-1, 1, -1), (BlockPos)pos.func_177982_a(1, this.height, 1))) {
                    ItemStack output;
                    BeehiveOvenRecipe recipe = worldIn.func_199532_z().func_215371_a(RankineRecipeTypes.BEEHIVE, (IInventory)new Inventory(new ItemStack[]{new ItemStack((IItemProvider)world.func_180495_p(p).func_177230_c())}), (World)worldIn).orElse(null);
                    if (recipe == null || (output = recipe.func_77571_b()).func_190926_b() || !(output.func_77973_b() instanceof BlockItem)) continue;
                    world.func_180501_a(p, ((BlockItem)output.func_77973_b()).func_179223_d().func_176223_P(), 2);
                    flag = false;
                    if (!((double)chance > 1.0)) break;
                    chance = (float)((double)chance - 1.0);
                    if (!(rand.nextFloat() < chance)) continue;
                    break;
                }
                if (flag) {
                    world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.FALSE), 3);
                }
            }
        }
    }

    private float structureCheck(World world, BlockPos pos) {
        List<BlockPos> oven = Arrays.asList(pos.func_177982_a(-1, 0, -1), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(-1, 0, 1), pos.func_177982_a(1, 0, -1), pos.func_177982_a(1, 0, 0), pos.func_177982_a(1, 0, 1), pos.func_177982_a(0, 0, -1), pos.func_177982_a(0, 0, 1), pos.func_177982_a(-2, 0, -1), pos.func_177982_a(-2, 0, 0), pos.func_177982_a(-2, 0, 1), pos.func_177982_a(2, 0, -1), pos.func_177982_a(2, 0, 0), pos.func_177982_a(2, 0, 1), pos.func_177982_a(-1, 0, -2), pos.func_177982_a(0, 0, -2), pos.func_177982_a(1, 0, -2), pos.func_177982_a(-1, 0, 2), pos.func_177982_a(0, 0, 2), pos.func_177982_a(1, 0, 2), pos.func_177982_a(-2, 1, -1), pos.func_177982_a(-2, 1, 1), pos.func_177982_a(2, 1, -1), pos.func_177982_a(2, 1, 1), pos.func_177982_a(-1, 1, -2), pos.func_177982_a(1, 1, -2), pos.func_177982_a(-1, 1, 2), pos.func_177982_a(1, 1, 2), pos.func_177982_a(-2, 2, -1), pos.func_177982_a(-2, 2, 1), pos.func_177982_a(2, 2, -1), pos.func_177982_a(2, 2, 1), pos.func_177982_a(-1, 2, -2), pos.func_177982_a(1, 2, -2), pos.func_177982_a(-1, 2, 2), pos.func_177982_a(1, 2, 2), pos.func_177982_a(-1, 3, -1), pos.func_177982_a(-2, 3, 0), pos.func_177982_a(-1, 3, 1), pos.func_177982_a(1, 3, -1), pos.func_177982_a(2, 3, 0), pos.func_177982_a(1, 3, 1), pos.func_177982_a(0, 3, -2), pos.func_177982_a(0, 3, 2), pos.func_177982_a(0, 3, -1), pos.func_177982_a(0, 3, 1), pos.func_177982_a(-1, 3, 0), pos.func_177982_a(1, 3, 0));
        int count = 1;
        for (BlockPos b : oven) {
            if (world.func_180495_p(b) == ((Block)RankineBlocks.REFRACTORY_BRICKS.get()).func_176223_P()) {
                ++count;
                continue;
            }
            if (this.blockType != RankineBlocks.REFRACTORY_BRICKS.get() && world.func_180495_p(b) == ((Block)RankineBlocks.HIGH_REFRACTORY_BRICKS.get()).func_176223_P()) {
                count += 2;
                continue;
            }
            if (this.blockType != RankineBlocks.ULTRA_HIGH_REFRACTORY_BRICKS.get() || world.func_180495_p(b) != ((Block)RankineBlocks.ULTRA_HIGH_REFRACTORY_BRICKS.get()).func_176223_P()) continue;
            count += 4;
        }
        return (float)count / 97.0f;
    }

    private void getBeehiveOven(World world, BlockPos pos) {
        boolean canSeeSky = true;
        for (int i = 1; i <= 8; ++i) {
            if (world.func_175623_d(pos.func_177981_b(i))) continue;
            canSeeSky = false;
        }
        if (canSeeSky && world.func_180495_p(pos.func_177978_c()).func_177230_c() == this.blockType && world.func_180495_p(pos.func_177968_d()).func_177230_c() == this.blockType && world.func_180495_p(pos.func_177974_f()).func_177230_c() == this.blockType && world.func_180495_p(pos.func_177976_e()).func_177230_c() == this.blockType && world.func_180495_p(pos.func_177978_c().func_177976_e()).func_177230_c() == this.blockType && world.func_180495_p(pos.func_177978_c().func_177974_f()).func_177230_c() == this.blockType && world.func_180495_p(pos.func_177968_d().func_177976_e()).func_177230_c() == this.blockType && world.func_180495_p(pos.func_177968_d().func_177974_f()).func_177230_c() == this.blockType) {
            world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.TRUE), 2);
        } else {
            world.func_180501_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.FALSE), 2);
        }
    }

    public static void spawnSmokeParticles(World worldIn, BlockPos pos, boolean spawnExtraSmoke) {
        Random random = worldIn.func_201674_k();
        BasicParticleType basicparticletype = ParticleTypes.field_218417_ae;
        worldIn.func_217404_b((IParticleData)basicparticletype, true, (double)pos.func_177958_n() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + random.nextDouble() + random.nextDouble(), (double)pos.func_177952_p() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.07, 0.0);
        if (spawnExtraSmoke) {
            worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, (double)pos.func_177958_n() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), (double)pos.func_177956_o() + 0.4, (double)pos.func_177952_p() + 0.25 + random.nextDouble() / 2.0 * (double)(random.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)LIT)).booleanValue()) {
            BeehiveOvenPitBlock.spawnSmokeParticles(worldIn, pos, true);
            if (rand.nextInt(10) == 0) {
                worldIn.func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_219605_aC, SoundCategory.BLOCKS, 0.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.6f, false);
            }
            if (rand.nextInt(5) == 0) {
                for (int i = 0; i < rand.nextInt(1) + 1; ++i) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), (double)(rand.nextFloat() / 2.0f), 5.0E-5, (double)(rand.nextFloat() / 2.0f));
                }
            }
        }
    }
}

