/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.crucible;

import com.cannolicatfish.rankine.blocks.crucible.CrucibleTile;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class CrucibleBlock
extends Block {
    public static final BooleanProperty FLUID = BooleanProperty.func_177716_a((String)"fluid");
    private static final VoxelShape INSIDE = CrucibleBlock.func_208617_a((double)2.0, (double)4.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    protected static final VoxelShape SHAPE = VoxelShapes.func_197878_a((VoxelShape)VoxelShapes.func_197868_b(), (VoxelShape)VoxelShapes.func_216384_a((VoxelShape)CrucibleBlock.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0), (VoxelShape[])new VoxelShape[]{CrucibleBlock.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0), CrucibleBlock.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)3.0, (double)14.0), INSIDE}), (IBooleanFunction)IBooleanFunction.field_223234_e_);

    public CrucibleBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)FLUID, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightValue(BlockState state, IBlockReader world, BlockPos pos) {
        return (Boolean)state.func_177229_b((Property)FLUID) != false ? super.getLightValue(state, world, pos) : 0;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_199600_g(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return INSIDE;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        float f = (float)pos.func_177956_o() + 0.9375f;
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((Property)FLUID)).booleanValue() && entityIn.func_226278_cu_() <= (double)f) {
            entityIn.func_70015_d(2);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CrucibleTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K) {
            TileEntity tileEntity = worldIn.func_175625_s(pos);
            if (!(tileEntity instanceof INamedContainerProvider)) {
                throw new IllegalStateException("Our named container provider is missing!");
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)tileEntity), (BlockPos)tileEntity.func_174877_v());
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((Property)FLUID)).booleanValue()) {
            double d4;
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + 0.3;
            double d2 = (double)pos.func_177952_p() + 0.5;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a(d0, d1, d2, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction.Axis direction$axis = Direction.Axis.Y;
            double d3 = 0.52;
            double d5 = d4 = rand.nextDouble() * 0.6 - 0.3;
            double d6 = rand.nextDouble() * 6.0 / 16.0;
            double d7 = rand.nextDouble() * 0.6 - 0.3;
            double d8 = d4;
            if (rand.nextDouble() < 0.4 && (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150480_ab || worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150353_l)) {
                worldIn.func_195594_a((IParticleData)ParticleTypes.field_197595_F, d0, d1, d2, 0.0, 0.0, 0.0);
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.func_203425_a(newState.func_177230_c())) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof CrucibleTile) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((CrucibleTile)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FLUID});
    }

    public boolean func_196266_a(BlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

