/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.crucible;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.CrucibleRecipe;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class CrucibleContainer
extends Container {
    private final IInventory furnaceInventory;
    private TileEntity tileEntity;
    private PlayerEntity playerEntity;
    private IItemHandler playerInventory;
    private World world;
    private final IIntArray data;

    public CrucibleContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        this(windowId, world, pos, playerInventory, player, (IInventory)new Inventory(6), (IIntArray)new IntArray(3));
    }

    public CrucibleContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, IInventory furnaceInventoryIn, IIntArray furnaceData) {
        super(RankineBlocks.CRUCIBLE_CONTAINER, windowId);
        this.tileEntity = world.func_175625_s(pos);
        CrucibleContainer.func_216962_a((IInventory)furnaceInventoryIn, (int)6);
        CrucibleContainer.func_216959_a((IIntArray)furnaceData, (int)3);
        this.playerEntity = player;
        this.data = furnaceData;
        this.furnaceInventory = furnaceInventoryIn;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.world = this.playerEntity.field_70170_p;
        this.func_75146_a(new Slot(this.furnaceInventory, 0, 53, 23));
        this.func_75146_a(new Slot(this.furnaceInventory, 1, 71, 16));
        this.func_75146_a(new Slot(this.furnaceInventory, 2, 88, 16));
        this.func_75146_a(new Slot(this.furnaceInventory, 3, 106, 23));
        this.func_75146_a(new Slot(this.furnaceInventory, 4, 79, 53));
        this.func_75146_a(new Slot(this.furnaceInventory, 5, 49, 53));
        this.layoutPlayerInventorySlots(8, 84);
        this.func_216961_a(furnaceData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookTime() {
        return this.data.func_221476_a(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTotalCookTime() {
        return this.data.func_221476_a(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getHeatStatus() {
        return this.data.func_221476_a(2);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return CrucibleContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)((Block)RankineBlocks.CRUCIBLE_BLOCK.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index == 4 || index == 5) {
                if (!this.func_75135_a(stack, 6, 42, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (index > 5 ? (this.hasRecipe(stack) ? !this.func_75135_a(stack, 0, 4, false) : (index < 33 ? !this.func_75135_a(stack, 33, 42, false) : index < 42 && !this.func_75135_a(stack, 6, 33, false))) : !this.func_75135_a(stack, 6, 42, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return itemstack;
    }

    protected boolean hasRecipe(ItemStack stack) {
        for (CrucibleRecipe recipe : this.world.func_199532_z().func_241447_a_(RankineRecipeTypes.CRUCIBLE)) {
            for (Ingredient i : recipe.func_192400_c()) {
                if (!i.test(stack)) continue;
                return true;
            }
        }
        return false;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public int getOutputSlot() {
        return 4;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressScaled(int pixels) {
        int i = this.getCookTime();
        int j = this.getTotalCookTime();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }
}

