/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.crucible;

import com.cannolicatfish.rankine.blocks.crucible.CrucibleBlock;
import com.cannolicatfish.rankine.blocks.crucible.CrucibleContainer;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.CrucibleRecipe;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class CrucibleTile
extends TileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private static final int[] SLOTS_UP = new int[]{0, 1};
    private static final int[] SLOTS_DOWN = new int[]{4, 5};
    private static final int[] SLOTS_HORIZONTAL = new int[]{2, 3};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)6, (Object)ItemStack.field_190927_a);
    private int cookTime;
    private int cookTimeTotal;
    private int color = 0xFFFFFF;
    private int heatPower = 0;
    private final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return CrucibleTile.this.cookTime;
                }
                case 1: {
                    return CrucibleTile.this.cookTimeTotal;
                }
                case 2: {
                    return CrucibleTile.this.heatPower;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    CrucibleTile.this.cookTime = value;
                    break;
                }
                case 1: {
                    CrucibleTile.this.cookTimeTotal = value;
                    break;
                }
                case 2: {
                    CrucibleTile.this.heatPower = value;
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public CrucibleTile() {
        super(RankineBlocks.CRUCIBLE_TILE);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
        this.color = nbt.func_74762_e("color");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_74768_a("color", this.color);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return compound;
    }

    public void func_73660_a() {
        boolean flag = this.isHeated(this.field_174879_c, this.field_145850_b);
        boolean flag1 = this.isCooking();
        boolean flag2 = false;
        if (!this.field_145850_b.field_72995_K) {
            if (!flag1) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)CrucibleBlock.FLUID, (Comparable)Boolean.valueOf(false)), 3);
            } else if (this.getTileData().func_74762_e("color") != this.color) {
                this.getTileData().func_74768_a("color", this.color);
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)CrucibleBlock.FLUID, (Comparable)Boolean.valueOf(this.isCooking())), 3);
            }
            ItemStack[] inputs = new ItemStack[]{(ItemStack)this.items.get(0), (ItemStack)this.items.get(1), (ItemStack)this.items.get(2), (ItemStack)this.items.get(3)};
            if (this.isCooking() && flag || !((ItemStack)this.items.get(0)).func_190926_b() && !((ItemStack)this.items.get(1)).func_190926_b() && !((ItemStack)this.items.get(2)).func_190926_b() && !((ItemStack)this.items.get(3)).func_190926_b()) {
                CrucibleRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(RankineRecipeTypes.CRUCIBLE, (IInventory)this, this.field_145850_b).orElse(null);
                if (this.canSmelt(irecipe, (IInventory)this)) {
                    if (this.cookTime == 0) {
                        this.cookTimeTotal = this.getCookTime();
                        this.color = irecipe.getColor();
                    }
                    ++this.cookTime;
                    if (this.cookTime >= this.cookTimeTotal) {
                        ItemStack smelting = irecipe.generateResult((IInventory)this);
                        if (((ItemStack)this.items.get(4)).func_190916_E() > 0) {
                            ((ItemStack)this.items.get(4)).func_190917_f(smelting.func_190916_E());
                        } else {
                            this.items.set(4, (Object)smelting);
                        }
                        ItemStack extra = irecipe.getSecondaryOutput();
                        if (((ItemStack)this.items.get(5)).func_190916_E() > 0) {
                            ((ItemStack)this.items.get(5)).func_190917_f(extra.func_190916_E());
                        } else {
                            this.items.set(5, (Object)extra);
                        }
                        this.cookTime = 0;
                        inputs[0].func_190918_g(1);
                        inputs[1].func_190918_g(1);
                        inputs[2].func_190918_g(1);
                        inputs[3].func_190918_g(1);
                        return;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (flag && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (flag1 != this.isCooking()) {
                flag2 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)CrucibleBlock.FLUID, (Comparable)Boolean.valueOf(this.isCooking())), 3);
            }
        }
        if (flag2) {
            this.func_70296_d();
        }
    }

    public int getCookTime() {
        CrucibleRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(RankineRecipeTypes.CRUCIBLE, (IInventory)this, this.field_145850_b).orElse(null);
        if (irecipe != null) {
            return irecipe.getRecipeCookTime((IInventory)this);
        }
        return 3200;
    }

    private boolean isHeated(BlockPos pos, World worldIn) {
        List<BlockPos> positions = Arrays.asList(pos.func_177977_b(), pos.func_177974_f(), pos.func_177978_c(), pos.func_177976_e(), pos.func_177968_d());
        for (BlockPos p : positions) {
            if (worldIn.func_180495_p(p).func_177230_c() == Blocks.field_196814_hQ || worldIn.func_180495_p(p).func_177230_c() == Blocks.field_150353_l) {
                this.heatPower = 1;
                return true;
            }
            if (p != pos.func_177977_b() || worldIn.func_180495_p(p).func_177230_c() != Blocks.field_150480_ab) continue;
            this.heatPower = 1;
            return true;
        }
        this.heatPower = 0;
        return false;
    }

    public boolean isCooking() {
        return this.cookTime > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isCooking(CrucibleTile te) {
        return te.furnaceData.func_221476_a(0) > 0;
    }

    private boolean canSmelt(@Nullable CrucibleRecipe recipeIn, IInventory inv) {
        if (recipeIn == null) {
            return false;
        }
        ItemStack result = recipeIn.generateResult(inv);
        ItemStack sec = recipeIn.getSecondaryOutput();
        if (result.func_190926_b()) {
            return false;
        }
        ItemStack output = (ItemStack)this.items.get(4);
        ItemStack secondary = (ItemStack)this.items.get(5);
        if (output.func_190926_b() && (secondary.func_190926_b() || sec.func_190926_b())) {
            this.cookTimeTotal = recipeIn.getRecipeCookTime(inv);
            return true;
        }
        if (!output.func_77969_a(result) || !secondary.func_77969_a(sec)) {
            return false;
        }
        int res = output.func_190916_E() + result.func_190916_E();
        int res2 = secondary.func_190916_E() + sec.func_190916_E();
        if (ItemStack.func_77970_a((ItemStack)output, (ItemStack)result) && ItemStack.func_179545_c((ItemStack)output, (ItemStack)result) && ItemStack.func_77970_a((ItemStack)secondary, (ItemStack)sec) && ItemStack.func_179545_c((ItemStack)secondary, (ItemStack)sec)) {
            this.cookTimeTotal = recipeIn.getRecipeCookTime(inv);
            return res <= 64 && res2 <= 64 && res <= output.func_77976_d() && res2 <= secondary.func_77976_d();
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new CrucibleContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity, (IInventory)this, this.furnaceData);
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = this.getCookTime();
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void func_174888_l() {
        this.items.clear();
    }
}

