/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.evaporationtower;

import com.cannolicatfish.rankine.init.RankineBlocks;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class EvaporationTowerContainer
extends Container {
    private final IInventory furnaceInventory;
    private TileEntity tileEntity;
    private PlayerEntity playerEntity;
    private IItemHandler playerInventory;
    private final IIntArray data;

    public EvaporationTowerContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        this(windowId, world, pos, playerInventory, player, (IInventory)new Inventory(1), (IIntArray)new IntArray(2));
    }

    public EvaporationTowerContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, IInventory furnaceInventoryIn, IIntArray towerData) {
        super(RankineBlocks.EVAPORATION_TOWER_CONTAINER, windowId);
        this.tileEntity = world.func_175625_s(pos);
        EvaporationTowerContainer.func_216962_a((IInventory)furnaceInventoryIn, (int)1);
        EvaporationTowerContainer.func_216959_a((IIntArray)towerData, (int)2);
        this.playerEntity = player;
        this.data = towerData;
        this.furnaceInventory = furnaceInventoryIn;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.func_75146_a(new Slot(furnaceInventoryIn, 0, 80, 26));
        this.layoutPlayerInventorySlots(8, 70);
        this.func_216961_a(towerData);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookTime() {
        return this.data.func_221476_a(0);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTotalCookTime() {
        return this.data.func_221476_a(1);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressScaled(int pixels) {
        int i = this.getCookTime();
        int j = this.getTotalCookTime();
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return EvaporationTowerContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)((Block)RankineBlocks.EVAPORATION_TOWER.get()));
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index == 0) {
                if (!this.func_75135_a(stack, 1, 37, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (index < 28 ? !this.func_75135_a(stack, 28, 37, false) : index < 37 && !this.func_75135_a(stack, 1, 28, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public int getOutputSlot() {
        return 0;
    }
}

