/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.evaporationtower;

import com.cannolicatfish.rankine.blocks.evaporationtower.EvaporationTowerContainer;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.recipe.EvaporationRecipe;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class EvaporationTowerTile
extends TileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private static final int[] SLOTS_UP = new int[0];
    private static final int[] SLOTS_DOWN = new int[]{0};
    private static final int[] SLOTS_HORIZONTAL = new int[0];
    private int cookTime;
    private int cookTimeTotal = 6400;
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    private final IIntArray towerData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return EvaporationTowerTile.this.cookTime;
                }
                case 1: {
                    return EvaporationTowerTile.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    EvaporationTowerTile.this.cookTime = value;
                    break;
                }
                case 1: {
                    EvaporationTowerTile.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public EvaporationTowerTile() {
        super(RankineBlocks.EVAPORATION_TOWER_TILE);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        return compound;
    }

    public void func_73660_a() {
        World worldIn = this.func_145831_w();
        if (!worldIn.field_72995_K) {
            ItemStack output = (ItemStack)this.items.get(0);
            BlockPos p = this.func_174877_v();
            EvaporationRecipe recipe = this.getEvaporationRecipe(p.func_177984_a());
            if (recipe != null) {
                if (this.cookTimeTotal != recipe.getTime()) {
                    this.cookTimeTotal = recipe.getTime();
                }
                if (recipe.isLarge()) {
                    int h = this.checkStructure(p, worldIn, worldIn.func_180495_p(p.func_177984_a()).func_177230_c());
                    if (h > 0 && output.func_190926_b()) {
                        ++this.cookTime;
                        if (this.cookTime >= this.cookTimeTotal / h) {
                            this.items.set(0, (Object)recipe.getEvaporationResult(worldIn, worldIn.func_226691_t_(p).getRegistryName()));
                            this.cookTime = 0;
                        }
                    } else if (this.cookTime > 0) {
                        this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
                    }
                } else if (this.boilerStructure(p, worldIn) && output.func_190926_b()) {
                    ++this.cookTime;
                    if (this.cookTime >= this.cookTimeTotal) {
                        worldIn.func_180501_a(p.func_177984_a(), Blocks.field_150350_a.func_176223_P(), 3);
                        this.items.set(0, (Object)recipe.getEvaporationResult(worldIn, worldIn.func_226691_t_(p).getRegistryName()));
                        this.cookTime = 0;
                    }
                } else if (this.cookTime > 0) {
                    this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
                }
            }
        }
    }

    private EvaporationRecipe getEvaporationRecipe(BlockPos pos) {
        if (this.field_145850_b != null) {
            for (EvaporationRecipe recipe : this.field_145850_b.func_199532_z().func_241447_a_(RankineRecipeTypes.EVAPORATION)) {
                if (recipe.getEvaporationResult(this.field_145850_b, this.field_145850_b.func_226691_t_(pos).getRegistryName()).func_190926_b() || !recipe.fluidMatch(this.field_145850_b.func_204610_c(pos).func_206886_c())) continue;
                return recipe;
            }
        }
        return null;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    private boolean boilerStructure(BlockPos pos, World worldIn) {
        if (!worldIn.field_72995_K) {
            for (BlockPos p : Arrays.asList(pos.func_177978_c(), pos.func_177974_f(), pos.func_177968_d(), pos.func_177976_e(), pos.func_177984_a().func_177978_c(), pos.func_177984_a().func_177974_f(), pos.func_177984_a().func_177976_e(), pos.func_177984_a().func_177968_d())) {
                if (worldIn.func_180495_p(p).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal"))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private int checkStructure(BlockPos pos, World worldIn, Block fluid) {
        int height = 0;
        if (!worldIn.field_72995_K) {
            List<BlockPos> Base = Arrays.asList(pos.func_177982_a(2, 0, -1), pos.func_177982_a(2, 0, 0), pos.func_177982_a(2, 0, 1), pos.func_177982_a(-2, 0, -1), pos.func_177982_a(-2, 0, 0), pos.func_177982_a(-2, 0, 1), pos.func_177982_a(-1, 0, 2), pos.func_177982_a(0, 0, 2), pos.func_177982_a(1, 0, 2), pos.func_177982_a(-1, 0, 2), pos.func_177982_a(0, 0, 2), pos.func_177982_a(1, 0, 2), pos.func_177982_a(1, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(0, 0, -1), pos.func_177982_a(1, 0, 1), pos.func_177982_a(1, 0, -1), pos.func_177982_a(-1, 0, 1), pos.func_177982_a(-1, 0, -1));
            for (BlockPos b : Base) {
                if (worldIn.func_180495_p(b) == Blocks.field_196814_hQ.func_176223_P()) continue;
                return 0;
            }
            for (int i = 1; i <= (Integer)Config.MACHINES.EVAPORATION_TOWER_RANGE.get(); ++i) {
                if (!worldIn.func_180495_p(pos.func_177982_a(3, i, -1)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(3, i, 0)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(3, i, 1)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(-3, i, -1)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(-3, i, 0)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(-3, i, 1)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(-1, i, 3)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(0, i, 3)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(1, i, 3)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(-1, i, 3)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(0, i, 3)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(2, i, 2)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(-2, i, -2)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(2, i, -2)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || !worldIn.func_180495_p(pos.func_177982_a(-2, i, 2)).func_177230_c().getTags().contains(new ResourceLocation("forge:sheetmetal")) || worldIn.func_180495_p(pos.func_177982_a(2, i, -1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(2, i, 0)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(2, i, 1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(-2, i, -1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(-2, i, 0)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(-2, i, 1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(-1, i, 2)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(0, i, 2)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(1, i, 2)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(-1, i, -2)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(0, i, -2)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(1, i, -2)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(1, i, 0)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(-1, i, 0)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(-1, i, -1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(1, i, 1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(-1, i, 1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(1, i, -1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(0, i, 1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(0, i, -1)) != Blocks.field_203203_C.func_176223_P() || worldIn.func_180495_p(pos.func_177982_a(0, i, 0)).func_177230_c() != fluid) continue;
                height = i;
            }
        }
        return height;
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new EvaporationTowerContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity, (IInventory)this, this.towerData);
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public void func_174888_l() {
        this.items.clear();
    }
}

