/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.gyratorycrusher;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.items.PowerCellItem;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class GyratoryCrusherContainer
extends Container {
    private TileEntity tileEntity;
    private final IInventory furnaceInventory;
    private PlayerEntity playerEntity;
    private IItemHandler playerInventory;
    private final IIntArray data;
    protected final World world;

    public GyratoryCrusherContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player) {
        this(windowId, world, pos, playerInventory, player, (IInventory)new Inventory(8), (IIntArray)new IntArray(4));
    }

    public GyratoryCrusherContainer(int windowId, World world, BlockPos pos, PlayerInventory playerInventory, PlayerEntity player, IInventory furnaceInventoryIn, IIntArray furnaceData) {
        super(RankineBlocks.GYRATORY_CRUSHER_CONTAINER, windowId);
        this.tileEntity = world.func_175625_s(pos);
        GyratoryCrusherContainer.func_216962_a((IInventory)furnaceInventoryIn, (int)5);
        GyratoryCrusherContainer.func_216959_a((IIntArray)furnaceData, (int)4);
        this.data = furnaceData;
        this.playerEntity = player;
        this.furnaceInventory = furnaceInventoryIn;
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.world = this.playerEntity.field_70170_p;
        this.func_75146_a(new Slot(this.furnaceInventory, 0, 56, 31));
        this.func_75146_a(new Slot(this.furnaceInventory, 1, 10, 37));
        this.func_75146_a(new Slot(this.furnaceInventory, 2, 98, 34));
        this.func_75146_a(new Slot(this.furnaceInventory, 3, 124, 34));
        this.func_75146_a(new Slot(this.furnaceInventory, 4, 150, 34));
        this.func_75146_a(new Slot(this.furnaceInventory, 5, 98, 60));
        this.func_75146_a(new Slot(this.furnaceInventory, 6, 124, 60));
        this.func_75146_a(new Slot(this.furnaceInventory, 7, 150, 60));
        this.layoutPlayerInventorySlots(10, 86);
        this.func_216961_a(furnaceData);
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return GyratoryCrusherContainer.func_216963_a((IWorldPosCallable)IWorldPosCallable.func_221488_a((World)this.tileEntity.func_145831_w(), (BlockPos)this.tileEntity.func_174877_v()), (PlayerEntity)this.playerEntity, (Block)((Block)RankineBlocks.GYRATORY_CRUSHER.get()));
    }

    protected boolean hasRecipe(ItemStack stack) {
        return this.world.func_199532_z().func_215371_a(RankineRecipeTypes.CRUSHING, (IInventory)new Inventory(new ItemStack[]{stack}), this.world).isPresent();
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack stack = slot.func_75211_c();
            itemstack = stack.func_77946_l();
            if (index >= 2 && index <= 7) {
                if (!this.func_75135_a(stack, 8, 44, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(stack, itemstack);
            } else if (index != 1 && index != 0 ? (this.hasRecipe(stack) ? !this.func_75135_a(stack, 0, 1, false) : (stack.func_77973_b() instanceof PowerCellItem ? !this.func_75135_a(stack, 1, 2, false) : (index < 35 ? !this.func_75135_a(stack, 35, 44, false) : index < 44 && !this.func_75135_a(stack, 8, 35, false)))) : !this.func_75135_a(stack, 8, 44, false)) {
                return ItemStack.field_190927_a;
            }
            if (stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (stack.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, stack);
        }
        return itemstack;
    }

    private int addSlotRange(IItemHandler handler, int index, int x, int y, int amount, int dx) {
        for (int i = 0; i < amount; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(handler, index, x, y));
            x += dx;
            ++index;
        }
        return index;
    }

    private int addSlotBox(IItemHandler handler, int index, int x, int y, int horAmount, int dx, int verAmount, int dy) {
        for (int j = 0; j < verAmount; ++j) {
            index = this.addSlotRange(handler, index, x, y, horAmount, dx);
            y += dy;
        }
        return index;
    }

    private void layoutPlayerInventorySlots(int leftCol, int topRow) {
        this.addSlotBox(this.playerInventory, 9, leftCol, topRow, 9, 18, 3, 18);
        this.addSlotRange(this.playerInventory, 0, leftCol, topRow += 58, 9, 18);
    }

    public int getOutputSlot() {
        return 2;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getBurnLeftScaled(int pixels) {
        int i = this.data.func_221476_a(1);
        if (i == 0) {
            i = 200;
        }
        return this.data.func_221476_a(0) * pixels / i;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getCookProgressScaled(int pixels) {
        int i = this.data.func_221476_a(2);
        int j = this.data.func_221476_a(3);
        return j != 0 && i != 0 ? i * pixels / j : 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isBurning() {
        return this.data.func_221476_a(0) > 0;
    }
}

