/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.gyratorycrusher;

import com.cannolicatfish.rankine.blocks.gyratorycrusher.GyratoryCrusherContainer;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.items.PowerCellItem;
import com.cannolicatfish.rankine.recipe.CrushingRecipe;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class GyratoryCrusherTile
extends TileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private static final int[] SLOTS_UP = new int[]{0};
    private static final int[] SLOTS_DOWN = new int[]{2, 3, 4, 5, 6, 7};
    private static final int[] SLOTS_HORIZONTAL = new int[]{1};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)8, (Object)ItemStack.field_190927_a);
    private int burnTime;
    private int currentBurnTime;
    private int cookTime;
    private int cookTimeTotal = 200;
    private int currentLevel = 1;
    private final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return GyratoryCrusherTile.this.burnTime;
                }
                case 1: {
                    return GyratoryCrusherTile.this.currentBurnTime;
                }
                case 2: {
                    return GyratoryCrusherTile.this.cookTime;
                }
                case 3: {
                    return GyratoryCrusherTile.this.cookTimeTotal;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    GyratoryCrusherTile.this.burnTime = value;
                    break;
                }
                case 1: {
                    GyratoryCrusherTile.this.currentBurnTime = value;
                    break;
                }
                case 2: {
                    GyratoryCrusherTile.this.cookTime = value;
                    break;
                }
                case 3: {
                    GyratoryCrusherTile.this.cookTimeTotal = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public GyratoryCrusherTile() {
        super(RankineBlocks.GYRATORY_CRUSHER_TILE);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.burnTime = nbt.func_74762_e("BurnTime");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
        this.currentBurnTime = ForgeHooks.getBurnTime((ItemStack)((ItemStack)this.items.get(1)));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return compound;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning() && (PowerCellItem.getTier((ItemStack)this.items.get(1)) != this.currentLevel || PowerCellItem.getTier((ItemStack)this.items.get(1)) == 0)) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack input = (ItemStack)this.items.get(0);
            ItemStack fuel = (ItemStack)this.items.get(1);
            if (this.isBurning() || !fuel.func_190926_b() && !((ItemStack)this.items.get(0)).func_190926_b()) {
                CrushingRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(RankineRecipeTypes.CRUSHING, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canSmelt(irecipe)) {
                    this.currentBurnTime = this.burnTime = PowerCellItem.getTier(fuel) != 0 ? 50 : 0;
                    this.currentLevel = PowerCellItem.getTier(fuel);
                    if (this.isBurning()) {
                        flag1 = true;
                    }
                }
                if (this.isBurning() && this.canSmelt(irecipe)) {
                    ++this.cookTime;
                    if (this.cookTime >= this.cookTimeTotal) {
                        List<ItemStack> results = irecipe.getResults(this.currentLevel - 1, this.field_145850_b);
                        for (int i = 0; i < results.size(); ++i) {
                            if (((ItemStack)this.items.get(2 + i)).func_190916_E() > 0) {
                                ((ItemStack)this.items.get(2 + i)).func_190917_f(results.get(i).func_190916_E());
                            }
                            if (((ItemStack)this.items.get(2 + i)).func_190916_E() > 0) continue;
                            this.items.set(2 + i, (Object)results.get(i).func_77946_l());
                        }
                        input.func_190918_g(1);
                        this.cookTime = 0;
                        return;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isBurning(GyratoryCrusherTile te) {
        return te.furnaceData.func_221476_a(0) > 0;
    }

    private boolean canSmelt(@Nullable CrushingRecipe recipeIn) {
        if (!((ItemStack)this.items.get(0)).func_190926_b() && recipeIn != null) {
            List<ItemStack> itemstacks = recipeIn.getPossibleResults(this.currentLevel - 1, this.field_145850_b);
            if (itemstacks.isEmpty()) {
                return false;
            }
            for (int i = 0; i < this.currentLevel - 1; ++i) {
                ItemStack itemstack = (ItemStack)this.items.get(2 + i);
                if (!itemstack.func_77969_a(itemstacks.get(i)) && !itemstack.func_190926_b()) {
                    return false;
                }
                if (itemstack.func_190916_E() + itemstacks.get(i).func_190916_E() > this.func_70297_j_() && itemstack.func_190916_E() + itemstacks.get(i).func_190916_E() > itemstack.func_77976_d()) {
                    return false;
                }
                if (itemstack.func_190916_E() + itemstacks.get(i).func_190916_E() <= itemstacks.get(i).func_77976_d()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new GyratoryCrusherContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity, (IInventory)this, this.furnaceData);
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = 200;
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        CrushingRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(RankineRecipeTypes.CRUSHING, (IInventory)this, this.field_145850_b).orElse(null);
        List<ItemStack> outputs = Arrays.asList(ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a);
        if (recipe != null) {
            outputs = recipe.getPossibleResults(3, this.field_145850_b);
        }
        switch (index) {
            case 0: {
                return true;
            }
            case 1: {
                return AbstractFurnaceTileEntity.func_213991_b((ItemStack)stack);
            }
            case 2: {
                return ItemStack.func_179545_c((ItemStack)outputs.get(0), (ItemStack)stack);
            }
            case 3: {
                return ItemStack.func_179545_c((ItemStack)outputs.get(1), (ItemStack)stack);
            }
            case 4: {
                return ItemStack.func_179545_c((ItemStack)outputs.get(2), (ItemStack)stack);
            }
        }
        return false;
    }

    public void func_174888_l() {
        this.items.clear();
    }
}

