/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.inductionfurnace;

import com.cannolicatfish.rankine.blocks.inductionfurnace.InductionFurnaceContainer;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineRecipeTypes;
import com.cannolicatfish.rankine.items.AlloyTemplateItem;
import com.cannolicatfish.rankine.items.PowerCellItem;
import com.cannolicatfish.rankine.recipe.AlloyingRecipe;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class InductionFurnaceTile
extends TileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private static final int[] SLOTS_UP = new int[]{6, 7};
    private static final int[] SLOTS_EAST = new int[]{0, 1};
    private static final int[] SLOTS_WEST = new int[]{2, 3};
    private static final int[] SLOTS_BACK = new int[]{4, 5};
    private static final int[] SLOTS_DOWN = new int[]{8};
    protected NonNullList<ItemStack> items = NonNullList.func_191197_a((int)9, (Object)ItemStack.field_190927_a);
    private boolean recipeMode = false;
    private int burnTime;
    private int currentBurnTime;
    private int cookTime;
    private int cookTimeTotal = 1600;
    private int tickAdd = 1;
    private final IIntArray furnaceData = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return InductionFurnaceTile.this.burnTime;
                }
                case 1: {
                    return InductionFurnaceTile.this.currentBurnTime;
                }
                case 2: {
                    return InductionFurnaceTile.this.cookTime;
                }
                case 3: {
                    return InductionFurnaceTile.this.cookTimeTotal;
                }
                case 4: {
                    return InductionFurnaceTile.this.recipeMode ? 1 : 0;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    InductionFurnaceTile.this.burnTime = value;
                    break;
                }
                case 1: {
                    InductionFurnaceTile.this.currentBurnTime = value;
                    break;
                }
                case 2: {
                    InductionFurnaceTile.this.cookTime = value;
                    break;
                }
                case 3: {
                    InductionFurnaceTile.this.cookTimeTotal = value;
                    break;
                }
                case 4: {
                    InductionFurnaceTile.this.recipeMode = value == 1;
                }
            }
        }

        public int func_221478_a() {
            return 5;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.EAST, Direction.WEST, Direction.SOUTH});

    public InductionFurnaceTile() {
        super(RankineBlocks.INDUCTION_FURNACE_TILE);
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.burnTime = nbt.func_74762_e("BurnTime");
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
        this.currentBurnTime = 6400 * PowerCellItem.getTier((ItemStack)this.items.get(6));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", this.burnTime);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return compound;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning() && (PowerCellItem.getTier((ItemStack)this.items.get(6)) != this.tickAdd || PowerCellItem.getTier((ItemStack)this.items.get(6)) == 0)) {
            --this.burnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack[] inputs = new ItemStack[]{(ItemStack)this.items.get(0), (ItemStack)this.items.get(1), (ItemStack)this.items.get(2), (ItemStack)this.items.get(3), (ItemStack)this.items.get(4), (ItemStack)this.items.get(5)};
            ItemStack fuel = (ItemStack)this.items.get(6);
            if (this.isBurning() || !fuel.func_190926_b() && !Arrays.stream(inputs).allMatch(ItemStack::func_190926_b)) {
                AlloyingRecipe irecipe = this.field_145850_b.func_199532_z().func_215371_a(RankineRecipeTypes.ALLOYING, (IInventory)this, this.field_145850_b).orElse(null);
                if (!this.isBurning() && this.canSmelt(irecipe, (IInventory)this)) {
                    this.currentBurnTime = this.burnTime = PowerCellItem.getTier(fuel) != 0 ? 50 : 0;
                    this.tickAdd = PowerCellItem.getTier(fuel);
                    if (this.isBurning()) {
                        flag1 = true;
                    }
                }
                if (this.isBurning() && this.canSmelt(irecipe, (IInventory)this)) {
                    this.cookTime += this.tickAdd;
                    if (this.cookTime >= this.cookTimeTotal) {
                        if (this.recipeMode) {
                            ItemStack template = this.func_70301_a(7);
                            ItemStack output = AlloyTemplateItem.getResult(template).func_77946_l();
                            block0: for (ItemStack input : AlloyTemplateItem.getInputStacks(template)) {
                                ArrayList<ItemStack> addIt = new ArrayList<ItemStack>();
                                Item tempItem = input.func_77973_b();
                                int count = input.func_190916_E();
                                for (int i = 0; i < 6; ++i) {
                                    if (inputs[i].func_77973_b() != tempItem) continue;
                                    addIt.add(inputs[i]);
                                }
                                for (ItemStack s : addIt) {
                                    int shramt = count - s.func_190916_E();
                                    if (shramt > 0) {
                                        count = shramt;
                                        s.func_190920_e(0);
                                        continue;
                                    }
                                    s.func_190918_g(count);
                                    continue block0;
                                }
                            }
                            ItemStack smelting = output;
                            if (((ItemStack)this.items.get(8)).func_190916_E() > 0) {
                                ((ItemStack)this.items.get(8)).func_190917_f(smelting.func_190916_E());
                            } else {
                                this.items.set(8, (Object)smelting);
                            }
                        } else {
                            ItemStack output = irecipe.generateResult((IInventory)this, 2).func_77946_l();
                            int[] x = new int[]{inputs[0].func_190916_E(), inputs[1].func_190916_E(), inputs[2].func_190916_E(), inputs[3].func_190916_E(), inputs[4].func_190916_E(), inputs[5].func_190916_E()};
                            ItemStack smelting = output;
                            if (((ItemStack)this.items.get(8)).func_190916_E() > 0) {
                                ((ItemStack)this.items.get(8)).func_190917_f(smelting.func_190916_E());
                            } else {
                                this.items.set(8, (Object)smelting);
                            }
                            inputs[0].func_190918_g(x[0]);
                            inputs[1].func_190918_g(x[1]);
                            inputs[2].func_190918_g(x[2]);
                            inputs[3].func_190918_g(x[3]);
                            inputs[4].func_190918_g(x[4]);
                            inputs[5].func_190918_g(x[5]);
                        }
                        this.cookTime = 0;
                        return;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(this.isBurning())), 3);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean isBurning(InductionFurnaceTile te) {
        return te.furnaceData.func_221476_a(0) > 0;
    }

    private boolean canSmelt(@Nullable AlloyingRecipe recipeIn, IInventory inv) {
        if (recipeIn != null || inv.func_70301_a(7).func_77973_b() instanceof AlloyTemplateItem) {
            ItemStack stack;
            this.recipeMode = inv.func_70301_a(7).func_77973_b() instanceof AlloyTemplateItem;
            ItemStack template = inv.func_70301_a(7);
            if (this.recipeMode) {
                if ((AlloyTemplateItem.getTier(template) & 2) != 2) {
                    return false;
                }
                for (ItemStack input : AlloyTemplateItem.getInputStacks(template)) {
                    Item tempItem = input.func_77973_b();
                    int count = input.func_190916_E();
                    if (inv.func_213901_a(tempItem) >= count) continue;
                    return false;
                }
            }
            ItemStack itemStack = stack = this.recipeMode ? AlloyTemplateItem.getResult(template) : recipeIn.generateResult(inv, 2);
            if (stack.func_190926_b()) {
                return false;
            }
            ItemStack itemstack1 = (ItemStack)this.items.get(8);
            if (itemstack1.func_190926_b()) {
                return true;
            }
            if (!itemstack1.func_77969_a(stack) && !itemstack1.func_190926_b()) {
                return false;
            }
            if (itemstack1.func_190916_E() + stack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + stack.func_190916_E() <= itemstack1.func_77976_d()) {
                return true;
            }
            return itemstack1.func_190916_E() + stack.func_190916_E() <= stack.func_77976_d();
        }
        return false;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            switch (facing) {
                case UP: {
                    return this.handlers[0].cast();
                }
                case DOWN: {
                    return this.handlers[1].cast();
                }
                case EAST: {
                    return this.handlers[2].cast();
                }
                case WEST: {
                    return this.handlers[3].cast();
                }
            }
            return this.handlers[4].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new InductionFurnaceContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity, (IInventory)this, this.furnaceData);
    }

    public int[] func_180463_a(Direction side) {
        switch (side) {
            case UP: {
                return SLOTS_UP;
            }
            case DOWN: {
                return SLOTS_DOWN;
            }
            case EAST: {
                return SLOTS_EAST;
            }
            case WEST: {
                return SLOTS_WEST;
            }
        }
        return SLOTS_BACK;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.cookTimeTotal = 1600;
            this.cookTime = 0;
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return PeriodicTableUtils.getInstance().hasElement(stack.func_77973_b());
            }
            case 6: {
                return stack.func_77973_b() instanceof PowerCellItem;
            }
            case 7: {
                return stack.func_77973_b() instanceof AlloyTemplateItem;
            }
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void func_174888_l() {
        this.items.clear();
    }
}

