/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.laserquarry;

import com.cannolicatfish.rankine.blocks.laserquarry.LaserQuarryContainer;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.items.PowerCellItem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class LaserQuarryTile
extends TileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private static final int[] SLOTS_UP = new int[0];
    private static final int[] SLOTS_DOWN = new int[]{0};
    private static final int[] SLOTS_HORIZONTAL = new int[0];
    private int cookTime;
    private int cookTimeTotal;
    protected NonNullList<ItemStack> items;
    private final IIntArray towerData;
    int i;
    int x;
    int y;
    int z;
    LazyOptional<? extends IItemHandler>[] handlers;

    public LaserQuarryTile() {
        super(RankineBlocks.LASER_QUARRY_TILE);
        this.cookTimeTotal = (Integer)Config.MACHINES.LASER_QUARRY_SPEED.get();
        this.items = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        this.towerData = new IIntArray(){

            public int func_221476_a(int index) {
                switch (index) {
                    case 0: {
                        return LaserQuarryTile.this.cookTime;
                    }
                    case 1: {
                        return LaserQuarryTile.this.cookTimeTotal;
                    }
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
                switch (index) {
                    case 0: {
                        LaserQuarryTile.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        LaserQuarryTile.this.cookTimeTotal = value;
                    }
                }
            }

            public int func_221478_a() {
                return 2;
            }
        };
        this.i = 0;
        this.x = 0;
        this.y = 1;
        this.z = 0;
        this.handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        return compound;
    }

    public void func_73660_a() {
        World worldIn = this.func_145831_w();
        int maxRadius = this.checkStructure(this.field_174879_c, worldIn);
        if (!worldIn.field_72995_K && this.i <= maxRadius) {
            if (worldIn.func_175640_z(this.field_174879_c) && maxRadius > 0 && ((ItemStack)this.items.get(0)).func_77973_b() instanceof PowerCellItem) {
                ++this.cookTime;
                if (this.cookTime == this.cookTimeTotal) {
                    for (BlockPos TARGET_POS : BlockPos.func_218278_a((BlockPos)this.field_174879_c.func_177982_a(-this.i, -this.y, -this.i), (BlockPos)this.field_174879_c.func_177982_a(this.i, -this.y, this.i))) {
                        Block TARGET_BLOCK = worldIn.func_180495_p(TARGET_POS).func_177230_c();
                        boolean stop = false;
                        if (TARGET_BLOCK != Blocks.field_150350_a && !TARGET_BLOCK.getTags().contains(new ResourceLocation("rankine:nonquarryable"))) {
                            for (int height = TARGET_POS.func_177956_o(); height <= this.field_174879_c.func_177956_o(); ++height) {
                                if (worldIn.func_180495_p(new BlockPos(TARGET_POS.func_177958_n(), height, TARGET_POS.func_177952_p())) != ((Block)RankineBlocks.QUARRY_BARRIER.get()).func_176223_P()) continue;
                                stop = true;
                                break;
                            }
                            if (!stop) {
                                worldIn.func_175655_b(TARGET_POS, false);
                            }
                        }
                        this.cookTime = 0;
                    }
                    ++this.y;
                    if (this.y >= this.field_174879_c.func_177956_o()) {
                        this.y = 1;
                        ++this.i;
                    }
                }
            } else if (this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
        }
    }

    private int checkStructure(BlockPos pos, World worldIn) {
        List<BlockPos> Base = Arrays.asList(pos.func_177982_a(1, 0, 0), pos.func_177982_a(2, 0, 0), pos.func_177982_a(0, 0, 1), pos.func_177982_a(0, 0, 2), pos.func_177982_a(-1, 0, 0), pos.func_177982_a(-2, 0, 0), pos.func_177982_a(0, 0, -1), pos.func_177982_a(0, 0, -2), pos.func_177982_a(1, 0, 1), pos.func_177982_a(1, 0, -1), pos.func_177982_a(-1, 0, 1), pos.func_177982_a(-1, 0, -1));
        for (BlockPos b : Base) {
            if (worldIn.func_180495_p(b) == ((Block)RankineBlocks.STAINLESS_STEEL_SHEETMETAL.get()).func_176223_P()) continue;
            return 0;
        }
        BlockState lqb = ((Block)RankineBlocks.LASER_PYLON_BASE.get()).func_176223_P();
        BlockState lqt = ((Block)RankineBlocks.LASER_PYLON_TOP.get()).func_176223_P();
        for (int i = 1; i <= (Integer)Config.MACHINES.LASER_QUARRY_RANGE.get(); ++i) {
            if (worldIn.func_180495_p(pos.func_177982_a(2, i, 0)) == lqt && worldIn.func_180495_p(pos.func_177982_a(-2, i, 0)) == lqt && worldIn.func_180495_p(pos.func_177982_a(0, i, -2)) == lqt && worldIn.func_180495_p(pos.func_177982_a(0, i, 2)) == lqt) {
                return i;
            }
            if (worldIn.func_180495_p(pos.func_177982_a(2, i, 0)) == lqb || worldIn.func_180495_p(pos.func_177982_a(-2, i, 0)) == lqb || worldIn.func_180495_p(pos.func_177982_a(0, i, -2)) == lqb || worldIn.func_180495_p(pos.func_177982_a(0, i, 2)) == lqb) continue;
            return 0;
        }
        return 0;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new LaserQuarryContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity, (IInventory)this, this.towerData);
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        if (index == 0) {
            return stack.func_77973_b() instanceof PowerCellItem;
        }
        return true;
    }

    public void func_174888_l() {
        this.items.clear();
    }
}

