/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.plants;

import com.cannolicatfish.rankine.init.RankineItems;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import org.jetbrains.annotations.Nullable;

public class RankineDoublePlantBlock
extends BushBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlockStateProperties.field_208168_U;
    public static final EnumProperty<DoubleBlockHalf> SECTION = BlockStateProperties.field_208163_P;
    private int type;

    public RankineDoublePlantBlock(AbstractBlock.Properties properties, int type) {
        super(properties);
        this.type = type;
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)AGE, (Comparable)Integer.valueOf(0))).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.LOWER));
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public int getMaxAge() {
        return 3;
    }

    protected int getAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty());
    }

    public boolean isMaxAge(BlockState state) {
        return (Integer)state.func_177229_b((Property)this.getAgeProperty()) >= this.getMaxAge();
    }

    protected DoubleBlockHalf getSection(BlockState state) {
        return (DoubleBlockHalf)state.func_177229_b(SECTION);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            worldIn.func_180501_a(pos.func_177981_b(1), (BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)DoubleBlockHalf.UPPER), 3);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public void placeAt(IWorld worldIn, BlockPos pos, int flags) {
        worldIn.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)DoubleBlockHalf.LOWER), flags);
        worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_176223_P().func_206870_a(SECTION, (Comparable)DoubleBlockHalf.UPPER), flags);
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Block block = state.func_177230_c();
        return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_196660_k || block == Blocks.field_196661_l || block == Blocks.field_150391_bh || block == Blocks.field_150458_ak;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random rand) {
        super.func_225534_a_(state, worldIn, pos, rand);
        int i = (Integer)state.func_177229_b((Property)AGE);
        if (i < 3 && worldIn.func_226659_b_(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (rand.nextInt(5) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1))).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.LOWER), 2);
            worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(i + 1))).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.UPPER), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        if (state.func_177229_b(SECTION) != DoubleBlockHalf.UPPER) {
            return super.func_196260_a(state, worldIn, pos);
        }
        BlockState blockstate = worldIn.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            return super.func_196260_a(state, worldIn, pos);
        }
        return blockstate.func_203425_a((Block)this) && blockstate.func_177229_b(SECTION) == DoubleBlockHalf.LOWER;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)stateIn.func_177229_b(SECTION);
        if (facing.func_176740_k() != Direction.Axis.Y || doubleblockhalf == DoubleBlockHalf.LOWER != (facing == Direction.UP) || facingState.func_203425_a((Block)this) && facingState.func_177229_b(SECTION) != doubleblockhalf) {
            return doubleblockhalf == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    public boolean func_149653_t(BlockState state) {
        return !this.isMaxAge(state) && this.getSection(state).equals((Object)DoubleBlockHalf.LOWER);
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof LivingEntity && entityIn.func_200600_R() != EntityType.field_220356_B && entityIn.func_200600_R() != EntityType.field_226289_e_) {
            entityIn.func_213295_a(state, new Vector3d((double)0.8f, 0.75, (double)0.8f));
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        boolean flag;
        int i = (Integer)state.func_177229_b((Property)AGE);
        boolean bl = flag = i == 3;
        if (!flag && player.func_184586_b(handIn).func_77973_b() == Items.field_196106_bc) {
            return ActionResultType.PASS;
        }
        if (flag && !worldIn.field_72995_K && worldIn.func_82736_K().func_223586_b(GameRules.field_223603_f) && !worldIn.restoringBlockSnapshots) {
            switch (this.type) {
                case 0: {
                    RankineDoublePlantBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)RankineItems.ELDERBERRIES.get(), 1 + worldIn.field_73012_v.nextInt(2)));
                    break;
                }
                case 1: {
                    RankineDoublePlantBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)RankineItems.BLUEBERRIES.get(), 1 + worldIn.field_73012_v.nextInt(2)));
                    break;
                }
                case 2: {
                    RankineDoublePlantBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)RankineItems.CRANBERRIES.get(), 1 + worldIn.field_73012_v.nextInt(2)));
                }
            }
            worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
            switch ((DoubleBlockHalf)state.func_177229_b(SECTION)) {
                case LOWER: {
                    worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1))).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.LOWER), 2);
                    worldIn.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1))).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.UPPER), 2);
                    break;
                }
                case UPPER: {
                    worldIn.func_180501_a(pos.func_177977_b(), (BlockState)((BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1))).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.LOWER), 2);
                    worldIn.func_180501_a(pos, (BlockState)((BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(1))).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.UPPER), 2);
                }
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            if (player.func_184812_l_()) {
                RankineDoublePlantBlock.removeLowerSections(worldIn, pos, state, player);
            } else {
                RankineDoublePlantBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    protected static void removeLowerSections(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        if (((DoubleBlockHalf)state.func_177229_b(SECTION)).equals((Object)DoubleBlockHalf.UPPER) && (blockstate = world.func_180495_p(blockpos = pos.func_177979_c(1))).func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(SECTION) == DoubleBlockHalf.LOWER) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
    }

    public PathNodeType getAiPathNodeType(BlockState state, IBlockReader world, BlockPos pos, @Nullable MobEntity entity) {
        return PathNodeType.DANGER_OTHER;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{AGE, SECTION});
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        switch ((DoubleBlockHalf)state.func_177229_b(SECTION)) {
            case LOWER: {
                return !this.isMaxAge(state) && (worldIn.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150350_a) || worldIn.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this));
            }
            case UPPER: {
                return !this.isMaxAge(state);
            }
        }
        return !this.isMaxAge(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, BlockState state) {
        return true;
    }

    public void func_225535_a_(ServerWorld worldIn, Random rand, BlockPos pos, BlockState state) {
        int j;
        int i = this.getAge(state) + 1;
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        switch ((DoubleBlockHalf)state.func_177229_b(SECTION)) {
            case LOWER: {
                worldIn.func_180501_a(pos, (BlockState)this.withAge(i).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.LOWER), 2);
                worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.withAge(i).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.UPPER), 2);
                break;
            }
            case UPPER: {
                worldIn.func_180501_a(pos.func_177977_b(), (BlockState)this.withAge(i).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.LOWER), 2);
                worldIn.func_180501_a(pos, (BlockState)this.withAge(i).func_206870_a(SECTION, (Comparable)DoubleBlockHalf.UPPER), 2);
            }
        }
    }

    public BlockState withAge(int age) {
        return (BlockState)this.func_176223_P().func_206870_a((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
    }
}

