/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.plants;

import com.cannolicatfish.rankine.blocks.states.TripleBlockSection;
import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.CropsBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;

public class TripleCropsBlock
extends CropsBlock {
    public static final EnumProperty<TripleBlockSection> SECTION = EnumProperty.func_177709_a((String)"section", TripleBlockSection.class);
    private static final VoxelShape[] BOTTOM_SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] MIDDLE_SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};
    private static final VoxelShape[] TOP_SHAPE_BY_AGE = new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)};

    public TripleCropsBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.BOTTOM))).func_206870_a((Property)field_176488_a, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{field_176488_a, SECTION});
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        switch ((TripleBlockSection)((Object)state.func_177229_b(SECTION))) {
            case BOTTOM: {
                return BOTTOM_SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.func_185524_e())];
            }
            case MIDDLE: {
                return MIDDLE_SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.func_185524_e())];
            }
            case TOP: {
                return TOP_SHAPE_BY_AGE[(Integer)state.func_177229_b((Property)this.func_185524_e())];
            }
        }
        return super.func_220053_a(state, worldIn, pos, context);
    }

    protected TripleBlockSection getSection(BlockState state) {
        return (TripleBlockSection)((Object)state.func_177229_b(SECTION));
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150458_ak);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        switch ((TripleBlockSection)((Object)state.func_177229_b(SECTION))) {
            case BOTTOM: {
                return super.func_196260_a(state, worldIn, pos);
            }
            case MIDDLE: {
                BlockState blockstate1 = worldIn.func_180495_p(pos.func_177977_b());
                if (state.func_177230_c() != this) {
                    return super.func_196260_a(state, worldIn, pos);
                }
                return blockstate1.func_203425_a((Block)this) && blockstate1.func_177229_b(SECTION) == TripleBlockSection.BOTTOM;
            }
            case TOP: {
                BlockState blockstate2 = worldIn.func_180495_p(pos.func_177977_b());
                if (state.func_177230_c() != this) {
                    return super.func_196260_a(state, worldIn, pos);
                }
                return blockstate2.func_203425_a((Block)this) && blockstate2.func_177229_b(SECTION) == TripleBlockSection.MIDDLE;
            }
        }
        return super.func_196260_a(state, worldIn, pos);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        TripleBlockSection tripleBlockSection = (TripleBlockSection)((Object)stateIn.func_177229_b(SECTION));
        switch (tripleBlockSection) {
            case BOTTOM: 
            case MIDDLE: {
                if (facing.func_176740_k() != Direction.Axis.Y || facing != Direction.UP || facingState.func_203425_a((Block)this) && facingState.func_177229_b(SECTION) != tripleBlockSection) {
                    return facing == Direction.DOWN && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
                }
                return Blocks.field_150350_a.func_176223_P();
            }
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean func_149653_t(BlockState state) {
        return !this.func_185525_y(state) && this.getSection(state).equals((Object)TripleBlockSection.BOTTOM);
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        float f;
        int i;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (worldIn.func_226659_b_(pos, 0) >= 9 && (worldIn.func_180495_p(pos.func_177981_b(1)).func_203425_a(Blocks.field_150350_a) || worldIn.func_180495_p(pos.func_177981_b(1)).func_203425_a((Block)this)) && (worldIn.func_180495_p(pos.func_177981_b(2)).func_203425_a(Blocks.field_150350_a) || worldIn.func_180495_p(pos.func_177981_b(2)).func_203425_a((Block)this)) && (i = this.func_185527_x(state)) < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(25.0f / (f = TripleCropsBlock.func_180672_a((Block)this, (IBlockReader)worldIn, (BlockPos)pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, (BlockState)this.func_185528_e(i + 1).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.BOTTOM)), 2);
            worldIn.func_180501_a(pos.func_177981_b(1), (BlockState)this.func_185528_e(i + 1).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.MIDDLE)), 2);
            worldIn.func_180501_a(pos.func_177981_b(2), (BlockState)this.func_185528_e(i + 1).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.TOP)), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public void func_176487_g(World worldIn, BlockPos pos, BlockState state) {
        int j;
        int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if (i > (j = this.func_185526_g())) {
            i = j;
        }
        switch ((TripleBlockSection)((Object)state.func_177229_b(SECTION))) {
            case BOTTOM: {
                worldIn.func_180501_a(pos, (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.BOTTOM)), 2);
                worldIn.func_180501_a(pos.func_177981_b(1), (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.MIDDLE)), 2);
                worldIn.func_180501_a(pos.func_177981_b(2), (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.TOP)), 2);
                break;
            }
            case MIDDLE: {
                worldIn.func_180501_a(pos.func_177977_b(), (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.BOTTOM)), 2);
                worldIn.func_180501_a(pos, (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.MIDDLE)), 2);
                worldIn.func_180501_a(pos.func_177984_a(), (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.TOP)), 2);
                break;
            }
            case TOP: {
                worldIn.func_180501_a(pos.func_177979_c(2), (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.BOTTOM)), 2);
                worldIn.func_180501_a(pos.func_177979_c(1), (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.MIDDLE)), 2);
                worldIn.func_180501_a(pos, (BlockState)this.func_185528_e(i).func_206870_a(SECTION, (Comparable)((Object)TripleBlockSection.TOP)), 2);
            }
        }
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, BlockState state, boolean isClient) {
        switch ((TripleBlockSection)((Object)state.func_177229_b(SECTION))) {
            case BOTTOM: 
            case MIDDLE: {
                return !this.func_185525_y(state) && (worldIn.func_180495_p(pos.func_177984_a()).func_203425_a(Blocks.field_150350_a) || worldIn.func_180495_p(pos.func_177984_a()).func_203425_a((Block)this));
            }
            case TOP: {
                return !this.func_185525_y(state);
            }
        }
        return !this.func_185525_y(state);
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.field_72995_K) {
            if (player.func_184812_l_()) {
                TripleCropsBlock.removeLowerSections(worldIn, pos, state, player);
            } else {
                TripleCropsBlock.func_220054_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)null, (Entity)player, (ItemStack)player.func_184614_ca());
            }
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    protected static void removeLowerSections(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        BlockPos blockpos;
        BlockState blockstate;
        if (((TripleBlockSection)((Object)state.func_177229_b(SECTION))).equals((Object)TripleBlockSection.TOP)) {
            BlockPos blockpos2 = pos.func_177979_c(2);
            BlockState blockstate2 = world.func_180495_p(blockpos2);
            if (blockstate2.func_177230_c() == state.func_177230_c() && blockstate2.func_177229_b(SECTION) == TripleBlockSection.BOTTOM) {
                world.func_180501_a(blockpos2, Blocks.field_150350_a.func_176223_P(), 35);
                world.func_217378_a(player, 2001, blockpos2, Block.func_196246_j((BlockState)blockstate2));
            }
        } else if (((TripleBlockSection)((Object)state.func_177229_b(SECTION))).equals((Object)TripleBlockSection.MIDDLE) && (blockstate = world.func_180495_p(blockpos = pos.func_177979_c(1))).func_177230_c() == state.func_177230_c() && blockstate.func_177229_b(SECTION) == TripleBlockSection.BOTTOM) {
            world.func_180501_a(blockpos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, blockpos, Block.func_196246_j((BlockState)blockstate));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public long func_209900_a(BlockState state, BlockPos pos) {
        return MathHelper.func_180187_c((int)pos.func_177958_n(), (int)pos.func_177979_c(state.func_177229_b(SECTION) == TripleBlockSection.BOTTOM ? 0 : 1).func_177956_o(), (int)pos.func_177952_p());
    }
}

