/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.rankinebox;

import com.cannolicatfish.rankine.blocks.rankinebox.RankineBoxContainer;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.items.PowerCellItem;
import com.cannolicatfish.rankine.items.TransmuterItem;
import com.cannolicatfish.rankine.util.PeriodicTableUtils;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class RankineBoxTile
extends TileEntity
implements ISidedInventory,
ITickableTileEntity,
INamedContainerProvider {
    private static final PeriodicTableUtils utils = PeriodicTableUtils.getInstance();
    private static final int[] SLOTS_UP = new int[]{0, 1, 2};
    private static final int[] SLOTS_DOWN = new int[]{3};
    private static final int[] SLOTS_HORIZONTAL = new int[]{0, 1, 2};
    private int cookTime;
    private int cookTimeTotal;
    private int direction;
    private int powered;
    protected NonNullList<ItemStack> items;
    private final IIntArray tileData;
    LazyOptional<? extends IItemHandler>[] handlers;

    public RankineBoxTile() {
        super(RankineBlocks.RANKINE_BOX_TILE);
        this.cookTimeTotal = (Integer)Config.MACHINES.RANKINE_BOX_SPEED.get();
        this.direction = 0;
        this.powered = 0;
        this.items = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
        this.tileData = new IIntArray(){

            public int func_221476_a(int index) {
                switch (index) {
                    case 0: {
                        return RankineBoxTile.this.cookTime;
                    }
                    case 1: {
                        return RankineBoxTile.this.cookTimeTotal;
                    }
                    case 2: {
                        return RankineBoxTile.this.direction;
                    }
                    case 3: {
                        return RankineBoxTile.this.powered;
                    }
                }
                return 0;
            }

            public void func_221477_a(int index, int value) {
                switch (index) {
                    case 0: {
                        RankineBoxTile.this.cookTime = value;
                        break;
                    }
                    case 1: {
                        RankineBoxTile.this.cookTimeTotal = value;
                        break;
                    }
                    case 2: {
                        RankineBoxTile.this.direction = value;
                        break;
                    }
                    case 3: {
                        RankineBoxTile.this.powered = value;
                    }
                }
            }

            public int func_221478_a() {
                return 4;
            }
        };
        this.handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.items = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.items);
        this.cookTime = nbt.func_74762_e("CookTime");
        this.cookTimeTotal = nbt.func_74762_e("CookTimeTotal");
        this.direction = nbt.func_74762_e("Direction");
        this.powered = nbt.func_74762_e("Powered");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("CookTime", this.cookTime);
        compound.func_74768_a("CookTimeTotal", this.cookTimeTotal);
        compound.func_74768_a("Direction", this.direction);
        compound.func_74768_a("Powered", this.powered);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.items);
        return compound;
    }

    public void func_73660_a() {
        World worldIn = this.func_145831_w();
        if (!worldIn.field_72995_K) {
            boolean ready;
            ItemStack input = (ItemStack)this.items.get(0);
            ItemStack transmuter = (ItemStack)this.items.get(1);
            ItemStack fuel = (ItemStack)this.items.get(2);
            this.direction = this.getDirection(transmuter);
            PeriodicTableUtils.Element outputElement = utils.getAdjacentElement(utils.getElementFromIngotItem(input.func_77973_b()), this.direction);
            this.powered = this.isPowered(fuel) ? 1 : 0;
            boolean bl = ready = this.powered == 1 && outputElement != PeriodicTableUtils.Element.NONE && this.canSmelt(outputElement) && !utils.getElementIngot(outputElement).equals(Items.field_190931_a);
            if (ready) {
                this.cookTime += PowerCellItem.getTier(fuel);
                if (this.cookTime >= this.cookTimeTotal) {
                    ItemStack smelting = new ItemStack((IItemProvider)utils.getElementIngot(outputElement));
                    if (((ItemStack)this.items.get(3)).func_190916_E() > 0) {
                        ((ItemStack)this.items.get(3)).func_190917_f(smelting.func_190916_E());
                    } else {
                        this.items.set(3, (Object)smelting);
                    }
                    input.func_190918_g(1);
                    transmuter.func_190918_g(1);
                    this.cookTime = 0;
                }
            } else if (this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.cookTimeTotal);
            }
        }
    }

    private boolean isPowered(ItemStack fuel) {
        return PowerCellItem.getTier(fuel) > 0;
    }

    private boolean canSmelt(PeriodicTableUtils.Element element) {
        ItemStack stack = new ItemStack((IItemProvider)utils.getElementIngot(element));
        if (stack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = (ItemStack)this.items.get(3);
        if (itemstack1.func_190926_b()) {
            return true;
        }
        if (!itemstack1.func_77969_a(stack) && !itemstack1.func_190926_b()) {
            return false;
        }
        if (itemstack1.func_190916_E() + stack.func_190916_E() <= this.func_70297_j_() && itemstack1.func_190916_E() + stack.func_190916_E() <= itemstack1.func_77976_d()) {
            return true;
        }
        return itemstack1.func_190916_E() + stack.func_190916_E() <= stack.func_77976_d();
    }

    private int getDirection(ItemStack transmuter) {
        if (transmuter.func_77973_b() instanceof TransmuterItem) {
            if (transmuter.func_77973_b() == RankineItems.UP_TRANSMUTER.get()) {
                return 3;
            }
            if (transmuter.func_77973_b() == RankineItems.RIGHT_TRANSMUTER.get()) {
                return 4;
            }
            if (transmuter.func_77973_b() == RankineItems.DOWN_TRANSMUTER.get()) {
                return 5;
            }
            if (transmuter.func_77973_b() == RankineItems.LEFT_TRANSMUTER.get()) {
                return 6;
            }
            return 0;
        }
        return 0;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.field_145846_f && facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public ITextComponent func_145748_c_() {
        return new StringTextComponent(this.func_200662_C().getRegistryName().func_110623_a());
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new RankineBoxContainer(i, this.field_145850_b, this.field_174879_c, playerInventory, playerEntity, (IInventory)this, this.tileData);
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.DOWN) {
            return SLOTS_DOWN;
        }
        return side == Direction.UP ? SLOTS_UP : SLOTS_HORIZONTAL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.items.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.items, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.items.get(index);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.items.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (index == 0 && !flag) {
            this.func_70296_d();
        }
    }

    public boolean func_70300_a(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        switch (index) {
            case 0: {
                return PeriodicTableUtils.getInstance().hasElement(stack.func_77973_b());
            }
            case 1: {
                return stack.func_77973_b() instanceof TransmuterItem;
            }
            case 2: {
                return stack.func_77973_b() instanceof PowerCellItem;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    public void func_174888_l() {
        this.items.clear();
    }
}

