/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.tap;

import com.cannolicatfish.rankine.blocks.states.TreeTapFluids;
import com.cannolicatfish.rankine.blocks.tap.TreeTapBlock;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;

public class TapLineBlock
extends Block {
    private static final Direction[] FACING_VALUES = Direction.values();
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    public static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)Util.func_200696_a((Object)Maps.newEnumMap(Direction.class), directions -> {
        directions.put(Direction.NORTH, NORTH);
        directions.put(Direction.EAST, EAST);
        directions.put(Direction.SOUTH, SOUTH);
        directions.put(Direction.WEST, WEST);
        directions.put(Direction.UP, UP);
        directions.put(Direction.DOWN, DOWN);
    });
    protected final VoxelShape[] shapes;

    public TapLineBlock(float apothem, AbstractBlock.Properties properties) {
        super(properties);
        this.shapes = this.makeShapes(apothem);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)NORTH, (Comparable)Boolean.FALSE)).func_206870_a((Property)EAST, (Comparable)Boolean.FALSE)).func_206870_a((Property)SOUTH, (Comparable)Boolean.FALSE)).func_206870_a((Property)WEST, (Comparable)Boolean.FALSE)).func_206870_a((Property)UP, (Comparable)Boolean.FALSE)).func_206870_a((Property)DOWN, (Comparable)Boolean.FALSE));
    }

    private VoxelShape[] makeShapes(float apothem) {
        float f = 0.5f - apothem;
        float f1 = 0.5f + apothem;
        VoxelShape voxelshape = Block.func_208617_a((double)(f * 16.0f), (double)(f * 16.0f), (double)(f * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f), (double)(f1 * 16.0f));
        VoxelShape[] avoxelshape = new VoxelShape[FACING_VALUES.length];
        for (int i = 0; i < FACING_VALUES.length; ++i) {
            Direction direction = FACING_VALUES[i];
            avoxelshape[i] = VoxelShapes.func_197873_a((double)(0.5 + Math.min((double)(-apothem), (double)direction.func_82601_c() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.func_96559_d() * 0.5)), (double)(0.5 + Math.min((double)(-apothem), (double)direction.func_82599_e() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_82601_c() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_96559_d() * 0.5)), (double)(0.5 + Math.max((double)apothem, (double)direction.func_82599_e() * 0.5)));
        }
        VoxelShape[] avoxelshape1 = new VoxelShape[64];
        for (int k = 0; k < 64; ++k) {
            VoxelShape voxelshape1 = voxelshape;
            for (int j = 0; j < FACING_VALUES.length; ++j) {
                if ((k & 1 << j) == 0) continue;
                voxelshape1 = VoxelShapes.func_197872_a((VoxelShape)voxelshape1, (VoxelShape)avoxelshape[j]);
            }
            avoxelshape1[k] = voxelshape1;
        }
        return avoxelshape1;
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return false;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    protected int getShapeIndex(BlockState state) {
        int i = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (!((Boolean)state.func_177229_b((Property)FACING_TO_PROPERTY_MAP.get(FACING_VALUES[j]))).booleanValue()) continue;
            i |= 1 << j;
        }
        return i;
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.makeConnections((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState makeConnections(IBlockReader blockReader, BlockPos pos) {
        Block block = blockReader.func_180495_p(pos.func_177977_b()).func_177230_c();
        Block block1 = blockReader.func_180495_p(pos.func_177984_a()).func_177230_c();
        BlockState bs1 = blockReader.func_180495_p(pos.func_177984_a());
        Block block2 = blockReader.func_180495_p(pos.func_177978_c()).func_177230_c();
        Block block3 = blockReader.func_180495_p(pos.func_177974_f()).func_177230_c();
        Block block4 = blockReader.func_180495_p(pos.func_177968_d()).func_177230_c();
        Block block5 = blockReader.func_180495_p(pos.func_177976_e()).func_177230_c();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)DOWN, (Comparable)Boolean.valueOf(block == this))).func_206870_a((Property)NORTH, (Comparable)Boolean.valueOf(block2 == this || block2 == RankineBlocks.TAP_BARREL.get()))).func_206870_a((Property)EAST, (Comparable)Boolean.valueOf(block3 == this || block3 == RankineBlocks.TAP_BARREL.get()))).func_206870_a((Property)SOUTH, (Comparable)Boolean.valueOf(block4 == this || block4 == RankineBlocks.TAP_BARREL.get()))).func_206870_a((Property)WEST, (Comparable)Boolean.valueOf(block5 == this || block5 == RankineBlocks.TAP_BARREL.get()))).func_206870_a((Property)UP, (Comparable)Boolean.valueOf(block1 == this || block1 == RankineBlocks.TREE_TAP.get() && bs1 != ((Block)RankineBlocks.TREE_TAP.get()).func_176223_P().func_206870_a(TreeTapBlock.FLUID, (Comparable)((Object)TreeTapFluids.NONE))));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (!stateIn.func_196955_c((IWorldReader)worldIn, currentPos)) {
            worldIn.func_205220_G_().func_205360_a(currentPos, (Object)this, 1);
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        boolean flag = false;
        Block fsb = facingState.func_177230_c();
        switch (facing) {
            case DOWN: {
                flag = fsb == this;
                break;
            }
            case UP: {
                flag = fsb == this || fsb == RankineBlocks.TREE_TAP.get() && facingState != ((Block)RankineBlocks.TREE_TAP.get()).func_176223_P().func_206870_a(TreeTapBlock.FLUID, (Comparable)((Object)TreeTapFluids.NONE));
                break;
            }
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                flag = fsb == this || fsb.func_235332_a_((Block)RankineBlocks.TAP_BARREL.get());
            }
        }
        return (BlockState)stateIn.func_206870_a((Property)FACING_TO_PROPERTY_MAP.get(facing), (Comparable)Boolean.valueOf(flag));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }
}

