/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.blocks.tap;

import com.cannolicatfish.rankine.blocks.states.TapBarrelFluids;
import com.cannolicatfish.rankine.blocks.states.TreeTapFluids;
import com.cannolicatfish.rankine.blocks.tap.TapBarrelBlock;
import com.cannolicatfish.rankine.init.Config;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineItems;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class TreeTapBlock
extends Block {
    public static final EnumProperty<TreeTapFluids> FLUID = EnumProperty.func_177709_a((String)"fluid", TreeTapFluids.class);
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    protected static final VoxelShape WEST_AABB = Block.func_208617_a((double)7.0, (double)9.0, (double)7.0, (double)16.0, (double)12.0, (double)9.0);
    protected static final VoxelShape EAST_AABB = Block.func_208617_a((double)0.0, (double)9.0, (double)7.0, (double)9.0, (double)12.0, (double)9.0);
    protected static final VoxelShape NORTH_AABB = Block.func_208617_a((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.func_208617_a((double)7.0, (double)9.0, (double)0.0, (double)9.0, (double)12.0, (double)9.0);
    protected static final VoxelShape TAP_WEST_AABB = Block.func_208617_a((double)5.0, (double)0.0, (double)4.0, (double)16.0, (double)13.0, (double)12.0);
    protected static final VoxelShape TAP_EAST_AABB = Block.func_208617_a((double)0.0, (double)0.0, (double)4.0, (double)11.0, (double)13.0, (double)12.0);
    protected static final VoxelShape TAP_NORTH_AABB = Block.func_208617_a((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)13.0, (double)16.0);
    protected static final VoxelShape TAP_SOUTH_AABB = Block.func_208617_a((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)13.0, (double)11.0);
    private int ticks = 0;

    public TreeTapBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.NONE))).func_206870_a((Property)FACING, (Comparable)Direction.NORTH));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (((TreeTapFluids)((Object)state.func_177229_b(FLUID))).equals((Object)TreeTapFluids.NONE)) {
            switch ((Direction)state.func_177229_b((Property)FACING)) {
                case NORTH: {
                    return NORTH_AABB;
                }
                case SOUTH: {
                    return SOUTH_AABB;
                }
                case WEST: {
                    return WEST_AABB;
                }
            }
            return EAST_AABB;
        }
        switch ((Direction)state.func_177229_b((Property)FACING)) {
            case NORTH: {
                return TAP_NORTH_AABB;
            }
            case SOUTH: {
                return TAP_SOUTH_AABB;
            }
            case WEST: {
                return TAP_WEST_AABB;
            }
        }
        return TAP_EAST_AABB;
    }

    public boolean func_149653_t(BlockState state) {
        return true;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        ++this.ticks;
        if (!worldIn.func_201670_d() && this.ticks >= (Integer)Config.MACHINES.TREE_TAP_SPEED.get() && this.isTreeAlive(pos, (World)worldIn)) {
            List<BlockPos> sides = Arrays.asList(pos.func_177984_a(), pos.func_177977_b(), pos.func_177978_c(), pos.func_177968_d(), pos.func_177976_e(), pos.func_177974_f());
            for (BlockPos s : sides) {
                if (worldIn.func_180495_p(s).func_177230_c() != RankineBlocks.TREE_TAP.get()) continue;
                return;
            }
            if (((TreeTapFluids)((Object)state.func_177229_b(FLUID))).equals((Object)TreeTapFluids.EMPTY)) {
                Block log = null;
                switch ((Direction)state.func_177229_b((Property)FACING)) {
                    case NORTH: {
                        log = worldIn.func_180495_p(pos.func_177968_d()).func_177230_c();
                        break;
                    }
                    case SOUTH: {
                        log = worldIn.func_180495_p(pos.func_177978_c()).func_177230_c();
                        break;
                    }
                    case EAST: {
                        log = worldIn.func_180495_p(pos.func_177976_e()).func_177230_c();
                        break;
                    }
                    case WEST: {
                        log = worldIn.func_180495_p(pos.func_177974_f()).func_177230_c();
                    }
                }
                if (log != null) {
                    if (log.getTags().contains(new ResourceLocation("rankine:logs_sap")) && ((Boolean)Config.MACHINES.TREE_TAP_SAP.get()).booleanValue()) {
                        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.SAP))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), 3);
                    } else if (log.getTags().contains(new ResourceLocation("rankine:logs_maple_sap")) && ((Boolean)Config.MACHINES.TREE_TAP_MAPLE_SAP.get()).booleanValue()) {
                        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.MAPLE_SAP))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), 3);
                    } else if (log.getTags().contains(new ResourceLocation("rankine:logs_resin")) && ((Boolean)Config.MACHINES.TREE_TAP_RESIN.get()).booleanValue()) {
                        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.RESIN))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), 3);
                    } else if (log.getTags().contains(new ResourceLocation("rankine:logs_latex")) && ((Boolean)Config.MACHINES.TREE_TAP_LATEX.get()).booleanValue()) {
                        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.LATEX))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), 3);
                    } else if (log.getTags().contains(new ResourceLocation("rankine:logs_juglone")) && ((Boolean)Config.MACHINES.TREE_TAP_JUGLONE.get()).booleanValue()) {
                        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.JUGLONE))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), 3);
                    } else if (log.getTags().contains(new ResourceLocation("rankine:logs_water")) && ((Boolean)Config.MACHINES.TREE_TAP_WATER.get()).booleanValue()) {
                        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.WATER))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), 3);
                    } else if (log.getTags().contains(new ResourceLocation("rankine:logs_lava")) && ((Boolean)Config.MACHINES.TREE_TAP_LAVA.get()).booleanValue()) {
                        worldIn.func_180501_a(pos, (BlockState)((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.LAVA))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)), 3);
                    }
                }
            }
            this.ticks = 0;
        }
        if (!worldIn.func_201670_d() && !((TreeTapFluids)((Object)state.func_177229_b(FLUID))).equals((Object)TreeTapFluids.NONE) && !((TreeTapFluids)((Object)state.func_177229_b(FLUID))).equals((Object)TreeTapFluids.EMPTY) && worldIn.func_180495_p(pos.func_177977_b()).func_177230_c().func_235332_a_((Block)RankineBlocks.TAP_LINE.get())) {
            BlockPos barrel = null;
            HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
            Stack<BlockPos> toCheck = new Stack<BlockPos>();
            toCheck.add(pos.func_177977_b());
            while (!toCheck.isEmpty()) {
                BlockPos cp = (BlockPos)toCheck.pop();
                if (checkedBlocks.contains(cp)) continue;
                checkedBlocks.add(cp);
                if (worldIn.func_175667_e(cp)) {
                    BlockState s = worldIn.func_180495_p(cp);
                    if (s.func_177230_c().func_235332_a_((Block)RankineBlocks.TAP_BARREL.get())) {
                        if ((Integer)s.func_177229_b((Property)TapBarrelBlock.LEVEL) < 6) {
                            barrel = cp;
                            break;
                        }
                    } else if (s.func_177230_c().func_235332_a_((Block)RankineBlocks.TAP_LINE.get())) {
                        toCheck.add(cp.func_177978_c());
                        toCheck.add(cp.func_177974_f());
                        toCheck.add(cp.func_177968_d());
                        toCheck.add(cp.func_177976_e());
                        toCheck.add(cp.func_177977_b());
                    }
                }
                if (checkedBlocks.size() <= 200) continue;
                break;
            }
            if (barrel != null) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.EMPTY)), 3);
                BlockState bb = worldIn.func_180495_p(barrel);
                int level = (Integer)bb.func_177229_b((Property)TapBarrelBlock.LEVEL);
                if (level == 0) {
                    worldIn.func_180501_a(barrel, (BlockState)((BlockState)bb.func_206870_a(TapBarrelBlock.FLUID, (Comparable)((Object)TapBarrelFluids.valueOf(((TreeTapFluids)((Object)state.func_177229_b(FLUID))).func_176610_l().toUpperCase())))).func_206870_a((Property)TapBarrelBlock.LEVEL, (Comparable)Integer.valueOf(1)), 3);
                } else if (level >= 1 && level < 6 && ((TapBarrelFluids)((Object)bb.func_177229_b(TapBarrelBlock.FLUID))).func_176610_l().equals(((TreeTapFluids)((Object)state.func_177229_b(FLUID))).func_176610_l())) {
                    worldIn.func_180501_a(barrel, (BlockState)((BlockState)bb.func_206870_a(TapBarrelBlock.FLUID, (Comparable)((Object)TapBarrelFluids.valueOf(((TreeTapFluids)((Object)state.func_177229_b(FLUID))).func_176610_l().toUpperCase())))).func_206870_a((Property)TapBarrelBlock.LEVEL, (Comparable)Integer.valueOf((Integer)bb.func_177229_b((Property)TapBarrelBlock.LEVEL) + 1)), 3);
                }
            }
        }
    }

    private boolean isTreeAlive(BlockPos pos, World worldIn) {
        HashSet<BlockPos> checkedBlocks = new HashSet<BlockPos>();
        Stack<BlockPos> toCheck = new Stack<BlockPos>();
        toCheck.add(pos.func_177972_a(((Direction)worldIn.func_180495_p(pos).func_177229_b((Property)FACING)).func_176734_d()));
        while (!toCheck.isEmpty()) {
            BlockPos cp = (BlockPos)toCheck.pop();
            if (checkedBlocks.contains(cp)) continue;
            checkedBlocks.add(cp);
            for (BlockPos b : BlockPos.func_218278_a((BlockPos)cp.func_177982_a(-1, -1, -1), (BlockPos)cp.func_177982_a(1, 1, 1))) {
                BlockState target = worldIn.func_180495_p(b.func_185334_h());
                if (target.func_177230_c().getTags().contains(new ResourceLocation("minecraft:leaves"))) {
                    if (((Boolean)target.func_177229_b((Property)LeavesBlock.field_208495_b)).booleanValue()) continue;
                    return true;
                }
                if (!target.func_177230_c().getTags().contains(new ResourceLocation("minecraft:logs"))) continue;
                toCheck.add(b.func_185334_h());
            }
            if (toCheck.size() <= 300) continue;
            break;
        }
        return false;
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        switch ((TreeTapFluids)((Object)state.func_177229_b(FLUID))) {
            case NONE: {
                ItemStack stack = player.func_184614_ca();
                if (stack.func_77973_b() == Items.field_151133_ar) {
                    worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.EMPTY))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)));
                    worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_232695_bC_, SoundCategory.BLOCKS, 1.0f, 0.8f + worldIn.field_73012_v.nextFloat() * 0.4f);
                    if (!player.field_71075_bZ.field_75098_d) {
                        stack.func_190918_g(1);
                    }
                    return ActionResultType.SUCCESS;
                }
                return ActionResultType.FAIL;
            }
            case EMPTY: {
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151133_ar, 1));
                break;
            }
            case WATER: {
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151131_as, 1));
                break;
            }
            case LAVA: {
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151129_at, 1));
                break;
            }
            case SAP: {
                player.func_191521_c(new ItemStack((IItemProvider)RankineItems.SAP_BUCKET.get(), 1));
                break;
            }
            case MAPLE_SAP: {
                player.func_191521_c(new ItemStack((IItemProvider)RankineItems.MAPLE_SAP_BUCKET.get(), 1));
                break;
            }
            case RESIN: {
                player.func_191521_c(new ItemStack((IItemProvider)RankineItems.RESIN_BUCKET.get(), 1));
                break;
            }
            case LATEX: {
                player.func_191521_c(new ItemStack((IItemProvider)RankineItems.LATEX_BUCKET.get(), 1));
                break;
            }
            case JUGLONE: {
                player.func_191521_c(new ItemStack((IItemProvider)RankineItems.JUGLONE_BUCKET.get(), 1));
            }
        }
        worldIn.func_175656_a(pos, (BlockState)((BlockState)state.func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.NONE))).func_206870_a((Property)FACING, state.func_177229_b((Property)FACING)));
        worldIn.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_232694_bB_, SoundCategory.BLOCKS, 1.0f, 0.5f + worldIn.field_73012_v.nextFloat() * 0.4f);
        return ActionResultType.SUCCESS;
    }

    private boolean canAttachTo(IBlockReader blockReader, BlockPos pos, Direction direction) {
        BlockState blockstate = blockReader.func_180495_p(pos);
        return blockstate.func_224755_d(blockReader, pos, direction);
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        Direction direction = (Direction)state.func_177229_b((Property)FACING);
        return this.canAttachTo((IBlockReader)worldIn, pos.func_177972_a(direction.func_176734_d()), direction);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a(FLUID, (Comparable)((Object)TreeTapFluids.NONE))).func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d());
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return facing.func_176734_d() == stateIn.func_177229_b((Property)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((Property)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((Property)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((Property)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{FLUID, FACING});
    }
}

