/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.client.integration.jei;

import com.cannolicatfish.rankine.blocks.alloyfurnace.AlloyFurnaceScreen;
import com.cannolicatfish.rankine.blocks.crucible.CrucibleScreen;
import com.cannolicatfish.rankine.blocks.evaporationtower.EvaporationTowerScreen;
import com.cannolicatfish.rankine.blocks.gyratorycrusher.GyratoryCrusherScreen;
import com.cannolicatfish.rankine.blocks.inductionfurnace.InductionFurnaceScreen;
import com.cannolicatfish.rankine.blocks.pistoncrusher.PistonCrusherScreen;
import com.cannolicatfish.rankine.client.integration.jei.RankineJEIRecipes;
import com.cannolicatfish.rankine.client.integration.jei.categories.AlloyingRecipeCategory;
import com.cannolicatfish.rankine.client.integration.jei.categories.BeehiveOvenRecipeCategory;
import com.cannolicatfish.rankine.client.integration.jei.categories.CrucibleRecipeCategory;
import com.cannolicatfish.rankine.client.integration.jei.categories.CrushingRecipeCategory;
import com.cannolicatfish.rankine.client.integration.jei.categories.EvaporationRecipeCategory;
import com.cannolicatfish.rankine.client.integration.jei.categories.SluicingRecipeCategory;
import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineItems;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIRankinePlugin
implements IModPlugin {
    @Nonnull
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("rankine", "jei_plugin");
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(AlloyFurnaceScreen.class, 98, 32, 24, 16, new ResourceLocation[]{AlloyingRecipeCategory.UID});
        registration.addRecipeClickArea(InductionFurnaceScreen.class, 98, 32, 24, 16, new ResourceLocation[]{AlloyingRecipeCategory.UID});
        registration.addRecipeClickArea(PistonCrusherScreen.class, 55, 58, 24, 16, new ResourceLocation[]{CrushingRecipeCategory.UID});
        registration.addRecipeClickArea(GyratoryCrusherScreen.class, 55, 58, 24, 16, new ResourceLocation[]{CrushingRecipeCategory.UID});
        registration.addRecipeClickArea(EvaporationTowerScreen.class, 76, 50, 24, 16, new ResourceLocation[]{EvaporationRecipeCategory.UID});
        registration.addRecipeClickArea(CrucibleScreen.class, 109, 46, 7, 26, new ResourceLocation[]{CrucibleRecipeCategory.UID});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        RankineJEIRecipes rankineJEIRecipes = new RankineJEIRecipes();
        registry.addRecipes(rankineJEIRecipes.getBeehiveRecipes(), BeehiveOvenRecipeCategory.UID);
        registry.addRecipes(rankineJEIRecipes.getSluicingRecipes(), SluicingRecipeCategory.UID);
        registry.addRecipes(rankineJEIRecipes.getEvaporationRecipes(), EvaporationRecipeCategory.UID);
        registry.addRecipes(rankineJEIRecipes.getCrushingRecipes(), CrushingRecipeCategory.UID);
        registry.addRecipes(rankineJEIRecipes.getAlloyingRecipes(), AlloyingRecipeCategory.UID);
        registry.addRecipes(rankineJEIRecipes.getCrucibleRecipes(), CrucibleRecipeCategory.UID);
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.COKE.get()), VanillaTypes.ITEM, new String[]{"Coke can be obtained by cooking Bituminous Coal Blocks in a beehive oven.", "See Beehive Oven Pit for more details."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.QUICKLIME.get()), VanillaTypes.ITEM, new String[]{"Quicklime can be obtained by cooking Limestone in a beehive oven.", "See Beehive Oven Pit for more details."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.MAGNESIA.get()), VanillaTypes.ITEM, new String[]{"Magnesia can be obtained by cooking a Block of Magnesite in a beehive oven.", "See Beehive Oven Pit for more details."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineBlocks.BEEHIVE_OVEN_PIT.get()), VanillaTypes.ITEM, new String[]{"The beehive oven is at minimum a 3x3 structure with a beehive oven pit in the center of 8 refractory bricks. The pit block must have access to the sky. Place blocks on the refractory bricks and light it to cook them over time."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineBlocks.EVAPORATION_TOWER.get()), VanillaTypes.ITEM, new String[]{"The evaporation tower is a complex multiblock which requires sheetmetal, magma blocks, and the Evaporation Tower block. See the modpage or the Patchouli book for details."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.ELEMENT_INDEXER.get()), VanillaTypes.ITEM, new String[]{"The Element Indexer is a device that can be used to analyze the properties of an element in an alloy. Scroll up and down to change the percentage."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineBlocks.TEMPLATE_TABLE.get()), VanillaTypes.ITEM, new String[]{"The Alloy Template Table can make templates to automate the alloy furnace. Paper and dye are required, and the template is determined by the arrangement of materials in the bottom row."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.ALLOY_TEMPLATE.get()), VanillaTypes.ITEM, new String[]{"Created using the Alloy Template Table. Paper and dye are required."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.FLINT_KNIFE.get()), VanillaTypes.ITEM, new String[]{"Right-clicking on grass blocks allows you to obtain grass and convert the original block into dirt at an increased durability cost.The knife can also harvest grass and vines by left clicking."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.COMPOST.get()), VanillaTypes.ITEM, new String[]{"Can be placed in the Composter."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.GAS_MASK.get()), VanillaTypes.ITEM, new String[]{"The gas mask prevents negative effects from standing in gas blocks when worn. Combine with a helmet in an anvil to add the enchantment Gas Protection which has the same effect."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.SANDALS.get()), VanillaTypes.ITEM, new String[]{"Sandals increase movement speed on sand blocks when worn. Combine with boots in an anvil to add the enchantment Dune Walker which has the same effect."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.SNOWSHOES.get()), VanillaTypes.ITEM, new String[]{"Snowshoes increase movement speed on snow blocks when worn. Combine with boots in an anvil to add the enchantment Snow Drifter which has the same effect."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.ICE_SKATES.get()), VanillaTypes.ITEM, new String[]{"Ice Skates increase movement speed on ice blocks when worn. Combine with boots in an anvil to add the enchantment Speed Skater which has the same effect."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)Items.field_151111_aL), VanillaTypes.ITEM, new String[]{"While held, the compass will display the holder's coordinates and direction. Default is head position, sneak for position at feet."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)Items.field_151113_aN), VanillaTypes.ITEM, new String[]{"While held, the clock will display the current game time on a 24 hour clock and in ticks."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.ALTIMETER.get()), VanillaTypes.ITEM, new String[]{"While held, the altimeter will display the holder's Y value. Default is head position, sneak for position at feet."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.PHOTOMETER.get()), VanillaTypes.ITEM, new String[]{"While held, the photometer will display the current light level. Default is head position, sneak for position at feet."});
        registry.addIngredientInfo((Object)new ItemStack((IItemProvider)RankineItems.THERMOMETER.get()), VanillaTypes.ITEM, new String[]{"While held, the thermometer will display the current block temperature. Default is head position, sneak for position at feet."});
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new BeehiveOvenRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrushingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new SluicingRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new EvaporationRecipeCategory(guiHelper)});
        registry.addRecipeCategories(new IRecipeCategory[]{new CrucibleRecipeCategory(guiHelper)});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.ALLOY_FURNACE.get()), new ResourceLocation[]{AlloyingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.INDUCTION_FURNACE.get()), new ResourceLocation[]{AlloyingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.BEEHIVE_OVEN_PIT.get()), new ResourceLocation[]{BeehiveOvenRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.HIGH_BEEHIVE_OVEN_PIT.get()), new ResourceLocation[]{BeehiveOvenRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.ULTRA_HIGH_BEEHIVE_OVEN_PIT.get()), new ResourceLocation[]{BeehiveOvenRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.PISTON_CRUSHER.get()), new ResourceLocation[]{CrushingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.GYRATORY_CRUSHER.get()), new ResourceLocation[]{CrushingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineItems.STEEL_GOLD_PAN.get()), new ResourceLocation[]{SluicingRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.EVAPORATION_TOWER.get()), new ResourceLocation[]{EvaporationRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)RankineBlocks.CRUCIBLE_BLOCK.get()), new ResourceLocation[]{CrucibleRecipeCategory.UID});
    }
}

