/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.client.integration.jei.categories;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.recipe.AlloyingRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.StringTextComponent;

public class AlloyingRecipeCategory
implements IRecipeCategory<AlloyingRecipe> {
    public static ResourceLocation UID = new ResourceLocation("rankine", "alloying");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public AlloyingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(185, 146);
        this.localizedName = I18n.func_135052_a((String)"rankine.jei.alloy", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("rankine", "textures/gui/alloying_jei.png"), 0, 15, 180, 141);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RankineBlocks.ALLOY_FURNACE.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends AlloyingRecipe> getRecipeClass() {
        return AlloyingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(AlloyingRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
        String s = "Made in:";
        int tier = recipe.getTier();
        int ymod = 0;
        font.func_238421_b_(ms, s, (float)(90 - font.func_78256_a(s) / 2), (float)ymod, 0);
        if ((tier & 1) != 0) {
            s = "Alloy Furnace";
            font.func_238421_b_(ms, s, (float)(90 - font.func_78256_a(s) / 2), (float)(ymod += 10), 0);
        }
        if ((tier & 2) != 0) {
            s = "Induction Furnace";
            font.func_238421_b_(ms, s, (float)(90 - font.func_78256_a(s) / 2), (float)(ymod += 10), 0);
        }
    }

    public void setIngredients(AlloyingRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient i : recipe.func_192400_c()) {
            builder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutputs(VanillaTypes.ITEM, Collections.singletonList(recipe.func_77571_b()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, AlloyingRecipe recipe, IIngredients ingredients) {
        int index = 0;
        List<Integer> reqIndex = recipe.getIndexList(true);
        int reqCounter = 0;
        int nonReqCounter = 0;
        int reducer = 0;
        int ymod = -1;
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            if (reqIndex.contains(ingredients.getInputs(VanillaTypes.ITEM).indexOf(o))) {
                recipeLayout.getItemStacks().init(index, true, reqCounter * 18, 39);
                ++reqCounter;
            } else {
                if (nonReqCounter % 10 == 0) {
                    reducer = nonReqCounter;
                    ++ymod;
                }
                recipeLayout.getItemStacks().init(index, true, (nonReqCounter - reducer) * 18, 58 + 18 * ymod);
                ++nonReqCounter;
            }
            recipeLayout.getItemStacks().set(index, o);
            ++index;
        }
        int endIndex = index;
        recipeLayout.getItemStacks().addTooltipCallback((i, b, stack, list) -> {
            if (i != endIndex) {
                list.add(new StringTextComponent("Min: " + Math.round(((Float)recipe.getMins().get(i)).floatValue() * 100.0f) + "%"));
                list.add(new StringTextComponent("Max: " + Math.round(((Float)recipe.getMaxes().get(i)).floatValue() * 100.0f) + "%"));
            }
        });
        for (int i2 = 0; i2 < ingredients.getOutputs(VanillaTypes.ITEM).size(); ++i2) {
            List stacks = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(i2);
            recipeLayout.getItemStacks().init(index + i2, false, 19, 10);
            recipeLayout.getItemStacks().set(index + i2, stacks);
        }
    }
}

