/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.client.integration.jei.categories;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.recipe.BeehiveOvenRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class BeehiveOvenRecipeCategory
implements IRecipeCategory<BeehiveOvenRecipe> {
    public static ResourceLocation UID = new ResourceLocation("rankine", "beeoven");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public BeehiveOvenRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(145, 95);
        this.localizedName = I18n.func_135052_a((String)"rankine.jei.beeoven", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("rankine", "textures/gui/beeoven_jei.png"), 0, 15, 140, 90);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RankineBlocks.BEEHIVE_OVEN_PIT.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends BeehiveOvenRecipe> getRecipeClass() {
        return BeehiveOvenRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(BeehiveOvenRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }

    public void setIngredients(BeehiveOvenRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient i : recipe.func_192400_c()) {
            builder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutputs(VanillaTypes.ITEM, Collections.singletonList(recipe.func_77571_b()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, BeehiveOvenRecipe recipe, IIngredients ingredients) {
        int index = 0;
        int posX = 31;
        for (List o : ingredients.getInputs(VanillaTypes.ITEM)) {
            recipeLayout.getItemStacks().init(index, true, posX, 21);
            recipeLayout.getItemStacks().set(index, o);
            ++index;
            posX += 18;
        }
        for (int i = 0; i < ingredients.getOutputs(VanillaTypes.ITEM).size(); ++i) {
            List stacks = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(i);
            recipeLayout.getItemStacks().init(index + i, false, 106, 34);
            recipeLayout.getItemStacks().set(index + i, stacks);
        }
        int endIndex = index;
        ResourceLocation recipeId = recipe.func_199560_c();
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (slotIndex >= endIndex && (Minecraft.func_71410_x().field_71474_y.field_82882_x || Screen.func_231173_s_())) {
                tooltip.add(new TranslationTextComponent("jei.tooltip.recipe.id", new Object[]{recipeId}).func_240699_a_(TextFormatting.DARK_GRAY));
            }
        });
    }
}

