/*
 * Decompiled with CFR 0.152.
 */
package com.cannolicatfish.rankine.client.integration.jei.categories;

import com.cannolicatfish.rankine.init.RankineBlocks;
import com.cannolicatfish.rankine.init.RankineItems;
import com.cannolicatfish.rankine.recipe.CrucibleRecipe;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class CrucibleRecipeCategory
implements IRecipeCategory<CrucibleRecipe> {
    public static ResourceLocation UID = new ResourceLocation("rankine", "crucible");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;

    public CrucibleRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(185, 146);
        this.localizedName = I18n.func_135052_a((String)"rankine.jei.crucible", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(new ResourceLocation("rankine", "textures/gui/crucible_jei.png"), 0, 15, 180, 141);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)RankineBlocks.CRUCIBLE_BLOCK.get()));
    }

    public ResourceLocation getUid() {
        return UID;
    }

    public Class<? extends CrucibleRecipe> getRecipeClass() {
        return CrucibleRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void draw(CrucibleRecipe recipe, MatrixStack ms, double mouseX, double mouseY) {
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.overlay.draw(ms, 0, 4);
        RenderSystem.disableBlend();
        RenderSystem.disableAlphaTest();
    }

    public void setIngredients(CrucibleRecipe recipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient i : recipe.getCondensedIngredients()) {
            builder.add(Arrays.asList(i.func_193365_a()));
        }
        iIngredients.setInputLists(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutputs(VanillaTypes.ITEM, Arrays.asList(recipe.getPrimaryOutput(), recipe.getSecondaryOutput()));
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrucibleRecipe recipe, IIngredients ingredients) {
        int index = 0;
        int i = 0;
        while (i < ingredients.getInputs(VanillaTypes.ITEM).size()) {
            if (i < 4) {
                recipeLayout.getItemStacks().init(i, false, 14 + 45 * i, 44);
            } else {
                int floor = Math.floorDiv(i - 4, 10);
                recipeLayout.getItemStacks().init(i, true, (i - 4 - 10 * floor) * 18 + 2, 80 + 16 * floor);
            }
            if (!((List)ingredients.getInputs(VanillaTypes.ITEM).get(i)).contains(ItemStack.field_190927_a) && ((List)ingredients.getInputs(VanillaTypes.ITEM).get(i)).stream().noneMatch(s -> s.func_77973_b() == RankineItems.ELEMENT.get())) {
                recipeLayout.getItemStacks().set(i, (List)ingredients.getInputs(VanillaTypes.ITEM).get(i));
            }
            index = i++;
        }
        for (i = 0; i < ingredients.getOutputs(VanillaTypes.ITEM).size(); ++i) {
            List stacks = (List)ingredients.getOutputs(VanillaTypes.ITEM).get(i);
            recipeLayout.getItemStacks().init(index + i + 1, false, 69 + 25 * i, 10);
            recipeLayout.getItemStacks().set(index + i + 1, stacks);
        }
    }
}

